/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.gui;

import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import sweetmagic.SweetMagicCore;
import sweetmagic.init.TagInit;
import sweetmagic.init.tile.gui.GuiSMBase;
import sweetmagic.init.tile.gui.util.SMButton;
import sweetmagic.init.tile.gui.util.SMRenderTex;
import sweetmagic.init.tile.menu.AetherHopperMenu;
import sweetmagic.init.tile.sm.TileAetherHopper;

public class GuiAetherHopper
extends GuiSMBase<AetherHopperMenu> {
    private static final ResourceLocation TEX = SweetMagicCore.getSRC("textures/gui/gui_aether_hopper.png");
    private static final ResourceLocation ADVANCED = SweetMagicCore.getSRC("textures/gui/gui_advanced_aether_hopper.png");
    private static final List<ItemStack> WAND = GuiSMBase.getTagStack(TagInit.MF_STUFF);
    private final boolean isAdavanced;
    private final TileAetherHopper tile;

    public GuiAetherHopper(AetherHopperMenu menu, Inventory pInv, Component title) {
        super(menu, pInv, title);
        this.tile = menu.tile;
        this.isAdavanced = menu.invSize == 48;
        this.setGuiSize(176, this.isAdavanced ? 226 : 175);
        this.addButtonMap(0, new SMButton(MISC, 160, -11, 114, 0, 10, 9, new SMButton.SMButtonTip("sort", -18, 14)));
        this.addButtonMap(1, new SMButton(MISC, 148, -11, 137, 0, 11, 9, new SMButton.SMButtonTip("quick_stack", -18, 14)));
        this.addButtonMap(2, new SMButton(MISC, 136, -11, 161, 0, 11, 9, new SMButton.SMButtonTip("restock", -18, 14)));
        this.addButtonMap(3, new SMButton(MISC, 124, -11, 185, 33, 11, 9, new SMButton.SMButtonTip("filter", -18, 14)));
        this.addRenderTexList(new SMRenderTex(MISC, 7, 10, 0, 0, 11, 77, new SMRenderTex.MFRenderGage(this.tile, true)));
    }

    @Override
    protected void m_7286_(GuiGraphics pose, float parTick, int mouseX, int mouseY) {
        super.m_7286_(pose, parTick, mouseX, mouseY);
        this.renderStock(this.tile.getInputList(), pose, 1, 2, 0, 0);
        this.renderSlotItem(((AetherHopperMenu)this.menu).wandSlot, this.getViewStack(WAND), pose);
        ItemStack stack = this.tile.getWandItem();
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_("X")) {
            return;
        }
        int x = tag.m_128451_("X");
        int y = tag.m_128451_("Y");
        int z = tag.m_128451_("Z");
        String testPos = ": " + x + ", " + y + ", " + z;
        BlockPos pos = new BlockPos(x, y, z);
        ChatFormatting color = this.tile.isChest ? GREEN : RED;
        int tipX = this.getWidth() + 50;
        int tipY = this.getHeight() + 74;
        if (this.isAdavanced) {
            tipX -= 19;
            tipY += 53;
            if (this.tile.targetBlock != null) {
                pose.m_280480_(new ItemStack((ItemLike)this.tile.targetBlock), tipX + 121, tipY - 4);
            }
        }
        this.drawFont(pose, (Component)this.getTipArray(new Object[]{this.getText("regi_pos"), testPos}).m_130940_(color), 116.0f, tipX, tipY, 2868292, true);
    }

    @Override
    protected void m_280003_(GuiGraphics pose, int mouseX, int mouseY) {
        super.m_280003_(pose, mouseX, mouseY);
        this.renderItemLabel(((AetherHopperMenu)this.menu).wandSlot, this.getViewStack(WAND), pose, mouseX, mouseY, Arrays.asList(this.getText("send_stuff_0").m_130940_(GOLD), this.getText("send_stuff_1").m_130940_(GOLD), this.empty(), this.getText("can_stuff").m_130940_(GREEN), this.getViewStack(WAND).m_41611_()));
        if (!this.isAdavanced || !this.isRender2(this.getWidth() + 151, this.getHeight() + 122, mouseX, mouseY, 18, 18)) {
            return;
        }
        ItemStack stack = this.tile.getWandItem();
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_("X") || this.tile.targetBlock == null) {
            return;
        }
        int xAxis = mouseX - this.getWidth();
        int yAxis = mouseY - this.getHeight();
        int x = tag.m_128451_("X");
        int y = tag.m_128451_("Y");
        int z = tag.m_128451_("Z");
        BlockPos pos = new BlockPos(tag.m_128451_("X"), tag.m_128451_("Y"), tag.m_128451_("Z"));
        this.renderTooltip(pose, new ItemStack((ItemLike)this.tile.targetBlock), xAxis, yAxis);
    }

    @Override
    public List<Integer> getInvRenderArray() {
        return List.of(Integer.valueOf(7), Integer.valueOf(92), Integer.valueOf(25), Integer.valueOf(10));
    }

    @Override
    public int getInvY() {
        return 3;
    }

    @Override
    public int getInvX() {
        return 8;
    }

    @Override
    protected ResourceLocation getTEX() {
        return this.isAdavanced ? ADVANCED : TEX;
    }
}

