/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.gui;

import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import sweetmagic.SweetMagicCore;
import sweetmagic.init.BlockInit;
import sweetmagic.init.tile.gui.GuiSMBase;
import sweetmagic.init.tile.menu.CardboardStorageMenu;
import sweetmagic.init.tile.slot.MagiaSlot;
import sweetmagic.init.tile.sm.TileCardboardStorage;

public class GuiCardboardStorage
extends GuiSMBase<CardboardStorageMenu> {
    private static final ResourceLocation TEX = SweetMagicCore.getSRC("textures/gui/gui_moden_rack.png");
    public final TileCardboardStorage tile;
    private static final ItemStack STORAGE = new ItemStack((ItemLike)BlockInit.cardboard_storage);

    public GuiCardboardStorage(CardboardStorageMenu menu, Inventory pInv, Component title) {
        super(menu, pInv, title);
        this.setGuiSize(173, 132);
        this.tile = menu.tile;
    }

    @Override
    protected void m_7286_(GuiGraphics pose, float parTick, int mouseX, int mouseY) {
        super.m_7286_(pose, parTick, mouseX, mouseY);
        pose.m_280218_(this.getTEX(), this.getWidth() + 78, this.getHeight() + 9, 173, 0, 18, 18);
        pose.m_280218_(this.getTEX(), this.getWidth() + 148, this.getHeight() + 29, 173, 0, 18, 18);
        this.renderSlotItem(((CardboardStorageMenu)this.menu).storageSlot, STORAGE, pose, 0);
    }

    @Override
    protected void m_280003_(GuiGraphics pose, int mouseX, int mouseY) {
        super.m_280003_(pose, mouseX, mouseY);
        this.renderItemLabel(((CardboardStorageMenu)this.menu).storageSlot, STORAGE, pose, mouseX, mouseY);
    }

    @Override
    public void m_88315_(GuiGraphics pose, int mouseX, int mouseY, float parTick) {
        this.renderMagiaStack(pose, mouseX, mouseY, parTick, ((CardboardStorageMenu)this.menu).slotList, (NonNullList<Slot>)((CardboardStorageMenu)this.menu).f_38839_);
    }

    @Override
    public void renderTooltip(GuiGraphics pose, ItemStack stack, int x, int y) {
        this.renderMagiaStackTooltip(pose, stack, x, y, ((CardboardStorageMenu)this.menu).slotList);
    }

    @Override
    protected void renderMagiaStackTooltip(GuiGraphics pose, ItemStack stack, int x, int y, NonNullList<Slot> slotList) {
        List<Component> tipList = this.getTooltipFromItem(stack);
        Slot slot = this.f_97734_;
        if (slot instanceof MagiaSlot) {
            MagiaSlot slot2 = (MagiaSlot)slot;
            int vCount = (Integer)this.stackCountMap.get((Object)slot2);
            if (vCount <= 0) {
                return;
            }
            Integer value = (Integer)this.stackCountMap.get(slotList.get(1));
            if (value == null) {
                this.renderTooltip(pose, tipList, stack.m_150921_(), x, y);
                return;
            }
            int vMax = this.tile.getMaxStackSize(value);
            String count = this.format(vCount) + "/";
            String max = this.format(vMax);
            String par = " (" + this.format((float)vCount / (float)vMax * 100.0f) + "%)";
            tipList.add((Component)this.getLabel(count + max + par, GOLD));
        }
        this.renderTooltip(pose, tipList, stack.m_150921_(), x, y);
    }

    @Override
    public void setTip(List<Component> tipList, ItemStack stack) {
        tipList.addAll(Arrays.asList(this.getText("slot_need").m_130940_(GREEN), stack.m_41611_()));
        tipList.add((Component)this.getText("max_stackup").m_130940_(GOLD));
    }

    @Override
    protected ResourceLocation getTEX() {
        return TEX;
    }
}

