/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.gui;

import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import sweetmagic.SweetMagicCore;
import sweetmagic.init.tile.gui.GuiSMBase;
import sweetmagic.init.tile.gui.util.SMButton;
import sweetmagic.init.tile.menu.FurnitureTableMenu;
import sweetmagic.init.tile.sm.TileFurnitureTable;

public class GuiFurnitureTable
extends GuiSMBase<FurnitureTableMenu> {
    private static final ResourceLocation TEX = SweetMagicCore.getSRC("textures/gui/gui_furniture_processing_table.png");
    private final TileFurnitureTable tile;
    private final FurnitureTableMenu menu;
    private float scrollOffset = 0.0f;
    private int startIndex = 0;
    private boolean scrolling = false;
    private boolean[] isView = new boolean[24];

    public GuiFurnitureTable(FurnitureTableMenu menu, Inventory pInv, Component title) {
        super(menu, pInv, title);
        this.tile = menu.tile;
        this.menu = menu;
        this.setGuiSize(176, 252);
        SMButton.SMButtonTip buttonTip = new SMButton.SMButtonTip("", 40, -3, this.tile){

            public boolean isFlagText(TileFurnitureTable tile) {
                return tile.isSelect;
            }

            @Override
            public String getTip() {
                return this.isFlagText(GuiFurnitureTable.this.tile) ? "caraft_start" : "select_recipe";
            }
        };
        SMButton button = new SMButton(MISC, 9, 90, 114, 15, 32, 12, buttonTip){

            @Override
            public boolean isButtonRender() {
                return GuiFurnitureTable.this.tile.isSelect;
            }
        };
        this.addButtonMap(0, button);
        SMButton.SMButtonTip buttonTip2 = new SMButton.SMButtonTip("", 30, -3, this.tile){

            public boolean isFlagText(TileFurnitureTable tile) {
                return tile.isSelect;
            }

            @Override
            public String getTip() {
                return this.isFlagText(GuiFurnitureTable.this.tile) ? "select_count" : "select_recipe";
            }
        };
        this.addButtonMap(1, new SMButton(TEX, 36, 71, 178, 77, 18, 11, buttonTip2));
    }

    @Override
    protected void m_7286_(GuiGraphics pose, float parTick, int mouseX, int mouseY) {
        super.m_7286_(pose, parTick, mouseX, mouseY);
        RegistryAccess acce = this.tile.m_58904_().m_9598_();
        List<Recipe<?>> recipeList = this.getRecipeList();
        if (recipeList.isEmpty()) {
            this.startIndex = 0;
            this.scrollOffset = 0.0f;
            return;
        }
        int x = this.getWidth() + 58;
        int y = this.getHeight() + 31;
        int index = this.startIndex * 6;
        int yIndex = -this.startIndex * 18;
        for (int i = index; i < recipeList.size() && i - index < 24; ++i) {
            int pX = x + i * 16 - i / 6 * 96;
            int pY = y + i / 6 * 18 + yIndex;
            boolean isView = i >= index || i < index + 24 ? this.isView[i - index] : false;
            int viewY = 20 + (isView ? 18 : 0);
            if (this.tile.isSelect) {
                viewY = i + 2 == this.tile.selectId ? 56 : viewY;
            }
            pose.m_280218_(this.getTEX(), pX, pY, 178, viewY, 18, 18);
        }
        int h = (int)(60.0f * this.scrollOffset);
        boolean isActive = this.scrollbarActive();
        pose.m_280218_(this.getTEX(), x + 102, y + 7 + h - 8, 178 + (isActive ? 0 : 8), 0, 8, 15);
        if (!isActive && !this.tile.isCraft) {
            this.startIndex = 0;
            this.scrollOffset = 0.0f;
        }
        for (int i = index; i < recipeList.size() && i - index < 24; ++i) {
            Recipe<?> recipe = recipeList.get(i);
            ItemStack result = recipe.m_8043_(acce);
            int pX = x + i * 16 - i / 6 * 96;
            int pY = y + i / 6 * 18 + 1 + yIndex;
            pose.m_280480_(result, pX, pY);
            pose.m_280302_(this.f_96547_, result, pX, pY, null);
        }
        if (!this.menu.inputSlot.m_7993_().m_41619_() && this.tile.outStack.m_41619_() && this.tile.isSelect) {
            this.tile.outStack = this.menu.recipeList.get(this.tile.selectId - 1).m_8043_(acce).m_41777_();
        }
        this.renderSlotItem(this.menu.resultSlot, this.tile.outStack, this.tile.setCount, pose);
    }

    @Override
    protected void m_280003_(GuiGraphics pose, int mouseX, int mouseY) {
        super.m_280003_(pose, mouseX, mouseY);
        int x = this.getWidth() + 58;
        int y = this.getHeight() + 31;
        int w = 16;
        int h = 17;
        int texSizeX = this.getWidth();
        int texSizeY = this.getHeight();
        RegistryAccess acce = this.tile.m_58904_().m_9598_();
        for (int pX = 0; pX < 6; ++pX) {
            for (int pY = 0; pY < 4; ++pY) {
                int index = pX + pY * 6;
                this.isView[index] = false;
                int tX = x + pX * 16;
                int tY = y + pY * 18;
                if (!this.isRender(tX, tY, mouseX, mouseY, w - 1, h)) continue;
                this.isView[index] = true;
                if ((index += this.startIndex * 6) >= this.getRecipeList().size()) continue;
                int xAxis = mouseX - texSizeX;
                int yAxis = mouseY - texSizeY;
                this.renderTooltip(pose, this.getRecipeList().get(pX + (pY + this.startIndex) * 6).m_8043_(acce), xAxis, yAxis);
            }
        }
        if (!this.menu.inputSlot.m_7993_().m_41619_() && this.tile.outStack.m_41619_() && this.tile.isSelect) {
            this.tile.outStack = this.menu.recipeList.get(this.tile.selectId - 1).m_8043_(acce).m_41777_();
        }
        if (!this.tile.outStack.m_41619_()) {
            this.renderItemLabel(this.menu.resultSlot, this.tile.outStack, pose, mouseX, mouseY, Arrays.asList(this.getText("craft_item").m_130940_(GREEN), this.tile.outStack.m_41786_()));
        }
    }

    @Override
    public boolean m_6375_(double guiX, double guiY, int mouseButton) {
        this.scrolling = false;
        int aX = this.f_97735_ + 160;
        int aY = (int)((float)(this.f_97736_ + 30) + this.scrollOffset * 60.0f);
        int w = 8;
        int h = 14;
        if (guiX >= (double)aX && guiX < (double)(aX + w) && guiY >= (double)aY && guiY < (double)(aY + h)) {
            this.scrolling = true;
        }
        int x = this.getWidth() + 58;
        int y = this.getHeight() + 31;
        double dX = guiX - (double)x;
        double dY = guiY - (double)y;
        w = 16;
        h = 18;
        for (int pX = 0; pX < 6; ++pX) {
            int index;
            int i;
            for (int pY = 0; pY < 4 && (i = pX + pY * 6) < (index = i + this.startIndex * 6) + 24; ++pY) {
                double tX = dX - (double)(pX * w);
                double tY = dY - (double)(pY * h);
                if (!(tX >= 0.0) || !(tX < (double)w) || !(tY >= 0.0) || !(tY < (double)h)) continue;
                int buttonId = pX + pY * 6 + 2 + this.startIndex * 6;
                this.clickButton(buttonId);
            }
        }
        return super.m_6375_(guiX, guiY, mouseButton);
    }

    public boolean m_7979_(double mouseX, double mouseY, int mouseButton, double dragX, double dragY) {
        List<Recipe<?>> recipeList = this.getRecipeList();
        int size = recipeList.size();
        if (!this.scrolling || !this.scrollbarActive()) {
            return super.m_7979_(mouseX, mouseY, mouseButton, dragX, dragY);
        }
        int i = this.f_97736_ + 20;
        int j = i + 73;
        int offscreenRows = size / 6 - 3;
        this.scrollOffset = ((float)mouseY - (float)i - 15.0f) / ((float)(j - i) - 15.0f);
        this.scrollOffset = Mth.m_14036_((float)this.scrollOffset, (float)0.0f, (float)1.0f);
        this.startIndex = (int)((double)(this.scrollOffset * (float)offscreenRows) + 0.5);
        return true;
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollDelta) {
        int y;
        if (!this.scrollbarActive()) {
            return super.m_6050_(mouseX, mouseY, scrollDelta);
        }
        int x = this.getWidth() + 33;
        if (this.isRender(x, y = this.getHeight() + 25, (int)mouseX, (int)mouseY, 142, 86) || Screen.m_96638_()) {
            List<Recipe<?>> recipeList = this.getRecipeList();
            int size = recipeList.size();
            int offscreenRows = size / 6 - 3;
            this.scrollOffset = (float)((double)this.scrollOffset - scrollDelta / (double)offscreenRows);
            this.scrollOffset = Mth.m_14036_((float)this.scrollOffset, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffset * (float)offscreenRows) + 0.5);
            return true;
        }
        return super.m_6050_(mouseX, mouseY, scrollDelta);
    }

    @Override
    protected ResourceLocation getTEX() {
        return TEX;
    }

    private boolean scrollbarActive() {
        return this.getRecipeList().size() > 24;
    }

    public List<Recipe<?>> getRecipeList() {
        return this.menu.recipeList;
    }
}

