/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.gui;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import sweetmagic.SweetMagicCore;
import sweetmagic.init.ItemInit;
import sweetmagic.init.tile.gui.GuiSMBase;
import sweetmagic.init.tile.gui.util.SMButton;
import sweetmagic.init.tile.menu.ItemFilterMenu;
import sweetmagic.init.tile.sm.TileAbstractSM;

public class GuiItemFilter
extends GuiSMBase<ItemFilterMenu> {
    private static final ResourceLocation TEX = SweetMagicCore.getSRC("textures/gui/gui_item_filter.png");
    private static final ItemStack WHITE = new ItemStack((ItemLike)ItemInit.blank_page);
    private static final ItemStack BLACK = new ItemStack((ItemLike)ItemInit.blank_page_black);
    private final TileAbstractSM tile;

    public GuiItemFilter(ItemFilterMenu menu, Inventory pInv, Component title) {
        super(menu, pInv, title);
        this.tile = menu.tile;
        this.setGuiSize(175, 129);
        SMButton.SMButtonTip tip = new SMButton.SMButtonTip("whitelist", -18, 0, this.tile){

            @Override
            public String getTip() {
                return this.getTile().isBlackList ? "blacklist" : super.getTip();
            }
        };
        this.addButtonMap(0, new SMButton(TEX, 141, 7, 176, 0, 18, 18, tip));
        this.addButtonMap(1, new SMButton(TEX, 136, 28, 176, 17, 29, 13));
    }

    @Override
    protected void m_7286_(GuiGraphics pose, float parTick, int mouseX, int mouseY) {
        super.m_7286_(pose, parTick, mouseX, mouseY);
        int x = this.getWidth();
        int y = this.getHeight();
        pose.m_280480_(this.tile.isBlackList ? BLACK : WHITE, x + 143, y + 8);
        this.drawShadow(pose, (Component)this.getText("decision"), x + 142, y + 30, 0xEEEEEE);
        ((ItemFilterMenu)this.menu).filterSlot.forEach(s -> {
            int sX = x + s.f_40220_;
            int sY = y + s.f_40221_;
            pose.m_280509_(sX, sY, sX + 16, sY + 16, 0x30FFFFFF);
        });
    }

    @Override
    protected ResourceLocation getTEX() {
        return TEX;
    }
}

