/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import sweetmagic.SweetMagicCore;
import sweetmagic.api.SweetMagicAPI;
import sweetmagic.handler.PacketHandler;
import sweetmagic.init.tile.gui.GuiSMBase;
import sweetmagic.init.tile.gui.util.SMButton;
import sweetmagic.init.tile.gui.util.SMRenderTex;
import sweetmagic.init.tile.menu.MFBottlerMenu;
import sweetmagic.init.tile.sm.TileMFBottler;
import sweetmagic.packet.BottlerPKT;

public class GuiMFBottler
extends GuiSMBase<MFBottlerMenu> {
    private static final ResourceLocation TEX = SweetMagicCore.getSRC("textures/gui/gui_mf_bottler.png");
    private final TileMFBottler tile;
    private float scrollOffset = 0.0f;
    private int startIndex = 0;
    private boolean scrolling = false;
    private boolean[] enchaView = new boolean[4];
    private boolean[] cancelView = new boolean[6];
    private boolean craftView = false;
    private int selectId = -1;

    public GuiMFBottler(MFBottlerMenu menu, Inventory pInv, Component title) {
        super(menu, pInv, title);
        this.setGuiSize(183, 235);
        this.tile = menu.tile;
        this.scrolling = false;
        this.startIndex = 0;
        this.scrollOffset = 0.0f;
        if (this.tile.selectId != -1) {
            this.selectId = this.tile.selectId;
        }
        this.addButtonMap(0, new SMButton(TEX, 19, 16, 198, 229, 20, 11));
        this.addButtonMap(1, new SMButton(TEX, 40, 16, 198, 229, 20, 11));
        this.addButtonMap(2, new SMButton(TEX, 19, 50, 198, 229, 20, 11));
        this.addButtonMap(3, new SMButton(TEX, 40, 50, 198, 229, 20, 11));
        this.addRenderTexList(new SMRenderTex(MISC, 5, 7, 0, 0, 11, 77, new SMRenderTex.MFRenderGage(menu.tile, true)));
    }

    @Override
    protected void m_7286_(GuiGraphics gra, float parTick, int mouseX, int mouseY) {
        super.m_7286_(gra, parTick, mouseX, mouseY);
        int x = this.getWidth();
        int y = this.getHeight();
        List<ItemStack> stackList = this.tile.getStackList();
        int size = stackList.size();
        int maxItemList = Math.min(4, size);
        for (int i = 0; i < maxItemList; ++i) {
            gra.m_280218_(this.getTEX(), x + 64, y + 7 + i * 20, this.enchaView[i] ? 98 : 0, 216, 98, 20);
        }
        int h = (int)(60.0f * this.scrollOffset);
        boolean isActive = this.scrollbarActive();
        gra.m_280218_(MISC, x + 167, y + 9 + h, 83 + (isActive ? 0 : 8), 93, 8, 15);
        int addY = 0;
        if (this.craftView && this.selectId != -1) {
            addY += 24;
        } else if (this.selectId != -1) {
            addY += 12;
        }
        gra.m_280218_(MISC, x + 23, y + 70, 20, 54 + addY, 32, 12);
        for (int id = 0; id < 4; ++id) {
            gra.m_280218_(MISC, x + 64, y + 7 + id * 20, 99, 93, 101, 20);
        }
        for (int i = 0; i < maxItemList && i + this.startIndex < size; ++i) {
            gra.m_280218_(MISC, x + 64, y + 7 + i * 20, 99, this.enchaView[i] ? 133 : 113, 101, 20);
            if (i + this.startIndex != this.selectId) continue;
            gra.m_280218_(MISC, x + 64, y + 7 + i * 20, 99, 153, 98, 20);
        }
        this.drawShadow(gra, (Component)this.getLabel("+1"), x + 24, y + 18, 0xEEEEEE);
        this.drawShadow(gra, (Component)this.getLabel("-1"), x + 45, y + 18, 0xEEEEEE);
        this.drawShadow(gra, (Component)this.getLabel("+10"), x + 20, y + 52, 0xEEEEEE);
        this.drawShadow(gra, (Component)this.getLabel("-10"), x + 41, y + 52, 0xEEEEEE);
        MutableComponent com = this.getLabel(this.tile.setCount);
        this.drawShadow(gra, (Component)com, x + 55 - this.f_96547_.m_92895_(com.getString()), y + 34, 0xEEEEEE);
        for (int i = 0; i < maxItemList && i + this.startIndex < size; ++i) {
            ItemStack stack = stackList.get(i + this.startIndex);
            this.drawFont(gra, (Component)((MutableComponent)stack.m_41786_()).m_130940_(GREEN), 82.0f, x + 81, y + 12 + i * 20, 0xEEEEEE, true);
            gra.m_280480_(stack, x + 67, y + 8 + i * 20);
        }
        PoseStack pose = gra.m_280168_();
        int listSize = Math.min(6, this.tile.outStackList.size());
        for (int i = 0; i < listSize; ++i) {
            int pX = x + 65 + i * 18;
            int pY = y + 92;
            ItemStack stack = this.tile.outStackList.get(i);
            gra.m_280480_(stack, pX, pY);
            gra.m_280302_(this.f_96547_, stack, pX, pY, null);
            pose.m_85836_();
            pose.m_85837_(0.0, 0.0, 200.0);
            gra.m_280218_(this.getTEX(), pX + 10, pY - 1, 187 + (this.cancelView[i] ? 7 : 0), 91, 7, 7);
            pose.m_85849_();
        }
    }

    @Override
    protected void m_280003_(GuiGraphics pose, int mouseX, int mouseY) {
        super.m_280003_(pose, mouseX, mouseY);
        int xAxis = mouseX - this.getWidth();
        int yAxis = mouseY - this.getHeight();
        int tipX = this.getWidth() + 64;
        int tipY = this.getHeight() + 6;
        List<ItemStack> stackList = this.tile.getStackList();
        int size = stackList.size();
        int maxItemList = Math.min(4, size);
        for (int id = 0; id < maxItemList && id + this.startIndex < size; ++id) {
            this.enchaView[id] = false;
            if (this.isRender(tipX, tipY, mouseX, mouseY, 98, 19)) {
                int cost = SweetMagicAPI.getMF(stackList.get(id + this.startIndex));
                String tip = this.format(cost);
                this.renderTooltip(pose, (Component)this.getTipArray(new Object[]{this.getText("needmf"), this.getLabel(tip, WHITE)}).m_130940_(GOLD), xAxis, yAxis);
                this.enchaView[id] = true;
            }
            tipY += 20;
        }
        this.craftView = false;
        tipX = this.getWidth() + 23;
        if (this.isRender(tipX, tipY = this.getHeight() + 70, mouseX, mouseY, 32, 14)) {
            this.craftView = true;
            boolean isSelect = this.selectId != -1;
            ArrayList<Component> tipList = new ArrayList<Component>();
            tipList.add((Component)this.getText(isSelect ? "caraft_start" : "select_recipe").m_130940_(GREEN));
            if (isSelect) {
                String tipMF = this.format(SweetMagicAPI.getMF(stackList.get(this.selectId)) * this.tile.setCount);
                tipList.add((Component)this.getTipArray(new Object[]{this.getText("needmf"), this.getLabel(tipMF, WHITE)}).m_130940_(GOLD));
            }
            this.renderComponentTooltip(pose, tipList, xAxis, yAxis);
        }
        tipX = this.getWidth() + 64;
        tipY = this.getHeight() + 92;
        int listSize = Math.min(6, this.tile.outStackList.size());
        for (int i = 0; i < listSize; ++i) {
            this.cancelView[i] = false;
            if (this.isRender2(tipX + 11 + i * 18, tipY, mouseX, mouseY, 7, 7)) {
                this.cancelView[i] = true;
                this.renderTooltip(pose, (Component)this.getText("craft_cancel").m_130940_(RED), xAxis, yAxis);
                continue;
            }
            if (!this.isRender2(tipX + i * 18, tipY, mouseX, mouseY, 18, 18)) continue;
            ItemStack stack = this.tile.outStackList.get(i);
            this.renderTooltip(pose, stack, xAxis, yAxis);
        }
    }

    @Override
    public boolean m_6375_(double guiX, double guiY, int mouseButton) {
        this.scrolling = false;
        int x = this.getWidth();
        int y = this.getHeight();
        double dX = guiX - (double)x - 64.0;
        List<ItemStack> stackList = this.tile.getStackList();
        int maxItemList = Math.min(4, stackList.size());
        for (int id = 0; id < maxItemList; ++id) {
            double dY = guiY - (double)y - 6.0 - (double)(id * 20);
            if (!(dX >= 0.0) || !(dX <= 98.0) || !(dY >= 0.0) || !(dY < 20.0)) continue;
            this.selectId = this.selectId == id + this.startIndex ? -1 : id + this.startIndex;
            this.clickButton(this.selectId == -1 ? 99 : this.selectId + 10);
        }
        dX = guiX - (double)x - 23.0;
        double dY = guiY - (double)y - 71.0;
        if (dX >= 0.0 && dX <= 32.0 && dY >= 0.0 && dY < 12.0) {
            PacketHandler.sendToServer(new BottlerPKT(this.selectId, this.tile.m_58899_()));
        }
        dX = guiX - (double)x - 75.0;
        dY = guiY - (double)y - 92.0;
        int listSize = Math.min(6, this.tile.outStackList.size());
        for (int i = 0; i < listSize; ++i) {
            if (dX >= 0.0 && dX <= 7.0 && dY >= 0.0 && dY < 7.0) {
                this.clickButton(i + 4);
                break;
            }
            dX -= 18.0;
        }
        int w = 8;
        int h = 14;
        int aX = this.f_97735_ + 167;
        int aY = (int)((float)(this.f_97736_ + 9) + this.scrollOffset * 60.0f);
        if (guiX >= (double)aX && guiX < (double)(aX + w) && guiY >= (double)aY && guiY < (double)(aY + h)) {
            this.scrolling = true;
        }
        return super.m_6375_(guiX, guiY, mouseButton);
    }

    public boolean m_7979_(double mouseX, double mouseY, int mouseButton, double dragX, double dragY) {
        List<ItemStack> stackList = this.tile.getStackList();
        int size = stackList.size();
        if (!this.scrolling || !this.scrollbarActive()) {
            return super.m_7979_(mouseX, mouseY, mouseButton, dragX, dragY);
        }
        int i = this.f_97736_ + 16;
        int j = i + 73;
        int offscreenRows = size - 4;
        this.scrollOffset = ((float)mouseY - (float)i + 5.0f) / ((float)(j - i) - 15.0f);
        this.scrollOffset = Mth.m_14036_((float)this.scrollOffset, (float)0.0f, (float)1.0f);
        this.startIndex = (int)((double)(this.scrollOffset * (float)offscreenRows) + 0.5);
        return true;
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollDelta) {
        if (!this.scrollbarActive()) {
            return super.m_6050_(mouseX, mouseY, scrollDelta);
        }
        int size = this.tile.getStackList().size();
        int offscreenRows = size - 4;
        this.scrollOffset = (float)((double)this.scrollOffset - scrollDelta / (double)offscreenRows);
        this.scrollOffset = Mth.m_14036_((float)this.scrollOffset, (float)0.0f, (float)1.0f);
        this.startIndex = (int)((double)(this.scrollOffset * (float)offscreenRows) + 0.5);
        return true;
    }

    private boolean scrollbarActive() {
        return this.tile.getStackList().size() > 4;
    }

    @Override
    protected ResourceLocation getTEX() {
        return TEX;
    }
}

