/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.gui;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import sweetmagic.SweetMagicCore;
import sweetmagic.api.iitem.IMagicBook;
import sweetmagic.init.tile.gui.GuiSMBase;
import sweetmagic.init.tile.gui.util.SMButton;
import sweetmagic.init.tile.menu.MagicBookMenu;

public class GuiMagicBook
extends GuiSMBase<MagicBookMenu> {
    private static final ResourceLocation TEX = SweetMagicCore.getSRC("textures/gui/gui_magic_book.png");
    private ItemStack stack;
    private IMagicBook book;
    private int slot;

    public GuiMagicBook(MagicBookMenu menu, Inventory pInv, Component title) {
        super(menu, pInv, title);
        this.setGuiSize(176, 148);
        this.stack = this.player.m_21205_();
        this.book = IMagicBook.getBook(this.stack);
        this.slot = this.book.getSlotCount(this.stack);
        this.hasRobe = this.hasRobe();
        this.hasPorch = this.hasPorch();
        int x = 150;
        if (this.hasRobe) {
            this.addButtonMap(0, new SMButton(MISC, x, -25, 200, 0, 16, 31, new SMButton.SMButtonTip("open_robe", -18, 14)));
            x -= 18;
        }
        if (this.hasPorch) {
            this.addButtonMap(1, new SMButton(MISC, x, -25, 200, 0, 16, 30, new SMButton.SMButtonTip("open_porch", -18, 14)));
            x -= 18;
        }
        this.addButtonMap(2, new SMButton(MISC, x, -25, 200, 0, 16, 30, new SMButton.SMButtonTip("open_craftbook", -18, 14)));
    }

    @Override
    protected void m_7286_(GuiGraphics pose, float parTick, int mouseX, int mouseY) {
        super.m_7286_(pose, parTick, mouseX, mouseY);
        this.renderBGBase(pose, parTick, mouseX, mouseY);
        int x = this.getWidth();
        int y = this.getHeight();
        int count = 0;
        for (int k = 0; k < 2; ++k) {
            for (int i = 0; i < 5 && ++count <= this.slot; ++i) {
                this.blit(pose, x + 36 + 22 * i, y + 12 + 22 * k, 238, 0, 18, 18);
            }
            if (count > this.slot) break;
        }
        int pX = x + 150;
        int pY = y - 17;
        if (this.hasRobe) {
            ItemStack robe = this.player.m_6844_(EquipmentSlot.CHEST);
            pose.m_280480_(robe, pX, pY);
            pX -= 18;
        }
        if (this.hasPorch) {
            ItemStack porch = this.player.m_6844_(EquipmentSlot.LEGS);
            pose.m_280480_(porch, pX, pY);
            pX -= 18;
        }
        pose.m_280480_(this.stack, pX, pY);
    }

    @Override
    protected ResourceLocation getTEX() {
        return TEX;
    }
}

