/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import sweetmagic.SweetMagicCore;
import sweetmagic.init.BlockInit;
import sweetmagic.init.ItemInit;
import sweetmagic.init.capability.icap.ICookingStatus;
import sweetmagic.init.tile.gui.GuiSMBase;
import sweetmagic.init.tile.gui.util.SMButton;
import sweetmagic.init.tile.menu.NotePCMenu;
import sweetmagic.init.tile.sm.TileNotePC;

public class GuiNotePC
extends GuiSMBase<NotePCMenu> {
    private static final ResourceLocation TEX = SweetMagicCore.getSRC("textures/gui/gui_notepc.png");
    private final TileNotePC tile;
    private List<List<TileNotePC.TradeInfo>> tradeList = new ArrayList<List<TileNotePC.TradeInfo>>();
    private List<Integer> intList = new ArrayList<Integer>();
    private long date;
    private ICookingStatus cook;
    private TileNotePC.TradeInfo trade = null;
    private int tabId = 0;
    private boolean[] tabView = new boolean[6];
    private boolean[] lootView = new boolean[5];
    private float scrollOffset = 0.0f;
    private int startIndex = 0;
    private boolean scrolling = false;
    private boolean click = false;
    private int selectID = -1;

    public GuiNotePC(NotePCMenu menu, Inventory pInv, Component title) {
        super(menu, pInv, title);
        this.setGuiSize(184, 243);
        this.tile = menu.tile;
        this.addButtonMap(0, new SMButton(TEX, 120, 94, 188, 94, 15, 12));
        this.addButtonMap(1, new SMButton(TEX, 135, 94, 189, 106, 22, 12));
        this.addButtonMap(2, new SMButton(TEX, 157, 94, 189, 106, 22, 12));
        this.addButtonMap(3, new SMButton(TEX, 120, 106, 188, 94, 15, 12));
        this.addButtonMap(4, new SMButton(TEX, 135, 106, 189, 106, 22, 12));
        this.addButtonMap(5, new SMButton(TEX, 157, 106, 189, 106, 22, 12));
        this.addButtonMap(6, new SMButton(TEX, 3, 33, 188, 0, 26, 13));
        this.addButtonMap(7, new SMButton(TEX, 153, 72, 188, 72, 26, 18));
        this.tile.setOwner(this.player);
        this.cook = this.tile.getCook(this.player);
        this.clearInfo(this.player);
    }

    @Override
    protected void m_7286_(GuiGraphics gra, float parTick, int mouseX, int mouseY) {
        int i;
        int needSP;
        int i2;
        super.m_7286_(gra, parTick, mouseX, mouseY);
        int x = this.getWidth();
        int y = this.getHeight();
        if (this.tradeList.isEmpty()) {
            return;
        }
        List<TileNotePC.TradeInfo> tradeInfoList = this.tradeList.get(this.tabId);
        int size = Math.min(5, tradeInfoList.size());
        int intSize = this.intList.size();
        int h = (int)(61.0f * this.scrollOffset);
        gra.m_280218_(this.getTEX(), x + 73, y + 77 + h, 188 + (this.scrolling ? 5 : 0), 143, 5, 15);
        for (i2 = 0; i2 < intSize; ++i2) {
            int addX = i2 != this.tabId ? 18 : 0;
            gra.m_280218_(this.getTEX(), x + 1 + i2 * 18, y + 50, 188 + addX, 50, 18, 18);
            if (!this.tabView[i2]) continue;
            gra.m_280218_(this.getTEX(), x + 1 + i2 * 18, y + 50, 224, 50, 18, 17);
        }
        for (i2 = 0; i2 < size; ++i2) {
            gra.m_280218_(this.getTEX(), x + 5, y + 72 + i2 * 17, 188, this.lootView[i2] ? 122 : 225, 67, 17);
        }
        if (this.cook.getTradeLevel() <= 4) {
            ItemStack input = this.tile.getInputItem();
            if (!input.m_41619_()) {
                gra.m_280218_(this.getTEX(), x + 34, y + 39, 1, 249, this.cook.getExpProgress(144, (int)((float)this.tile.getValue(this.cook, input) * 0.05f)), 7);
            } else if (this.trade != null) {
                needSP = this.trade.price() * this.tile.buyCount;
                gra.m_280218_(this.getTEX(), x + 34, y + 39, 1, 249, this.cook.getExpProgress(144, (int)((float)needSP * 0.25f)), 7);
            }
        }
        gra.m_280218_(this.getTEX(), x + 34, y + 39, 1, 243, this.cook.getExpProgress(144), 7);
        for (i = 0; i < intSize; ++i) {
            gra.m_280480_(this.getTradeIcon(this.intList.get(i)), x + 1 + i * 18, y + 51);
        }
        if (this.trade != null) {
            int buyCount = this.tile.buyCount;
            needSP = this.trade.price() * buyCount;
            int hasSP = this.cook.getTradeSP();
            boolean isSa = hasSP >= needSP;
            PoseStack pose = gra.m_280168_();
            MutableComponent spTip = this.getLabel(this.format(needSP) + "sp", isSa ? GREEN : RED);
            this.drawFont(gra, (Component)spTip, 50.0f, x + 102, y + 81, 0xEEEEEE, true);
            gra.m_280480_(this.trade.stack(), x + 84, y + 73);
            if (buyCount > 0) {
                pose.m_85836_();
                pose.m_85837_(0.0, 0.0, 200.0);
                MutableComponent tip = this.getLabel("\u00d7" + this.trade.stack().m_41613_() * buyCount);
                this.drawFont(gra, (Component)tip, 50.0f, x + 101, y + 73, 0xEEEEEE, true);
                pose.m_85849_();
            }
        }
        for (i = 0; i < size; ++i) {
            TileNotePC.TradeInfo info = tradeInfoList.get(i + this.startIndex);
            MutableComponent tip = this.getLabel(this.format(info.price()) + "sp", GREEN);
            this.drawFont(gra, (Component)tip, 45.0f, x + 25, y + 79 + i * 17, 0xEEEEEE, true);
            gra.m_280480_(info.stack(), x + 6, y + 73 + i * 17);
            gra.m_280370_(this.f_96547_, info.stack(), x + 6, y + 73 + i * 17);
        }
        ItemStack stack = this.tile.getInputItem();
        if (!stack.m_41619_()) {
            String price = this.format(this.tile.getValue(this.cook, stack)) + "sp";
            this.drawShadow(gra, (Component)this.getText("trade_sell", new Object[]{price}).m_130940_(GREEN), x + 36, y + 15, 0xEEEEEE);
        }
        this.drawShadow(gra, (Component)this.getText("trade_rate", new Object[]{this.formatPar(this.cook.getRate() * 100.0f)}).m_130940_(GREEN), x + 36, y + 26, 0xEEEEEE);
        this.drawShadow(gra, (Component)this.getText("possess_sp", new Object[]{""}).m_130940_(GOLD), (float)(x + 110), (float)y + 51.0f, 0xEEEEEE);
        this.draw(gra, (Component)this.getLabel(this.format(this.cook.getTradeSP()) + "sp"), x + 114, (float)y + 59.5f, 0x333333);
        long nextTime = this.tile.getNextTime() / 20L;
        long nextMin = nextTime / 60L;
        this.drawShadow(gra, (Component)this.getText("trade_update").m_130940_(WHITE), x + 131, y + 15, 0xEEEEEE);
        this.drawShadow(gra, (Component)this.getText("trade_time", new Object[]{nextMin, nextTime %= 60L}).m_130940_(GOLD), (float)(x + 131), (float)y + 26.0f, 0xEEEEEE);
        if (this.date != -1L && this.date != this.tile.randDate) {
            this.clearInfo(this.player);
        }
        this.drawShadow(gra, (Component)this.getText("trade_sale").m_130940_(WHITE), x + 6, y + 35, 0xEEEEEE);
        this.drawShadow(gra, (Component)this.getText("trade_buy").m_130940_(WHITE), x + 155, y + 77, 0xEEEEEE);
        this.drawShadow(gra, (Component)this.getLabel("+1", WHITE), x + 122, y + 97, 0xEEEEEE);
        this.drawShadow(gra, (Component)this.getLabel("+10", WHITE), x + 136, y + 97, 0xEEEEEE);
        this.drawShadow(gra, (Component)this.getLabel("+64", WHITE), x + 158, y + 97, 0xEEEEEE);
        this.drawShadow(gra, (Component)this.getLabel("-1", WHITE), x + 122, y + 109, 0xEEEEEE);
        this.drawShadow(gra, (Component)this.getLabel("-10", WHITE), x + 136, y + 109, 0xEEEEEE);
        this.drawShadow(gra, (Component)this.getLabel("-64", WHITE), x + 158, y + 109, 0xEEEEEE);
    }

    @Override
    protected void m_280003_(GuiGraphics pose, int mouseX, int mouseY) {
        super.m_280003_(pose, mouseX, mouseY);
        int xAxis = mouseX - this.getWidth();
        int yAxis = mouseY - this.getHeight();
        int tipX = this.getWidth() + 5;
        int tipY = this.getHeight() + 72;
        if (this.tradeList.isEmpty()) {
            return;
        }
        List<TileNotePC.TradeInfo> tradeInfoList = this.tradeList.get(this.tabId);
        int size = Math.min(5, tradeInfoList.size());
        for (int id = 0; id < size; ++id) {
            this.lootView[id] = false;
            if (this.isRender(tipX, tipY, mouseX, mouseY, 67, 16)) {
                this.renderTooltip(pose, tradeInfoList.get(id + this.startIndex).stack(), xAxis, yAxis);
                this.lootView[id] = true;
            }
            tipY += 17;
        }
        tipX = this.getWidth() + 83;
        tipY = this.getHeight() + 72;
        if (this.trade != null && this.isRender(tipX, tipY, mouseX, mouseY, 71, 18)) {
            ItemStack stack = this.trade.stack().m_41777_();
            stack.m_41764_(this.tile.buyCount);
            this.renderTooltip(pose, stack, xAxis, yAxis);
        }
        tipX = this.getWidth();
        tipY = this.getHeight() + 50;
        for (int i = 0; i < this.intList.size(); ++i) {
            this.tabView[i] = false;
            if (this.isRender(tipX, tipY, mouseX, mouseY, 17, 18)) {
                this.tabView[i] = true;
                this.renderTooltip(pose, (Component)this.getText(this.getTradeTile(this.intList.get(i))), xAxis, yAxis);
            }
            tipX += 18;
        }
        tipX = this.getWidth() + 33;
        if (this.isRender(tipX, tipY = this.getHeight() + 39, mouseX, mouseY, 144, 7)) {
            int level = this.cook.getTradeLevel();
            String needExp = this.format(this.cook.needExp());
            ArrayList<Component> tipList = new ArrayList<Component>();
            tipList.add((Component)this.getText("trade_level", new Object[]{level}).m_130940_(GREEN));
            tipList.add((Component)this.getText("trade_exp", new Object[]{needExp}).m_130940_(GREEN));
            tipList.add((Component)this.getLabel("===================="));
            tipList.add((Component)this.getText("trade_tip0").m_130940_(GOLD));
            tipList.add((Component)this.getText("trade_tip1").m_130940_(GOLD));
            tipList.add((Component)this.getText("trade_tip2").m_130940_(GOLD));
            this.renderComponentTooltip(pose, tipList, xAxis, yAxis);
        }
        tipX = this.getWidth() + 73;
        tipY = (int)((float)(this.getHeight() + 77) + this.scrollOffset * 60.0f);
        this.scrolling = false;
        if (this.isRender(tipX, tipY, mouseX, mouseY, 5, 15)) {
            this.scrolling = true;
        }
    }

    @Override
    public void clickSMButton(int id) {
        if (id == 7) {
            id += this.selectID + this.tabId * (10 + this.cook.getTradeLevel() * 2);
        }
        this.clickButton(id);
    }

    @Override
    public boolean m_6375_(double guiX, double guiY, int mouseButton) {
        int aX = this.f_97735_ + 73;
        int aY = (int)((float)(this.f_97736_ + 77) + this.scrollOffset * 60.0f);
        int w = 5;
        int h = 15;
        this.click = false;
        if (guiX >= (double)aX && guiX < (double)(aX + w) && guiY >= (double)aY && guiY < (double)(aY + h)) {
            this.click = true;
        }
        aX = this.f_97735_;
        aY = this.f_97736_ + 50;
        w = 18;
        h = 18;
        for (int i = 0; i < this.intList.size(); ++i) {
            if (guiX >= (double)aX && guiX < (double)(aX + w) && guiY >= (double)aY && guiY < (double)(aY + h)) {
                this.tabId = i;
                this.scrollOffset = 0.0f;
                this.startIndex = 0;
                this.clickButton(-1);
                break;
            }
            aX += 19;
        }
        aX = this.f_97735_ + 5;
        aY = this.f_97736_ + 72;
        w = 67;
        h = 16;
        List<TileNotePC.TradeInfo> tradeInfoList = this.tradeList.get(this.tabId);
        int size = Math.min(5, tradeInfoList.size());
        for (int id = 0; id < size; ++id) {
            if (guiX >= (double)aX && guiX < (double)(aX + w) && guiY >= (double)aY && guiY < (double)(aY + h)) {
                if (this.selectID == id + this.startIndex) {
                    this.selectID = -1;
                    this.trade = null;
                } else {
                    this.selectID = id + this.startIndex;
                    this.trade = this.tradeList.get(this.tabId).get(this.selectID);
                }
                this.clickButton(-1);
                break;
            }
            aY += 17;
        }
        return super.m_6375_(guiX, guiY, mouseButton);
    }

    public boolean m_7979_(double mouseX, double mouseY, int mouseButton, double dragX, double dragY) {
        if (!this.scrolling && !this.click) {
            return super.m_7979_(mouseX, mouseY, mouseButton, dragX, dragY);
        }
        int i = this.f_97736_ + 73;
        int j = i + 77;
        int offscreenRows = this.tradeList.get(this.tabId).size() - 5;
        this.scrollOffset = ((float)mouseY - (float)i - 15.0f) / ((float)(j - i) - 15.0f);
        this.scrollOffset = Mth.m_14036_((float)this.scrollOffset, (float)0.0f, (float)1.0f);
        this.startIndex = (int)((double)(this.scrollOffset * (float)offscreenRows) + 0.5);
        return super.m_7979_(mouseX, mouseY, mouseButton, dragX, dragY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollDelta) {
        int offscreenRows = this.tradeList.get(this.tabId).size() - 5;
        this.scrollOffset = (float)((double)this.scrollOffset - scrollDelta / (double)offscreenRows);
        this.scrollOffset = Mth.m_14036_((float)this.scrollOffset, (float)0.0f, (float)1.0f);
        this.startIndex = (int)((double)(this.scrollOffset * (float)offscreenRows) + 0.5);
        return super.m_6050_(mouseX, mouseY, scrollDelta);
    }

    public void clearInfo(Player player) {
        this.tradeList = this.tile.getTrade(player);
        this.date = this.tile.randDate;
        int tradeLevel = this.cook.getTradeLevel() + 1;
        this.intList.clear();
        this.tabId = 0;
        this.selectID = -1;
        this.scrollOffset = 0.0f;
        this.startIndex = 0;
        this.scrolling = false;
        for (int i = 0; i < tradeLevel; ++i) {
            this.intList.add(this.tile.intList.get(i));
        }
    }

    public ItemStack getTradeIcon(int i) {
        return switch (i) {
            case 1 -> new ItemStack((ItemLike)ItemInit.aether_crystal);
            case 2 -> new ItemStack((ItemLike)BlockInit.wood_chest);
            case 3 -> new ItemStack((ItemLike)Items.f_42690_);
            case 4 -> new ItemStack((ItemLike)Items.f_151049_);
            case 5 -> new ItemStack((ItemLike)ItemInit.flour);
            default -> new ItemStack((ItemLike)ItemInit.sugarbell);
        };
    }

    public String getTradeTile(int i) {
        return switch (i) {
            case 1 -> "trade_magic";
            case 2 -> "trade_furniture";
            case 3 -> "trade_enchant";
            case 4 -> "trade_vanilla";
            case 5 -> "trade_seasoning";
            default -> "trade_seed";
        };
    }

    @Override
    protected ResourceLocation getTEX() {
        return TEX;
    }
}

