/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.registries.ForgeRegistries;
import org.joml.Matrix4f;
import sweetmagic.SweetMagicCore;
import sweetmagic.api.iitem.IPorch;
import sweetmagic.api.iitem.IRobe;
import sweetmagic.api.iitem.IWand;
import sweetmagic.api.util.ISMTip;
import sweetmagic.init.tile.gui.util.SMButton;
import sweetmagic.init.tile.gui.util.SMRenderTex;
import sweetmagic.init.tile.menu.BaseSMMenu;
import sweetmagic.init.tile.slot.MagiaSlot;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileMFChanger;
import sweetmagic.init.tile.sm.TileSMMagic;

public abstract class GuiSMBase<M extends AbstractContainerMenu>
extends AbstractContainerScreen<M>
implements ISMTip {
    protected int guiTime = 0;
    protected final Player player;
    protected final M menu;
    protected boolean hasRobe = false;
    protected boolean hasPorch = false;
    protected boolean hasWand = false;
    protected boolean hasBook = false;
    private final Map<Integer, SMButton> buttonMap = new HashMap<Integer, SMButton>();
    private final List<SMRenderTex> renderList = new ArrayList<SMRenderTex>();
    protected Map<Slot, Integer> stackCountMap = new HashMap<Slot, Integer>();
    protected static final String[] ENCODED_SUFFIXES = new String[]{"K", "M", "G"};
    protected static final ResourceLocation MISC = SweetMagicCore.getSRC("textures/gui/gui_misc.png");

    public GuiSMBase(M menu, Inventory pInv, Component title) {
        super(menu, pInv, title);
        this.menu = menu;
        this.player = pInv.f_35978_;
    }

    public void m_88315_(GuiGraphics pose, int mouseX, int mouseY, float parTick) {
        this.m_280273_(pose);
        super.m_88315_(pose, mouseX, mouseY, parTick);
        this.m_280072_(pose, mouseX, mouseY);
    }

    protected void renderBGBase(GuiGraphics pose, float parTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::m_172814_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.blit(pose, this.f_97735_, this.f_97736_, 0, 0, this.getGuiWidth(), this.getGuiHeight());
    }

    protected void m_7286_(GuiGraphics pose, float parTick, int mouseX, int mouseY) {
        this.renderBGBase(pose, parTick, mouseX, mouseY);
        if (!this.getButtonMap().isEmpty()) {
            this.buttonMapRender(pose);
        }
        if (!this.getRenderTexList().isEmpty()) {
            this.renderTexRender(pose);
        }
        ++this.guiTime;
    }

    public void buttonMapRender(GuiGraphics pose) {
        Map<Integer, SMButton> buttonMap = this.getButtonMap();
        for (Map.Entry<Integer, SMButton> map : buttonMap.entrySet()) {
            SMButton button = map.getValue();
            if (!button.isButtonRender()) continue;
            int x = button.getX();
            int y = button.getY();
            int texX = button.getTexX();
            int texY = button.getTexY();
            int sizeX = button.getSizeX();
            int sizeY = button.getSizeY();
            pose.m_280218_(button.getTex(), this.f_97735_ + x, this.f_97736_ + y, texX + (button.isView() ? sizeX : 0), texY, sizeX, sizeY);
        }
    }

    public void renderTexRender(GuiGraphics pose) {
        for (SMRenderTex render : this.getRenderTexList()) {
            int x = render.getX();
            int y = render.getY();
            int texX = render.getTexX();
            int texY = render.getTexY();
            int sizeX = render.getSizeX();
            int sizeY = render.getSizeY();
            ResourceLocation tex = render.getTex();
            if (render.getMFRender() != null) {
                SMRenderTex.MFRenderGage mfRender = render.getMFRender();
                TileSMMagic tile = mfRender.tile();
                if (mfRender.isVertical()) {
                    pose.m_280218_(tex, this.f_97735_ + x, this.f_97736_ + y, 0, 93, 11, 77);
                } else if (!(tile instanceof TileMFChanger)) {
                    pose.m_280218_(tex, this.f_97735_ + x, this.f_97736_ + y, 22, 148, 77, 11);
                }
                if (tile.isMFEmpty()) continue;
                int progress = tile.getMFProgressScaled(76);
                if (mfRender.isVertical()) {
                    pose.m_280218_(tex, this.f_97735_ + x, this.f_97736_ + y + 76 - progress, 11, 169 - progress, 11, progress);
                    continue;
                }
                if (!(tile instanceof TileMFChanger)) {
                    pose.m_280218_(tex, this.f_97735_ + x, this.f_97736_ + y, 22, 159, progress, 11);
                    continue;
                }
                pose.m_280218_(tex, this.f_97735_ + x, this.f_97736_ + y, 0, 166, tile.getMFProgressScaled(106), 10);
                continue;
            }
            pose.m_280218_(tex, this.f_97735_ + x, this.f_97736_ + y, texX, texY, sizeX, sizeY);
        }
    }

    protected void m_280003_(GuiGraphics pose, int mouseX, int mouseY) {
        int x = this.getWidth();
        int y = this.getHeight();
        if (!this.getButtonMap().isEmpty()) {
            this.buttonMapLabel(pose, mouseX, mouseY, x, y);
        }
        if (!this.getRenderTexList().isEmpty()) {
            this.renderTexLabel(pose, mouseX, mouseY, x, y);
        }
    }

    public void buttonMapLabel(GuiGraphics pose, int mouseX, int mouseY, int texSizeX, int texSizeY) {
        Map<Integer, SMButton> buttonMap = this.getButtonMap();
        for (Map.Entry<Integer, SMButton> map : buttonMap.entrySet()) {
            SMButton button = map.getValue();
            int x = button.getX();
            int y = button.getY();
            int sizeX = button.getSizeX();
            int sizeY = button.getSizeY();
            int tipX = texSizeX + x;
            int tipY = texSizeY + y;
            button.setIsView(false);
            if (!this.isRender(tipX, tipY, mouseX, mouseY, sizeX, sizeY)) continue;
            button.setIsView(true);
            SMButton.SMButtonTip buttonTip = button.getButtonTip();
            if (buttonTip == null) continue;
            MutableComponent tip = this.getText(buttonTip.getTip());
            int lenght = this.f_96547_.m_92895_(tip.getString());
            String addTip = buttonTip.getAddTip();
            int xAxis = mouseX - texSizeX - lenght + buttonTip.getTipX();
            int yAxis = mouseY - texSizeY + buttonTip.getTipY();
            if (addTip == null || addTip.isEmpty()) {
                this.renderTooltip(pose, (Component)tip, xAxis, yAxis);
                continue;
            }
            TileAbstractSM tile = ((BaseSMMenu)((Object)this.menu)).getTile();
            String slot = tile.changeOutput ? "slot_input" : "slot_output";
            List<Component> tipList = Arrays.asList(this.getText(buttonTip.getTip(), new Object[]{this.getText(slot)}), this.getText(addTip).m_130940_(GOLD));
            this.renderComponentTooltip(pose, tipList, xAxis, yAxis);
        }
    }

    public void renderTexLabel(GuiGraphics pose, int mouseX, int mouseY, int texSizeX, int texSizeY) {
        for (SMRenderTex render : this.getRenderTexList()) {
            int sizeY;
            int sizeX;
            int y;
            int tipY;
            int x = render.getX();
            int tipX = texSizeX + x;
            if (!this.isRender(tipX, tipY = texSizeY + (y = render.getY()), mouseX, mouseY, sizeX = render.getSizeX(), sizeY = render.getSizeY())) continue;
            SMButton.SMButtonTip buttonTip = render.getButtonTip();
            if (buttonTip != null) {
                MutableComponent tip = this.getText(buttonTip.getTip());
                int lenght = this.f_96547_.m_92895_(tip.getString());
                int xAxis = mouseX - texSizeX - lenght + buttonTip.getTipX();
                int yAxis = mouseY - texSizeY + buttonTip.getTipY();
                this.renderTooltip(pose, (Component)tip, xAxis, yAxis);
                continue;
            }
            if (render.getMFRender() == null) continue;
            SMRenderTex.MFRenderGage mfRender = render.getMFRender();
            TileSMMagic tile = mfRender.tile();
            int mf = tile.getMF();
            int max = tile.getMaxMF();
            String par = " (" + tile.getMFPercent() + ")";
            int xAxis = mouseX - this.getWidth();
            int yAxis = mouseY - this.getHeight();
            String tip = this.format(mf) + "mf / " + this.format(max) + "mf" + par;
            this.renderTooltip(pose, (Component)this.getLabel(tip), xAxis, yAxis);
        }
    }

    public boolean m_6375_(double guiX, double guiY, int mouseButton) {
        Map<Integer, SMButton> buttonMap = this.getButtonMap();
        for (Map.Entry<Integer, SMButton> map : buttonMap.entrySet()) {
            SMButton button = map.getValue();
            int aX = this.f_97735_ + button.getX();
            int aY = this.f_97736_ + button.getY();
            int width = button.getSizeX();
            int height = button.getSizeY();
            if (!(guiX >= (double)aX) || !(guiX < (double)(aX + width)) || !(guiY >= (double)aY) || !(guiY < (double)(aY + height))) continue;
            this.clickSMButton(map.getKey());
        }
        return super.m_6375_(guiX, guiY, mouseButton);
    }

    public void clickSMButton(int id) {
        this.clickButton(id);
    }

    protected abstract ResourceLocation getTEX();

    protected int getWidth() {
        return (this.f_96543_ - this.getGuiWidth()) / 2;
    }

    protected int getHeight() {
        return (this.f_96544_ - this.getGuiHeight()) / 2;
    }

    public void setGuiSize(int imageWidth, int imageHeight) {
        this.f_97726_ = imageWidth;
        this.f_97727_ = imageHeight;
    }

    public int getGuiWidth() {
        return this.f_97726_;
    }

    public int getGuiHeight() {
        return this.f_97727_;
    }

    protected void clickButton(int id) {
        this.menu.m_6366_(this.player, id);
        this.f_96541_.f_91072_.m_105208_(((AbstractContainerMenu)this.menu).f_38840_, id);
    }

    private Map<Integer, SMButton> getButtonMap() {
        return this.buttonMap;
    }

    private List<SMRenderTex> getRenderTexList() {
        return this.renderList;
    }

    protected void addButtonMap(Integer key, SMButton val) {
        this.buttonMap.put(key, val);
    }

    protected void addRenderTexList(SMRenderTex val) {
        this.renderList.add(val);
    }

    protected void drawFont(GuiGraphics gra, Component tip, float maxSize, float x, float y, int color, boolean isShadow) {
        float addX2;
        PoseStack pose = gra.m_280168_();
        pose.m_85836_();
        int spSize2 = this.f_96547_.m_92895_(tip.getString());
        pose.m_85841_((float)spSize2 < maxSize ? 1.0f : maxSize / (float)spSize2, 1.0f, 1.0f);
        float f = addX2 = (float)spSize2 < maxSize ? 1.0f : (float)spSize2 / maxSize;
        if (isShadow) {
            this.drawShadow(gra, tip, x * addX2, y, color);
        } else {
            this.draw(gra, tip, x * addX2, y, color);
        }
        pose.m_85849_();
    }

    public ItemStack getViewStack(List<ItemStack> stackList) {
        return stackList.get(this.guiTime / 80 % stackList.size()).m_41777_();
    }

    public void renderSlotItem(Slot slot, ItemStack stack, int count, GuiGraphics pose) {
        ItemStack copy = stack.m_41777_();
        copy.m_41764_(count);
        this.renderSlotItem(slot, copy, pose, 0);
    }

    public void renderSlotItem(Slot slot, ItemStack stack, GuiGraphics pose) {
        this.renderSlotItem(slot, stack.m_41777_(), pose, 0x30FF0000);
    }

    public void renderSlotItem(Slot slot, ItemStack stack, GuiGraphics pose, int color) {
        if (!slot.m_7993_().m_41619_()) {
            return;
        }
        int x = this.f_97735_ + slot.f_40220_;
        int y = this.f_97736_ + slot.f_40221_;
        PoseStack view = RenderSystem.getModelViewStack();
        view.m_85836_();
        view.m_252931_(pose.m_280168_().m_85850_().m_252922_());
        Font font = IClientItemExtensions.of((ItemStack)stack).getFont(stack, IClientItemExtensions.FontContext.TOOLTIP);
        Font font2 = font = font == null ? this.f_96547_ : font;
        if (color > 0) {
            pose.m_280509_(x, y, x + 16, y + 16, color);
        }
        pose.m_280480_(stack, x, y);
        pose.m_285944_(RenderType.m_285811_(), x, y, x + 16, y + 16, 0x30FFFFFF);
        pose.m_280302_(font, stack, x, y, null);
        view.m_85849_();
    }

    public void renderMagiaStack(GuiGraphics pose, int mouseX, int mouseY, float parTick, NonNullList<Slot> slotList, NonNullList<Slot> slots) {
        Slot slot;
        int i;
        this.stackCountMap.clear();
        for (i = 0; i < slotList.size(); ++i) {
            ItemStack stack;
            slot = (Slot)slots.get(i);
            if (!slot.m_6659_() || (stack = ((Slot)slots.get(i)).m_7993_().m_41777_()).m_41619_()) continue;
            this.stackCountMap.put(slot, stack.m_41613_());
            if (stack.m_41619_() || this.checkStackCount(stack.m_41613_())) continue;
            stack.m_41764_(1);
            slot.m_5852_(stack);
        }
        this.m_280273_(pose);
        super.m_88315_(pose, mouseX, mouseY, parTick);
        this.m_280072_(pose, mouseX, mouseY);
        for (i = 0; i < slotList.size(); ++i) {
            ItemStack stack;
            int count;
            slot = (Slot)slots.get(i);
            if (!slot.m_6659_() || this.stackCountMap.get(slot) == null || this.checkStackCount(count = this.stackCountMap.get(slot).intValue()) || (stack = slot.m_7993_()).m_41619_()) continue;
            if (count > 1) {
                this.renderSlotCount(slot, stack, count, pose);
            }
            stack.m_41764_(count);
            slot.m_5852_(stack);
        }
    }

    public boolean checkStackCount(int count) {
        return count <= 1;
    }

    public List<Component> getTooltipFromItem(ItemStack p_96556_) {
        return p_96556_.m_41651_((Player)this.f_96541_.f_91074_, (TooltipFlag)(this.f_96541_.f_91066_.f_92125_ ? TooltipFlag.Default.f_256730_ : TooltipFlag.Default.f_256752_));
    }

    protected void m_280072_(GuiGraphics gra, int x, int y) {
        if (this.menu.m_142621_().m_41619_() && this.f_97734_ != null && this.f_97734_.m_6657_()) {
            this.renderTooltip(gra, this.f_97734_.m_7993_(), x, y);
        }
    }

    protected void renderMagiaStackTooltip(GuiGraphics pose, ItemStack stack, int x, int y, NonNullList<Slot> slotList) {
        List<Component> tipList = this.getTooltipFromItem(stack);
        Slot slot = this.f_97734_;
        if (slot instanceof MagiaSlot) {
            MagiaSlot slot2 = (MagiaSlot)slot;
            int vCount = this.stackCountMap.get((Object)slot2);
            if (vCount <= 0) {
                return;
            }
            int vMax = this.f_97734_.m_6641_();
            String count = this.format(vCount) + "/";
            String max = this.format(vMax);
            String par = " (" + this.format((float)vCount / (float)vMax * 100.0f) + "%)";
            tipList.add((Component)this.getLabel(count + max + par, GOLD));
        }
        this.renderTooltip(pose, tipList, stack.m_150921_(), x, y);
    }

    public void renderSlotCount(Slot slot, ItemStack stack, int count, GuiGraphics pose) {
        int x = this.f_97735_ + slot.f_40220_;
        int y = this.f_97736_ + slot.f_40221_ + 0;
        PoseStack view = RenderSystem.getModelViewStack();
        view.m_85836_();
        view.m_252931_(pose.m_280168_().m_85850_().m_252922_());
        Font font = IClientItemExtensions.of((ItemStack)stack).getFont(stack, IClientItemExtensions.FontContext.TOOLTIP);
        font = font == null ? this.f_96547_ : font;
        pose.m_280480_(stack, x, y);
        Object stackSize = String.valueOf(count);
        if (((String)stackSize).length() > 3) {
            int stackLength = (((String)stackSize).length() - 1) / 3;
            String encord = ENCODED_SUFFIXES[stackLength - 1];
            stackSize = ((String)stackSize).substring(0, ((String)stackSize).length() - stackLength * 3 + 1) + encord;
            stackSize = ((String)stackSize).substring(0, ((String)stackSize).length() - 2) + "." + ((String)stackSize).substring(((String)stackSize).length() - 2, ((String)stackSize).length());
        }
        MultiBufferSource.BufferSource buf = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        PoseStack poses = new PoseStack();
        poses.m_85841_(0.5f, 0.5f, 0.5f);
        poses.m_85837_(0.0, 0.0, 600.0);
        this.f_96547_.m_271703_((String)stackSize, (float)((x + 6 + 9) * 2 - font.m_92895_((String)stackSize)), (float)((y + 12) * 2), 0xFFFFFF, true, poses.m_85850_().m_252922_(), (MultiBufferSource)buf, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        buf.m_109911_();
        view.m_85849_();
    }

    public boolean isRender(int tipX, int tipY, int mouseX, int mouseY, int maxX, int maxY) {
        return tipX <= mouseX && mouseX <= tipX + maxX && tipY <= mouseY && mouseY <= tipY + maxY;
    }

    public boolean isRender2(int tipX, int tipY, int mouseX, int mouseY, int maxX, int maxY) {
        return tipX <= mouseX && mouseX < tipX + maxX && tipY <= mouseY && mouseY < tipY + maxY;
    }

    public void renderItemLabel(Slot slot, ItemStack stack, GuiGraphics pose, int mouseX, int mouseY, List<Component> tipList) {
        int y;
        if (!slot.m_7993_().m_41619_()) {
            return;
        }
        int x = this.getWidth();
        if (!this.isRender(x + slot.f_40220_, (y = this.getHeight()) + slot.f_40221_, mouseX, mouseY, 16, 16)) {
            return;
        }
        this.renderComponentTooltip(pose, tipList, mouseX - x, mouseY - y);
    }

    public void renderItemLabel(Slot slot, ItemStack stack, GuiGraphics pose, int mouseX, int mouseY) {
        ArrayList<Component> tipList = new ArrayList<Component>();
        this.setTip(tipList, stack);
        this.renderItemLabel(slot, stack, pose, mouseX, mouseY, tipList);
    }

    public List<Component> createTipList(ItemStack stack, String ... tipArray) {
        ArrayList<Component> tipList = new ArrayList<Component>();
        for (String tip : tipArray) {
            tipList.add((Component)this.getText(tip));
        }
        if (!stack.m_41619_()) {
            tipList.add(stack.m_41611_());
        }
        return tipList;
    }

    public void renderStock(List<ItemStack> tileStackList, GuiGraphics pose, int stockId, int restockId, int addX, int addY) {
        ArrayList<Item> itemList;
        SMButton quick = this.getButtonMap().get(stockId);
        SMButton restock = this.getButtonMap().get(restockId);
        if (!quick.isView() && !restock.isView()) {
            return;
        }
        NonNullList pInveList = this.player.m_150109_().f_35974_;
        if (quick.isView()) {
            itemList = new ArrayList<Item>();
            for (ItemStack stack : tileStackList) {
                if (stack.m_41619_()) continue;
                itemList.add(stack.m_41720_());
            }
            this.renderInvStock(itemList, (List<ItemStack>)pInveList, pose, addX, addY);
        }
        if (!restock.isView()) {
            return;
        }
        itemList = new ArrayList();
        for (ItemStack stack : pInveList) {
            if (stack.m_41619_()) continue;
            itemList.add(stack.m_41720_());
        }
        this.renderChestStock(itemList, tileStackList, pose);
    }

    public void renderInvStock(List<Item> itemList, List<ItemStack> pInveList, GuiGraphics pose, int addX, int addY) {
        int tX = this.getInvRenderArray().get(0);
        int tY = this.getInvRenderArray().get(1);
        for (int x = 0; x < 9; ++x) {
            ItemStack stack = pInveList.get(x);
            if (stack.m_41619_() || !itemList.contains(stack.m_41720_())) continue;
            pose.m_280218_(MISC, this.f_97735_ + tX + x * 18 + addX, this.f_97736_ + tY + 58 + addY, 114, 47, 18, 18);
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                ItemStack stack = pInveList.get(9 + x + y * 9);
                if (stack.m_41619_() || !itemList.contains(stack.m_41720_())) continue;
                pose.m_280218_(MISC, this.f_97735_ + tX + x * 18 + addX, this.f_97736_ + tY + y * 18, 114, 47, 18, 18);
            }
        }
    }

    public void renderChestStock(List<Item> itemList, List<ItemStack> tileStackList, GuiGraphics pose) {
        int tX = this.getInvRenderArray().get(2);
        int tY = this.getInvRenderArray().get(3);
        int maxSize = tileStackList.size();
        for (int y = 0; y < this.getInvY(); ++y) {
            for (int x = 0; x < this.getInvX(); ++x) {
                int count = x + y * this.getInvX();
                if (maxSize <= count || !itemList.contains(tileStackList.get(count).m_41720_())) continue;
                pose.m_280218_(MISC, this.f_97735_ + tX + x * 18, this.f_97736_ + tY + y * 18, 114, 47, 18, 18);
            }
        }
    }

    public List<Integer> getInvRenderArray() {
        return List.of(Integer.valueOf(47), Integer.valueOf(150), Integer.valueOf(11), Integer.valueOf(4));
    }

    public int getInvY() {
        return 8;
    }

    public int getInvX() {
        return 13;
    }

    public void setTip(List<Component> tipList, ItemStack stack) {
        if (stack.m_41619_()) {
            tipList.add((Component)this.getText("enchated").m_130940_(GREEN));
        } else {
            tipList.addAll(Arrays.asList(this.getText("slot_need").m_130940_(GREEN), stack.m_41611_()));
        }
    }

    public static List<ItemStack> getTagStack(TagKey<Item> tags) {
        return ForgeRegistries.ITEMS.tags().getTag(tags).stream().map(Item::m_7968_).collect(Collectors.toList());
    }

    public boolean hasWand() {
        ItemStack stack = IWand.getWand(this.player);
        return !stack.m_41619_() && stack.m_41720_() instanceof IWand;
    }

    public boolean hasPorch() {
        return this.player.m_6844_(EquipmentSlot.LEGS).m_41720_() instanceof IPorch;
    }

    public boolean hasRobe() {
        return this.player.m_6844_(EquipmentSlot.CHEST).m_41720_() instanceof IRobe;
    }

    public void drawFluid(Matrix4f mat, float x, float y, int width, int height, TextureAtlasSprite sprite, int top) {
        float uMin = sprite.m_118409_();
        float uMax = sprite.m_118410_();
        float vMin = sprite.m_118411_();
        float vMax = sprite.m_118412_();
        vMax -= (float)top / 16.0f * (vMax - vMin);
        RenderSystem.setShader(GameRenderer::m_172817_);
        Tesselator tes = Tesselator.m_85913_();
        BufferBuilder buf = tes.m_85915_();
        buf.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buf.m_252986_(mat, x, y + (float)height, 100.0f).m_7421_(uMin, vMax).m_5752_();
        buf.m_252986_(mat, x + (float)width, y + (float)height, 100.0f).m_7421_(uMax, vMax).m_5752_();
        buf.m_252986_(mat, x + (float)width, y, 100.0f).m_7421_(uMax, vMin).m_5752_();
        buf.m_252986_(mat, x, y, 100.0f).m_7421_(uMin, vMin).m_5752_();
        tes.m_85914_();
    }

    public void renderTooltip(GuiGraphics pose, List<Component> tipList, Optional<TooltipComponent> com, int x, int y) {
        pose.m_280677_(this.f_96547_, tipList, com, x, y);
    }

    public void renderComponentTooltip(GuiGraphics pose, List<Component> tip, int x, int y) {
        pose.m_280666_(this.f_96547_, tip, x, y);
    }

    public void renderTooltip(GuiGraphics pose, Component tip, int x, int y) {
        pose.m_280557_(this.f_96547_, tip, x, y);
    }

    public void renderTooltip(GuiGraphics pose, ItemStack stack, int x, int y) {
        pose.m_280153_(this.f_96547_, stack, x, y);
    }

    public void drawShadow(GuiGraphics pose, Component tip, int x, int y, int color) {
        pose.m_280430_(this.f_96547_, tip, x, y, color);
    }

    public void drawShadow(GuiGraphics pose, Component tip, float x, float y, int color) {
        pose.drawString(this.f_96547_, tip.m_7532_(), x, y, color, true);
    }

    public void draw(GuiGraphics pose, Component tip, float x, float y, int color) {
        pose.drawString(this.f_96547_, tip.m_7532_(), x, y, color, false);
    }

    public void fill(GuiGraphics pose, int x, int y, int maxX, int maxY, int color) {
        pose.m_280509_(x, y, maxX, maxY, color);
    }

    public void blit(GuiGraphics pose, int x, int y, int sX, int sY, int eX, int eY) {
        pose.m_280218_(this.getTEX(), x, y, sX, sY, eX, eY);
    }
}

