/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.menu;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkHooks;
import org.antlr.v4.runtime.misc.NotNull;
import sweetmagic.init.MenuInit;
import sweetmagic.init.tile.menu.BaseSMMenu;
import sweetmagic.init.tile.menu.container.BaseContainer;
import sweetmagic.init.tile.slot.SMSlot;
import sweetmagic.init.tile.sm.TileAlstroemeriaAquarium;

public class AlstroemeriaAquariumMenu
extends BaseSMMenu {
    public final TileAlstroemeriaAquarium tile;
    public List<Slot> slotList = new ArrayList<Slot>();
    public List<Slot> resultList = new ArrayList<Slot>();

    public AlstroemeriaAquariumMenu(int windowId, Inventory pInv, FriendlyByteBuf data) {
        this(windowId, pInv, (TileAlstroemeriaAquarium)MenuInit.getTile(TileAlstroemeriaAquarium::new, pInv, data));
    }

    public AlstroemeriaAquariumMenu(int windowId, Inventory pInv, TileAlstroemeriaAquarium tile) {
        super(MenuInit.alstroemeriaAquariumMenu, windowId, pInv, tile);
        int x;
        int y;
        this.tile = tile;
        this.slotList.add(this.m_38897_((Slot)new AlstroemeriaSlot(this.tile, this.tile.getHand(), 0, 80, 13, true)));
        for (y = 0; y < 2; ++y) {
            for (x = 0; x < 5; ++x) {
                this.slotList.add(this.m_38897_((Slot)new AlstroemeriaSlot(this.tile, this.tile.getInput(), x + y * 5, 44 + x * 18, 48 + y * 18, false)));
            }
        }
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 9; ++x) {
                this.resultList.add(this.m_38897_((Slot)new SMSlot(this.tile.getOutput(), x + y * 9, 8 + x * 18, 90 + y * 18, s -> false)));
            }
        }
        this.setPInv(pInv, 8, 148);
        this.setSlotSize(this.tile.getInvSize() + 10 + 1);
    }

    public boolean m_6366_(Player player, int id) {
        if (player instanceof ServerPlayer) {
            ServerPlayer sePlayer = (ServerPlayer)player;
            NetworkHooks.openScreen((ServerPlayer)sePlayer, (MenuProvider)new BaseContainer.ContainerAlstroemeriaAquarium(this.tile), (BlockPos)this.tile.m_58899_());
        }
        this.tile.clickButton();
        return true;
    }

    public class AlstroemeriaSlot
    extends SMSlot {
        private final int index;
        public final boolean isMain;
        public final TileAlstroemeriaAquarium tile;

        public AlstroemeriaSlot(TileAlstroemeriaAquarium tile, IItemHandler handler, int index, int xPos, int yPos, boolean isMain) {
            super(handler, index, xPos, yPos);
            this.tile = tile;
            this.index = index;
            this.isMain = isMain;
        }

        public boolean m_6659_() {
            if (this.isMain) {
                return true;
            }
            List<List<ItemStack>> subStackList = this.tile.subStackListList;
            return subStackList.isEmpty() || this.index <= subStackList.size() - 1;
        }

        @Override
        public boolean m_5857_(@NotNull ItemStack stack) {
            boolean isPlace = super.m_5857_(stack);
            if (this.isMain) {
                ArrayList mainStack = new ArrayList();
                this.tile.mainStackList.forEach(s -> mainStack.add(s.m_41720_()));
                return isPlace && (mainStack.isEmpty() || mainStack.contains(stack.m_41720_()));
            }
            List<List<ItemStack>> subStackList = this.tile.subStackListList;
            if (subStackList.isEmpty()) {
                return isPlace;
            }
            ArrayList subStack = new ArrayList();
            subStackList.get(Math.min(subStackList.size() - 1, this.index)).forEach(s -> subStack.add(s.m_41720_()));
            return isPlace && this.m_6659_() && (subStack.isEmpty() || subStack.contains(stack.m_41720_()));
        }
    }
}

