/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.menu;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkHooks;
import sweetmagic.init.tile.menu.container.BaseContainer;
import sweetmagic.init.tile.slot.MagiaSlot;
import sweetmagic.init.tile.sm.TileAbstractSM;

public abstract class BaseSMMenu
extends AbstractContainerMenu {
    public int tickCount = 0;
    public int oldIndex = 0;
    protected final Random rand = new Random();
    public final TileAbstractSM tile;
    public int slotSize = 0;
    public Player player;

    public BaseSMMenu(MenuType<?> type, int windowId, Inventory pInv, TileAbstractSM tile) {
        super(type, windowId);
        this.tile = tile;
        this.player = pInv.f_35978_;
    }

    public void setPInv(Inventory pInv, int tX, int tY) {
        this.setPInv(pInv, tX, tY, 0);
    }

    public void setPInv(Inventory pInv, int tX, int tY, int addY) {
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.m_38897_(new Slot((Container)pInv, x + y * 9 + 9, tX + x * 18, tY + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.m_38897_(new Slot((Container)pInv, x, tX + x * 18, tY + 58 + addY));
        }
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack stack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (index <= this.getSlotSize() && this.oldIndex == index && this.tickCount == player.f_19797_) {
            return stack;
        }
        this.tickCount = player.f_19797_;
        this.oldIndex = index;
        if (slot != null && slot.m_6657_()) {
            ItemStack stack1 = slot.m_7993_();
            stack = stack1.m_41777_();
            int slotCount = this.getSlotSize();
            if (index < slotCount ? !this.m_38903_(stack1, slotCount, this.f_38839_.size(), true) : !this.m_38903_(stack1, 0, slotCount, false)) {
                return ItemStack.f_41583_;
            }
            if (stack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            this.quickMoveStack(player, slot, stack, stack1);
        }
        return stack;
    }

    public boolean moveSlot(ItemStack stack, int slotStart, int slotEnd, boolean par1) {
        int i;
        boolean flag = false;
        int n = i = par1 ? slotEnd - 1 : slotStart;
        if (this.checkStack(stack)) {
            while (!stack.m_41619_() && !(!par1 ? i >= slotEnd : i < slotStart)) {
                Slot slot = (Slot)this.f_38839_.get(i);
                ItemStack stack1 = slot.m_7993_();
                if (!stack1.m_41619_() && ItemStack.m_150942_((ItemStack)stack, (ItemStack)stack1)) {
                    int maxSize;
                    int count = stack1.m_41613_() + stack.m_41613_();
                    int n2 = maxSize = this.checkSlotValue(slot, stack) ? slot.m_5866_(stack) : Math.min(slot.m_5866_(stack), stack.m_41741_());
                    if (count <= maxSize) {
                        stack.m_41764_(0);
                        stack1.m_41764_(count);
                        slot.m_6654_();
                        flag = true;
                    } else if (stack1.m_41613_() < maxSize) {
                        stack.m_41774_(maxSize - stack1.m_41613_());
                        stack1.m_41764_(maxSize);
                        slot.m_6654_();
                        flag = true;
                    }
                }
                i = par1 ? i - 1 : i + 1;
            }
        }
        if (!stack.m_41619_()) {
            int n3 = i = par1 ? slotEnd - 1 : slotStart;
            while (!(!par1 ? i >= slotEnd : i < slotStart)) {
                Slot slot1 = (Slot)this.f_38839_.get(i);
                ItemStack stack2 = slot1.m_7993_();
                if (stack2.m_41619_() && slot1.m_5857_(stack)) {
                    slot1.m_5852_(stack.m_41613_() > slot1.m_5866_(stack) ? stack.m_41620_(slot1.m_5866_(stack)) : stack.m_41620_(stack.m_41613_()));
                    slot1.m_6654_();
                    flag = true;
                    break;
                }
                i = par1 ? i - 1 : i + 1;
            }
        }
        return flag;
    }

    public boolean checkStack(ItemStack stack) {
        return stack.m_41753_();
    }

    public boolean checkSlotValue(Slot slot, ItemStack stack) {
        return slot instanceof MagiaSlot;
    }

    public void quickMoveStack(Player player, Slot slot, ItemStack oldStack, ItemStack newStack) {
    }

    public TileAbstractSM getTile() {
        return this.tile;
    }

    public void setSlotSize(int slotSize) {
        this.slotSize = slotSize;
    }

    public int getSlotSize() {
        return this.slotSize;
    }

    public void openFilter() {
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            NetworkHooks.openScreen((ServerPlayer)sp, (MenuProvider)new BaseContainer.ContainerItemFilter(this.tile), (BlockPos)this.tile.m_58899_());
        }
    }

    public boolean m_6875_(Player player) {
        BlockPos pos = this.getTile().m_58899_();
        return player.m_20275_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5) <= 64.0;
    }
}

