/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.menu;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import sweetmagic.init.MenuInit;
import sweetmagic.init.tile.menu.BaseSMMenu;
import sweetmagic.init.tile.slot.MagiaSlot;
import sweetmagic.init.tile.slot.SlotInput;
import sweetmagic.init.tile.sm.TileDresser;
import sweetmagic.util.ItemHelper;

public class DresserMenu
extends BaseSMMenu {
    public final TileDresser tile;

    public DresserMenu(int windowId, Inventory pInv, FriendlyByteBuf data) {
        this(windowId, pInv, (TileDresser)MenuInit.getTile(TileDresser::new, pInv, data));
    }

    public DresserMenu(int windowId, Inventory pInv, TileDresser tile) {
        super(MenuInit.dresserMenu, windowId, pInv, tile);
        this.tile = tile;
        IItemHandler fuel = this.tile.getInput();
        for (int y = 0; y < 6; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.m_38897_((Slot)new MagiaSlot(tile, fuel, x + y * 9, 8 + x * 18, 8 + y * 18, SlotInput.ISSM_ACC));
            }
        }
        this.setPInv(pInv, 8, 120);
        this.setSlotSize(this.tile.getInvSize());
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.tile.playSound(this.tile.m_58899_(), SoundEvents.f_11724_, 0.5f, this.rand.nextFloat() * 0.1f + 0.9f);
    }

    public boolean m_6366_(Player player, int id) {
        switch (id) {
            case 0: {
                ItemHelper.compactInventory((IItemHandlerModifiable)this.tile.inputInv);
                break;
            }
            case 1: {
                ItemHelper.inventoryInput(player, (IItemHandlerModifiable)this.tile.inputInv);
                break;
            }
            case 2: {
                ItemHelper.inventoryOutput(player, (IItemHandlerModifiable)this.tile.inputInv);
            }
        }
        this.tile.clickButton();
        return true;
    }

    protected boolean m_38903_(ItemStack stack, int slotStart, int slotEnd, boolean par1) {
        return this.moveSlot(stack, slotStart, slotEnd, par1);
    }

    @Override
    public boolean checkStack(ItemStack stack) {
        return true;
    }
}

