/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.menu;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import sweetmagic.init.MenuInit;
import sweetmagic.init.tile.menu.BaseSMMenu;
import sweetmagic.init.tile.slot.SMSlot;
import sweetmagic.init.tile.sm.TileFurnitureTable;

public class FurnitureCraftMenu
extends BaseSMMenu {
    public final TileFurnitureTable tile;
    public final Slot resultSlot;

    public FurnitureCraftMenu(int windowId, Inventory pInv, FriendlyByteBuf data) {
        this(windowId, pInv, (TileFurnitureTable)MenuInit.getTile(TileFurnitureTable::new, pInv, data));
    }

    public FurnitureCraftMenu(int windowId, Inventory pInv, TileFurnitureTable tile) {
        super(MenuInit.furnitureCraftMenu, windowId, pInv, tile);
        this.tile = tile;
        this.resultSlot = this.m_38897_((Slot)new SMSlot(this.tile.getResult(), 0, 54, 24, s -> false));
        this.tile.oldSetCount = this.tile.setCount;
        this.tile.sendPKT();
    }

    public boolean m_6366_(Player player, int id) {
        int addCount = 0;
        switch (id) {
            case 0: {
                ++addCount;
                break;
            }
            case 1: {
                --addCount;
                break;
            }
            case 2: {
                addCount += this.tile.setCount == 1 ? 9 : 10;
                break;
            }
            case 3: {
                addCount -= this.tile.setCount == 1 ? 9 : 10;
                break;
            }
            case 4: {
                addCount += this.tile.setCount == 1 ? 63 : 64;
                break;
            }
            case 5: {
                addCount -= this.tile.setCount == 1 ? 63 : 64;
                break;
            }
            case 6: {
                if (player instanceof ServerPlayer) {
                    ServerPlayer sePlayer = (ServerPlayer)player;
                    this.tile.openGUI(this.tile.m_58899_(), (Player)sePlayer);
                    int count = this.tile.outStack.m_41613_();
                    int value = this.tile.setCount / count;
                    this.tile.setCount = Math.max(value * count, count);
                    this.tile.isUpdate = true;
                    this.tile.clickButton();
                    this.tile.sendPKT();
                }
                return true;
            }
            case 7: {
                if (player instanceof ServerPlayer) {
                    ServerPlayer sePlayer = (ServerPlayer)player;
                    this.tile.openGUI(this.tile.m_58899_(), (Player)sePlayer);
                    this.tile.setCount = this.tile.oldSetCount;
                    this.tile.clickButton();
                    this.tile.sendPKT();
                }
                return true;
            }
        }
        this.tile.setCount = Math.min(9999, Math.max(1, this.tile.setCount + addCount));
        this.tile.clickButton();
        this.tile.sendPKT();
        return true;
    }
}

