/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.menu;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import sweetmagic.init.MenuInit;
import sweetmagic.init.tile.menu.BaseSMMenu;
import sweetmagic.init.tile.slot.SMSlot;
import sweetmagic.init.tile.slot.SlotArmor;
import sweetmagic.init.tile.slot.SlotInput;
import sweetmagic.init.tile.sm.TileMagiaRewrite;
import sweetmagic.util.SMUtil;

public class MagiaRewriteMenu
extends BaseSMMenu {
    public final TileMagiaRewrite tile;
    public final Slot bookSlot;
    public final Slot magicBookSlot;
    private Runnable slotUpdateListener = () -> {};

    public MagiaRewriteMenu(int windowId, Inventory pInv, FriendlyByteBuf data) {
        this(windowId, pInv, (TileMagiaRewrite)MenuInit.getTile(TileMagiaRewrite::new, pInv, data));
    }

    public MagiaRewriteMenu(int windowId, Inventory pInv, TileMagiaRewrite tile) {
        super(MenuInit.magiaRewriteMenu, windowId, pInv, tile);
        this.tile = tile;
        int addX = 24;
        int nowLevel = this.tile.nowLevel;
        this.magicBookSlot = this.m_38897_((Slot)new SMSlot(this.tile.getBook(), 0, 76 + addX, 8, SlotInput.ISREWRITE){

            public void m_6654_() {
                super.m_6654_();
                MagiaRewriteMenu.this.slotsChangedSide(this.f_40218_);
                MagiaRewriteMenu.this.slotUpdateListener.run();
            }
        });
        this.bookSlot = this.m_38897_((Slot)new SMSlot(this.tile.getInput(), 0, 44 + addX, 24, SlotInput.ISENCHA));
        this.m_38897_((Slot)new SMSlot(this.tile.getOut(), 0, 43 + addX, 84, s -> false));
        this.setPInv(pInv, 12 + addX, 111, -2);
        this.setSlotSize(4);
        this.tile.nowLevel = nowLevel;
        this.tile.sendPKT();
        for (int y = 0; y < 4; ++y) {
            this.m_38897_(new SlotArmor((Entity)pInv.f_35978_, SMUtil.getEquipmentSlot(y), pInv, 39 - y, -19 + addX, 114 + y * 18));
        }
    }

    public void slotsChangedSide(Container container) {
        this.tile.nowLevel = 1;
        this.tile.sendPKT();
    }

    public void registerUpdateListener(Runnable run) {
        this.slotUpdateListener = run;
    }

    public boolean m_6366_(Player player, int id) {
        if (this.tile.isCraft) {
            return false;
        }
        if (id == -1) {
            this.tile.cycleChangeOutput();
        } else if (id <= 1) {
            this.tile.clickLevelButton(id);
        } else {
            this.tile.craftStart(id - 2);
        }
        return true;
    }
}

