/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.menu;

import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import sweetmagic.init.MenuInit;
import sweetmagic.init.tile.menu.BaseSMMenu;
import sweetmagic.init.tile.slot.MagiaSlot;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileMagiaStorage;
import sweetmagic.util.ItemHelper;

public class MagiaStorageMenu
extends BaseSMMenu {
    public final TileMagiaStorage tile;
    public final NonNullList<Slot> slotList = NonNullList.m_122779_();
    private final TileAbstractSM.MagiaHandler inv;

    public MagiaStorageMenu(int windowId, Inventory pInv, FriendlyByteBuf data) {
        this(windowId, pInv, (TileMagiaStorage)MenuInit.getTile(TileMagiaStorage::new, pInv, data));
    }

    public MagiaStorageMenu(int windowId, Inventory pInv, TileMagiaStorage tile) {
        super(MenuInit.magiaStorageMenu, windowId, pInv, tile);
        this.tile = tile;
        this.inv = this.tile.getInput();
        for (int y = 0; y < 8; ++y) {
            for (int x = 0; x < 13; ++x) {
                this.addSlots((Slot)new MagiaSlot(tile, (IItemHandler)this.inv, x + y * 13, 5 + x * 18, 5 + y * 18), tile.m_58904_());
            }
        }
        this.setPInv(pInv, 41, 151, 1);
        this.setSlotSize(this.tile.getInvSize());
    }

    protected Slot addSlots(Slot slot, Level world) {
        this.slotList.add((Object)slot);
        return this.m_38897_(slot);
    }

    protected boolean m_38903_(ItemStack stack, int slotStart, int slotEnd, boolean par1) {
        return this.moveSlot(stack, slotStart, slotEnd, par1);
    }

    public boolean m_6366_(Player player, int id) {
        switch (id) {
            case 0: {
                ItemHelper.compactInventory((IItemHandlerModifiable)this.tile.inputInv);
                break;
            }
            case 1: {
                ItemHelper.inventoryInput(player, (IItemHandlerModifiable)this.tile.inputInv);
                break;
            }
            case 2: {
                ItemHelper.inventoryOutput(player, (IItemHandlerModifiable)this.tile.inputInv);
            }
        }
        this.tile.sendPKT();
        return true;
    }
}

