/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.menu;

import java.lang.reflect.Field;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import sweetmagic.init.MenuInit;
import sweetmagic.init.tile.menu.BaseSMMenu;
import sweetmagic.init.tile.slot.SMSlot;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileParallelInterfere;
import sweetmagic.util.ItemHelper;

public class ParallelInterfereMenu
extends BaseSMMenu {
    public final TileParallelInterfere tile;

    public ParallelInterfereMenu(int windowId, Inventory pInv, FriendlyByteBuf data) {
        this(windowId, pInv, (TileParallelInterfere)MenuInit.getTile(TileParallelInterfere::new, pInv, data));
    }

    public ParallelInterfereMenu(int windowId, Inventory pInv, TileParallelInterfere tile) {
        super(MenuInit.parallelInterfereMenu, windowId, pInv, tile);
        this.tile = tile;
        IItemHandler fuel = this.tile.getInput();
        int maxY = tile.getInvSize() / 9;
        for (int y = 0; y < maxY; ++y) {
            for (int x = 0; x < 9; ++x) {
                int pY = x + y * 9 >= 54 ? Integer.MAX_VALUE : 8 + y * 18;
                this.m_38897_((Slot)new SMSlot(fuel, x + y * 9, 8 + x * 18, pY));
            }
        }
        this.setPInv(pInv, 8, 120);
        this.setSlotSize(this.tile.getInvSize());
    }

    public void updateSlotPositions(int offsetY) {
        int maxY = this.tile.getInvSize() / 9;
        for (int y = 0; y < maxY; ++y) {
            for (int x = 0; x < 9; ++x) {
                int tX = x + (y - offsetY) * 9;
                int pY = tX >= 54 || tX < 0 ? -1000 : 8 + (y - offsetY) * 18;
                Slot slot = (Slot)this.f_38839_.get(x + y * 9);
                this.setSlotPosY(slot, pY);
            }
        }
    }

    public void setSlotPos(Slot slot, String fieldName, int newValue) {
        try {
            Field field = ObfuscationReflectionHelper.findField(Slot.class, (String)fieldName);
            field.setAccessible(true);
            field.set(slot, newValue);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public void setSlotPosY(Slot slot, int newValue) {
        this.setSlotPos(slot, "f_40221_", newValue);
    }

    public boolean m_6366_(Player player, int id) {
        TileAbstractSM.StackHandler inv = (TileAbstractSM.StackHandler)this.tile.getInput();
        switch (id) {
            case -1: {
                return true;
            }
            case 0: {
                ItemHelper.compactInventory((IItemHandlerModifiable)inv);
                break;
            }
            case 1: {
                ItemHelper.inventoryInput(player, (IItemHandlerModifiable)inv);
                break;
            }
            case 2: {
                ItemHelper.inventoryOutput(player, (IItemHandlerModifiable)inv);
            }
        }
        this.tile.clickButton();
        return true;
    }
}

