/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.menu;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import sweetmagic.api.iitem.info.PhoneInfo;
import sweetmagic.handler.PacketHandler;
import sweetmagic.init.ItemInit;
import sweetmagic.init.MenuInit;
import sweetmagic.init.capability.icap.ICookingStatus;
import sweetmagic.init.tile.menu.BaseItemMenu;
import sweetmagic.init.tile.slot.SMSlot;
import sweetmagic.init.tile.sm.TileNotePC;
import sweetmagic.packet.AddSPtoServerPKT;

public class PhoneMenu
extends BaseItemMenu {
    public boolean isSingle = false;
    public List<List<TileNotePC.TradeInfo>> tradeList = new ArrayList<List<TileNotePC.TradeInfo>>();
    public List<PlayerInfo> infoList;
    public Map<UUID, ICookingStatus> statusMap = new HashMap<UUID, ICookingStatus>();
    private Map<UUID, Player> playerMap = new HashMap<UUID, Player>();
    public ICookingStatus cook;
    public ItemStack stack;
    public int sp = 0;

    public PhoneMenu(int windowId, Inventory pInv, FriendlyByteBuf data) {
        this(windowId, pInv, pInv.f_35978_.m_21205_());
    }

    public PhoneMenu(int windowId, Inventory pInv, ItemStack stack) {
        super(MenuInit.phoneMenu, windowId, pInv, new PhoneInfo(stack).getInv());
        Player pl;
        this.m_38897_((Slot)new SMSlot((IItemHandler)this.inventory, 0, 132, 88));
        this.setPInv(pInv, 6, 110);
        Player player = pInv.f_35978_;
        ICookingStatus.sendPKT(player);
        boolean isClient = player.m_9236_().m_5776_();
        this.cook = ICookingStatus.getState((LivingEntity)player);
        this.infoList = isClient ? Minecraft.m_91087_().m_91403_().m_105142_().stream().filter(p -> !p.m_105312_().getId().equals(player.m_20148_())).toList() : new ArrayList<PlayerInfo>();
        this.stack = player.m_21205_();
        this.tradeList = this.getTradeInfo();
        if (!isClient && player instanceof ServerPlayer) {
            ServerPlayer server = (ServerPlayer)player;
            for (Entity entity : server.m_9236_().m_6907_()) {
                if (!(entity instanceof Player) || (pl = (Player)entity) == player) continue;
                this.playerMap.put(pl.m_20148_(), pl);
                this.statusMap.put(pl.m_20148_(), ICookingStatus.getState((LivingEntity)pl));
            }
        }
        if (isClient && player instanceof LocalPlayer) {
            LocalPlayer local = (LocalPlayer)player;
            for (Entity entity : local.f_108545_.m_104735_()) {
                if (!(entity instanceof Player) || (pl = (Player)entity).m_20148_() == player.m_20148_()) continue;
                this.playerMap.put(pl.m_20148_(), pl);
            }
        }
        boolean bl = this.isSingle = isClient ? this.infoList.isEmpty() : this.playerMap.isEmpty();
        if (this.isSingle) {
            this.sp = Math.max(1, this.sp);
        }
    }

    public void m_150399_(int slotId, int dragType, ClickType clickType, Player player) {
        if (slotId >= 36 || slotId <= -1) {
            super.m_150399_(slotId, dragType, clickType, player);
            return;
        }
        ItemStack stack = ((Slot)this.f_38839_.get(slotId)).m_7993_();
        if (stack.m_41619_() || !stack.m_150930_(player.m_21205_().m_41720_())) {
            super.m_150399_(slotId, dragType, clickType, player);
        }
    }

    public boolean m_6366_(Player player, int id) {
        Level world = player.m_9236_();
        player.m_5496_((SoundEvent)SoundEvents.f_12490_.get(), 0.15f, world.m_213780_().m_188501_() * 0.1f + 0.9f);
        if (id == -1) {
            return true;
        }
        if (this.isSingle) {
            this.clickMenuSingleButton(player, id);
            return true;
        }
        switch (id) {
            case 0: {
                this.sp = Math.min(Math.min(100000, this.cook.getTradeSP()), this.sp + 10);
                break;
            }
            case 1: {
                this.sp = Math.min(Math.min(100000, this.cook.getTradeSP()), this.sp + 100);
                break;
            }
            case 2: {
                this.sp = Math.min(Math.min(100000, this.cook.getTradeSP()), this.sp + 1000);
                break;
            }
            case 3: {
                this.sp = Math.max(0, this.sp - 10);
                break;
            }
            case 4: {
                this.sp = Math.max(0, this.sp - 100);
                break;
            }
            case 5: {
                this.sp = Math.max(0, this.sp - 1000);
                break;
            }
            case 6: {
                this.sendSP(player);
                break;
            }
            case 7: {
                this.sendItem(player);
                break;
            }
            case 8: {
                this.addButSale(player);
            }
        }
        return true;
    }

    public void clickMenuSingleButton(Player player, int id) {
        switch (id) {
            case 0: {
                this.sp = Math.min(64, this.sp + 1);
                break;
            }
            case 1: {
                this.sp = Math.min(64, this.sp + 10);
                break;
            }
            case 2: {
                this.sp = Math.min(64, this.sp + 64);
                break;
            }
            case 3: {
                this.sp = Math.max(1, this.sp - 1);
                break;
            }
            case 4: {
                this.sp = Math.max(1, this.sp - 10);
                break;
            }
            case 5: {
                this.sp = Math.max(1, this.sp - 64);
                break;
            }
            case 6: 
            case 7: {
                this.itemButBuy(player);
                break;
            }
            case 8: {
                this.addButSale(player);
            }
        }
    }

    public void sendSP(Player player) {
        ItemStack stack = player.m_21205_();
        if (stack.m_41619_() || !player.m_9236_().m_5776_()) {
            return;
        }
        CompoundTag tags = this.stack.m_41784_();
        if (!tags.m_128441_("userId") || !tags.m_128471_("isSelect")) {
            return;
        }
        Player target = this.playerMap.get(tags.m_128342_("userId"));
        if (target == null) {
            return;
        }
        ICookingStatus targetCook = ICookingStatus.getState((LivingEntity)target);
        if (targetCook == null) {
            return;
        }
        PacketHandler.sendToServer(new AddSPtoServerPKT(target.m_20148_(), this.sp));
        PacketHandler.sendToServer(new AddSPtoServerPKT(player.m_20148_(), -this.sp));
    }

    public void sendItem(Player player) {
        ItemStack stack = this.inventory.getInv().getStackInSlot(0);
        if (stack.m_41619_() || player.m_9236_().m_5776_()) {
            return;
        }
        CompoundTag tags = this.stack.m_41784_();
        if (!tags.m_128441_("userId") || !tags.m_128471_("isSelect")) {
            return;
        }
        Player target = this.playerMap.get(tags.m_128342_("userId"));
        if (player == null) {
            return;
        }
        Level world = target.m_9236_();
        world.m_7967_((Entity)new ItemEntity(world, target.m_20185_(), target.m_20186_() + 0.5, target.m_20189_(), stack.m_41777_()));
        stack.m_41774_(stack.m_41613_());
        this.inventory.writeBack();
    }

    public void addButSale(Player player) {
        ItemStack stack = this.inventory.getInv().getStackInSlot(0);
        if (stack.m_41619_() || player.m_9236_().m_5776_()) {
            return;
        }
        int value = TileNotePC.getGlobalValue(1.0f, stack);
        stack.m_41774_(stack.m_41613_());
        this.cook.addTradeExp(player.m_9236_(), value, false);
        this.cook.addTradeSP(value);
        ICookingStatus.sendPKT(player);
        this.inventory.writeBack();
    }

    public void itemButBuy(Player player) {
        CompoundTag tags = this.stack.m_41784_();
        if (!tags.m_128441_("selectId") || tags.m_128471_("isSelect")) {
            return;
        }
        int selectId = tags.m_128451_("selectId");
        int id = selectId % 8;
        int tabId = selectId / 8;
        TileNotePC.TradeInfo info = this.tradeList.get(tabId).get(id);
        int value = info.price() * this.sp;
        if (value > this.cook.getTradeSP()) {
            return;
        }
        ItemStack copy = info.stack().m_41777_();
        copy.m_41764_(this.sp);
        Level world = player.m_9236_();
        if (world.m_5776_()) {
            return;
        }
        world.m_7967_((Entity)new ItemEntity(world, player.m_20185_(), player.m_20186_() + 0.5, player.m_20189_(), copy));
        this.cook.addTradeExp(player.m_9236_(), value, true);
        this.cook.addTradeSP(-value);
        ICookingStatus.sendPKT(player);
    }

    public List<List<TileNotePC.TradeInfo>> getTradeInfo() {
        ArrayList<List<TileNotePC.TradeInfo>> infoListList = new ArrayList<List<TileNotePC.TradeInfo>>();
        ArrayList<TileNotePC.TradeInfo> infoList0 = new ArrayList<TileNotePC.TradeInfo>();
        infoList0.add(TileNotePC.TradeInfo.create(ItemInit.aether_crystal, 1200));
        infoList0.add(TileNotePC.TradeInfo.create(ItemInit.alternative_ingot, 500));
        infoList0.add(TileNotePC.TradeInfo.create(ItemInit.blank_magic, 50));
        infoList0.add(TileNotePC.TradeInfo.create(ItemInit.blank_page, 50));
        infoList0.add(TileNotePC.TradeInfo.create(ItemInit.mysterious_page, 200));
        infoList0.add(TileNotePC.TradeInfo.create(ItemInit.magic_meal, 100));
        infoList0.add(TileNotePC.TradeInfo.create(ItemInit.aether_recovery_book1, 2000));
        infoList0.add(TileNotePC.TradeInfo.create(ItemInit.seed_bag, 2000));
        ArrayList<TileNotePC.TradeInfo> infoList1 = new ArrayList<TileNotePC.TradeInfo>();
        infoList1.add(TileNotePC.TradeInfo.create(ItemInit.unmeltable_ice, 300));
        infoList1.add(TileNotePC.TradeInfo.create(ItemInit.tiny_feather, 300));
        infoList1.add(TileNotePC.TradeInfo.create(ItemInit.poison_bottle, 300));
        infoList1.add(TileNotePC.TradeInfo.create(ItemInit.electronic_orb, 300));
        infoList1.add(TileNotePC.TradeInfo.create(ItemInit.grav_powder, 300));
        infoList1.add(TileNotePC.TradeInfo.create(ItemInit.stray_soul, 300));
        infoList1.add(TileNotePC.TradeInfo.create(ItemInit.witch_tears, 750));
        infoList1.add(TileNotePC.TradeInfo.create(ItemInit.prizmium, 600));
        infoListList.add(infoList0);
        infoListList.add(infoList1);
        return infoListList;
    }
}

