/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.sm;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.BossEvent;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import sweetmagic.api.ientity.ISMMob;
import sweetmagic.init.BlockInit;
import sweetmagic.init.ItemInit;
import sweetmagic.init.ParticleInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.entity.animal.AbstractSummonMob;
import sweetmagic.init.entity.monster.ArchSpider;
import sweetmagic.init.entity.monster.BlazeTempest;
import sweetmagic.init.entity.monster.BlazeTempestTornado;
import sweetmagic.init.entity.monster.DwarfZombie;
import sweetmagic.init.entity.monster.DwarfZombieMaster;
import sweetmagic.init.entity.monster.EnderMage;
import sweetmagic.init.entity.monster.EnderShadow;
import sweetmagic.init.entity.monster.SkullFlame;
import sweetmagic.init.entity.monster.SkullFlameArcher;
import sweetmagic.init.entity.monster.SkullFrost;
import sweetmagic.init.entity.monster.SkullFrostRoyalGuard;
import sweetmagic.init.entity.monster.boss.QueenFrost;
import sweetmagic.init.tile.sm.TileSMMagic;
import sweetmagic.init.tile.sm.TileWoodChest;
import sweetmagic.util.ItemHelper;
import sweetmagic.util.SMDamage;

public abstract class TileAbstractMagicianLectern
extends TileSMMagic {
    public int tileTime = 0;
    public int oldCharge = 8;
    public int wave = 1;
    public float chargeSummonSize = 0.0f;
    public int dethMobCount = 0;
    public int summonMaxCount = 24;
    public int summonCount = 0;
    public int waitTime = 0;
    public int maxWaitTime = 0;
    public int chageTime = 0;
    public boolean deathBoss = false;
    public boolean isHard = false;
    public boolean isButtle = false;
    public SummonType summonType = SummonType.START;
    public ItemStack stack = ItemStack.f_41583_;
    public Monster boss = null;
    public UUID bossId = null;
    private static final SummonType START = SummonType.START;
    private static final SummonType SUMMON = SummonType.SUMMON;
    private static final SummonType CHARGE = SummonType.CHARGE;
    private static final SummonType END = SummonType.END;
    private static final SummonType WAIT = SummonType.WAIT;
    protected final ServerBossEvent bossEvent = (ServerBossEvent)new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.YELLOW, BossEvent.BossBarOverlay.NOTCHED_12).m_7003_(true);

    public TileAbstractMagicianLectern(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void serverTick(Level world, BlockPos pos, BlockState state) {
        super.serverTick(world, pos, state);
        if (this.isPeaceful(world)) {
            return;
        }
        if (this.summonType.is(SummonType.CHARGE) || this.summonType.is(SummonType.SUMMON)) {
            ++this.tileTime;
            this.sendPKT();
        }
        if (this.tickTime % 3 != 0 || this.summonType.is(START) || this.summonType.is(END)) {
            return;
        }
        if (this.boss == null && this.bossId != null) {
            this.boss = (Monster)((ServerLevel)this.m_58904_()).m_8791_(this.bossId);
        }
        if (this.summonType.is(SUMMON) || this.wave != 4 || this.summonType.is(CHARGE)) {
            this.addPlayerBossBar(world, pos);
        }
        if (this.summonType.is(SummonType.SUMMON)) {
            this.setBossBar(world, pos);
            if (this.tickTime % this.getSummonInterval() == 0 && (this.dethMobCount < this.summonMaxCount || this.wave >= 4)) {
                this.onSummonMob(world, pos);
            }
            if (this.dethMobCount >= this.summonMaxCount && this.wave <= 3 || this.wave >= 4 && this.deathBoss) {
                this.setNextWave(world, pos);
            }
        } else if (this.summonType.is(WAIT)) {
            ++this.waitTime;
            if (this.waitTime >= this.maxWaitTime) {
                this.summonType = CHARGE;
                if (this.wave >= 4) {
                    this.addPlayerBossBar(world, pos);
                    this.bossEvent.m_5648_(BossEvent.BossBarOverlay.NOTCHED_6);
                    this.bossEvent.m_6451_(BossEvent.BossBarColor.BLUE);
                }
            }
            this.sendPKT();
        } else if (this.summonType.is(CHARGE)) {
            this.chargeBossBar(world, pos);
        }
    }

    public void setMobSize(Level wrold, BlockPos pos) {
        List<ServerPlayer> playerList = this.getPlayer(ServerPlayer.class);
        int baseWave = 16;
        int playerAddWave = 8;
        switch (this.wave) {
            case 1: {
                baseWave = 16;
                playerAddWave = 8;
                break;
            }
            case 2: {
                baseWave = 20;
                playerAddWave = 16;
                break;
            }
            case 3: {
                baseWave = 24;
                playerAddWave = 24;
                break;
            }
            case 4: {
                baseWave = 24;
                playerAddWave = 16;
            }
        }
        this.summonMaxCount = baseWave + playerAddWave * (playerList.size() - 1);
    }

    public void addPlayerBossBar(Level wrold, BlockPos pos) {
        List<ServerPlayer> playerList = this.getPlayer(ServerPlayer.class);
        List<Player> outrangePlayerList = wrold.m_6907_().stream().filter(e -> !playerList.contains(e)).toList();
        playerList.forEach(p -> this.bossEvent.m_6543_(p));
        for (Player player : outrangePlayerList) {
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer server = (ServerPlayer)player;
            this.bossEvent.m_6539_(server);
        }
        if (this.wave >= 4) {
            this.bossEvent.m_5648_(BossEvent.BossBarOverlay.NOTCHED_6);
            this.bossEvent.m_6451_(BossEvent.BossBarColor.BLUE);
        }
    }

    public void removeAllPlayerBossBar() {
        this.bossEvent.m_7706_();
    }

    public void setBossBar(Level world, BlockPos pos) {
        if (this.wave >= 4) {
            if (this.boss == null) {
                return;
            }
            float gage = this.boss.m_21223_() / this.boss.m_21233_();
            this.bossEvent.m_142711_(gage);
            this.bossEvent.m_6456_(this.boss.m_5446_());
            boolean bl = this.deathBoss = !this.boss.m_6084_();
            if (!this.deathBoss) {
                return;
            }
            List<Monster> mobList = this.getMobList();
            for (Monster entity : mobList) {
                entity.m_21153_(1.0f);
                entity.m_6469_(SMDamage.getDamage(SMDamage.magicDamage, world), 999.0f);
            }
            List<ItemEntity> entityItemList = this.getEntityList(ItemEntity.class, e -> e.m_32055_().m_150930_(ItemInit.evil_arrow), 128.0);
            entityItemList.forEach(e -> e.m_146870_());
            List<Player> playerList = this.getPlayer(Player.class);
            for (Player player : playerList) {
                List<ItemStack> stackList = player.m_150109_().f_35974_.stream().filter(s -> !s.m_41619_() && s.m_150930_(ItemInit.evil_arrow)).toList();
                stackList.forEach(s -> s.m_41774_(s.m_41613_()));
            }
        } else {
            List<Monster> entityDeadList = this.getEntityList(Monster.class, e -> !e.m_6084_() && !e.getPersistentData().m_128471_(this.deadTip()) && e.m_21023_(PotionInit.darkness_fog), 128.0);
            this.dethMobCount += entityDeadList.size();
            for (Monster monster : entityDeadList) {
                monster.getPersistentData().m_128379_(this.deadTip(), true);
                this.spawnDeathParticle(world, pos, monster);
            }
            this.bossEvent.m_142711_((float)(this.summonMaxCount - this.dethMobCount) / (float)this.summonMaxCount);
            this.bossEvent.m_6456_((Component)this.getWaveName());
            if (this.dethMobCount < this.summonMaxCount - 3) {
                return;
            }
            List<Monster> entityList = this.getMobList();
            entityList.forEach(e -> this.addPotion((LivingEntity)e, MobEffects.f_19619_, 99999, 0));
        }
    }

    public <T extends Player> List<T> getPlayer(Class<T> enClass) {
        return this.getEntityList(enClass, p -> !p.m_5833_() && p.m_6084_(), 64.0);
    }

    public List<Monster> getMobList() {
        return this.getEntityList(Monster.class, e -> e.m_6084_() && e.m_21023_(PotionInit.darkness_fog) && !(e instanceof QueenFrost), 128.0);
    }

    public abstract String deadTip();

    public MutableComponent getWaveName() {
        MutableComponent tip = null;
        if (this.wave != 4) {
            tip = this.getTipArray(new Object[]{this.getLabel("Wave " + this.wave + ": "), this.getLabel(this.dethMobCount + "/" + this.summonMaxCount)});
        }
        return tip;
    }

    public void chargeBossBar(Level world, BlockPos pos) {
        float chargeGage;
        ++this.chageTime;
        this.chargeSummonSize = chargeGage = this.chargeSummonSize + (float)this.summonMaxCount / 80.0f;
        this.bossEvent.m_142711_(Math.min(chargeGage, (float)this.summonMaxCount) / (float)this.summonMaxCount);
        int time = (80 - this.chageTime) / 10 + 1;
        if (time <= this.oldCharge - 1) {
            this.playSound(pos, SoundEvents.f_144119_, 1.0f, 1.0f);
            this.oldCharge = time;
        }
        Object name = this.summonType.is(CHARGE) ? time + "sec" : "";
        Object wave = "Wave " + this.wave;
        if (this.wave == 3) {
            wave = "Final Wave ";
        } else if (this.wave == 4) {
            wave = "Extra Wave ";
        }
        this.bossEvent.m_6456_((Component)this.getTipArray(new Object[]{this.getLabel((String)wave + " : "), this.getText("preparing"), this.getLabel(" " + (String)name)}));
        this.spawnParticle(world, pos);
        if (chargeGage < (float)this.summonMaxCount) {
            return;
        }
        if (this.wave >= 4) {
            int summonMobSize = this.getEntityList(AbstractSummonMob.class, e -> e.m_6084_(), 80.0).size();
            float addHealth = 1.0f + (float)summonMobSize * (0.05f * (float)this.getBattleLevel());
            this.summonBoss(world, pos, addHealth);
            this.playSound(pos, (SoundEvent)((Holder.Reference)SoundEvents.f_215702_.get(5)).get(), 1.0f, 0.875f);
        } else {
            this.playSound(pos, (SoundEvent)((Holder.Reference)SoundEvents.f_215702_.get(2)).get(), 1.0f, 0.875f);
        }
        this.summonType = SUMMON;
        this.tickTime = -1;
        this.sendPKT();
    }

    public void onSummonMob(Level world, BlockPos pos) {
        int value = this.wave == 4 ? 4 : 8;
        List<Monster> mobList = this.getMobList();
        if (mobList.size() >= value) {
            return;
        }
        Random rand = this.rand;
        List<ServerPlayer> playerList = this.getPlayer(ServerPlayer.class);
        int count = 4 * playerList.size();
        BlockPos summonPos = new BlockPos(pos.m_123341_() + this.getRand(rand, 16), pos.m_123342_() + 1, pos.m_123343_() + this.getRand(rand, 16));
        while (!this.checkAABB(world, summonPos)) {
            summonPos = new BlockPos(pos.m_123341_() + this.getRand(rand, 12), pos.m_123342_() + 1, pos.m_123343_() + this.getRand(rand, 12));
        }
        int summonMobSize = this.getEntityList(AbstractSummonMob.class, e -> e.m_6084_(), 80.0).size();
        float addHealth = 1.0f + (float)summonMobSize * (0.05f * (float)this.getBattleLevel());
        for (int i = 0; i < count; ++i) {
            if (this.dethMobCount >= this.summonMaxCount && this.wave <= 3) {
                return;
            }
            boolean isZero = i % 4 == 0;
            Monster entity = isZero ? this.setBigMob(world, rand, addHealth) : this.setMob(world, rand, addHealth);
            int setPosCount = 0;
            if (isZero) {
                summonPos = new BlockPos(pos.m_123341_() + this.getRand(rand, 24), pos.m_123342_() + 1, pos.m_123343_() + this.getRand(rand, 24));
                while (!this.checkAABB(world, summonPos)) {
                    summonPos = new BlockPos(pos.m_123341_() + this.getRand(rand, 24), pos.m_123342_() + 1, pos.m_123343_() + this.getRand(rand, 24));
                    if (setPosCount++ < 16) continue;
                }
            }
            BlockPos secondPos = new BlockPos(summonPos.m_123341_() + this.getRand(rand, 3), summonPos.m_123342_(), summonPos.m_123343_() + this.getRand(rand, 3));
            setPosCount = 0;
            while (!this.checkAABB(world, secondPos)) {
                secondPos = new BlockPos(summonPos.m_123341_() + this.getRand(rand, 3), summonPos.m_123342_(), summonPos.m_123343_() + this.getRand(rand, 3));
                if (setPosCount++ < 16) continue;
            }
            entity.m_146884_(secondPos.m_252807_());
            entity.m_6710_((LivingEntity)playerList.get(rand.nextInt(playerList.size())));
            world.m_7967_((Entity)entity);
            this.addPotion((LivingEntity)entity, PotionInit.resistance_blow, 99999, 5);
            entity.m_6210_();
            ++this.summonCount;
            this.sendPKT();
        }
    }

    protected int getRand(Random rand, int range) {
        return rand.nextInt(range) - rand.nextInt(range);
    }

    public int getSummonInterval() {
        return switch (this.wave) {
            case 2 -> 168;
            case 3 -> 144;
            case 4 -> 210;
            default -> 192;
        };
    }

    public Monster setMob(Level world, Random rand, float addHealth) {
        ISMMob entity = null;
        switch (rand.nextInt(6)) {
            case 0: {
                entity = new BlazeTempest(world);
                break;
            }
            case 1: {
                entity = new EnderMage(world);
                entity.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
                break;
            }
            case 2: {
                entity = new SkullFrost(world);
                entity.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
                break;
            }
            case 3: {
                entity = new ArchSpider(world);
                break;
            }
            case 4: {
                entity = new SkullFlame(world);
                entity.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
                break;
            }
            case 5: {
                entity = new DwarfZombie(world);
                entity.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ItemInit.alt_pick));
            }
        }
        entity.m_21051_(Attributes.f_22276_).m_22100_((this.isHard ? 30.0 : 20.0) * (double)addHealth);
        entity.m_21153_(entity.m_21233_());
        this.addPotion((LivingEntity)entity, PotionInit.darkness_fog, 99999, 0);
        if (this.isHard) {
            this.addPotion((LivingEntity)entity, PotionInit.aether_barrier, 99999, 0);
        }
        return entity;
    }

    public Monster setBigMob(Level world, Random rand, float addHealth) {
        ISMMob entity = null;
        switch (rand.nextInt(5)) {
            case 0: {
                entity = new SkullFrostRoyalGuard(world);
                entity.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
                entity.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)Items.f_42469_));
                entity.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)Items.f_42471_));
                break;
            }
            case 1: {
                entity = new SkullFlameArcher(world);
                entity.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
                entity.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_42472_));
                entity.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)Items.f_42475_));
                break;
            }
            case 2: {
                entity = new BlazeTempestTornado(world);
                break;
            }
            case 3: {
                entity = new EnderShadow(world);
                entity.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42383_));
                this.addPotion((LivingEntity)entity, MobEffects.f_19597_, 99999, 1);
                break;
            }
            case 4: {
                entity = new DwarfZombieMaster(world);
                entity.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ItemInit.alt_sword));
                this.addPotion((LivingEntity)entity, MobEffects.f_19597_, 99999, 2);
            }
        }
        entity.m_21051_(Attributes.f_22276_).m_22100_((this.isHard ? 40.0 : 20.0) * (double)addHealth);
        entity.m_21153_(entity.m_21233_());
        this.addPotion((LivingEntity)entity, PotionInit.resistance_blow, 99999, 2);
        this.addPotion((LivingEntity)entity, PotionInit.darkness_fog, 99999, 0);
        this.addPotion((LivingEntity)entity, PotionInit.leader_flag, 99999, this.wave == 4 ? 1 : 0);
        if (this.isHard) {
            this.addPotion((LivingEntity)entity, PotionInit.aether_barrier, 99999, 3);
            this.addPotion((LivingEntity)entity, MobEffects.f_19600_, 99999, 2);
        } else {
            this.addPotion((LivingEntity)entity, MobEffects.f_19613_, 99999, 0);
        }
        return entity;
    }

    public abstract void summonBoss(Level var1, BlockPos var2, float var3);

    public void setNextWave(Level world, BlockPos pos) {
        if (this.wave >= 4) {
            this.removeAllPlayerBossBar();
            this.summonType = SummonType.END;
            this.oldCharge = 8;
            BlockPos upPos = pos.m_6630_(2);
            if (!world.m_8055_(upPos).m_60713_(BlockInit.treasure_chest)) {
                world.m_7731_(upPos, BlockInit.treasure_chest.m_49966_(), 3);
            }
            TileWoodChest tile = (TileWoodChest)this.getTile(upPos);
            List<Player> playerList = this.getPlayer(Player.class);
            int addDrop = this.isHard ? 2 : 1;
            int size = playerList.size() * addDrop;
            ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
            stackList.add(new ItemStack((ItemLike)ItemInit.magic_aether_force, (3 + this.rand.nextInt(5)) * size));
            stackList.add(new ItemStack((ItemLike)ItemInit.magic_divine_force, (1 + this.rand.nextInt(3)) * size));
            if (this.isHard) {
                stackList.add(new ItemStack((ItemLike)ItemInit.magic_pure_force, (1 + this.rand.nextInt(4)) * size / 2));
            }
            stackList.add(new ItemStack((ItemLike)ItemInit.divine_crystal, (4 + this.rand.nextInt(7)) * addDrop));
            stackList.add(new ItemStack((ItemLike)ItemInit.pure_crystal, (1 + this.rand.nextInt(3)) * addDrop));
            stackList.add(new ItemStack((ItemLike)ItemInit.magia_bottle, this.rand.nextInt(3) * addDrop));
            stackList.add(new ItemStack((ItemLike)ItemInit.witch_tears, (3 + this.rand.nextInt(4)) * addDrop));
            if (this.isHard) {
                stackList.add(new ItemStack((ItemLike)ItemInit.magia_bottle, (1 + this.rand.nextInt(2)) * addDrop));
                stackList.add(new ItemStack((ItemLike)ItemInit.cosmic_crystal_shard, 1 * addDrop));
                stackList.add(new ItemStack((ItemLike)ItemInit.wish_crystal, 1 * addDrop));
            }
            stackList.add(new ItemStack((ItemLike)BlockInit.sturdust_crystal, 1));
            stackList.forEach(s -> ItemHelper.insertStack(tile.getInput(), s.m_41777_(), false));
            this.playSound(this.getTilePos(), SoundEvents.f_12275_, 1.0f, 1.0f);
            return;
        }
        ++this.wave;
        this.summonCount = 0;
        this.dethMobCount = 0;
        this.chargeSummonSize = 0.0f;
        this.chageTime = 0;
        this.oldCharge = 8;
        if (this.wave <= 4) {
            List<Monster> mobList = this.getMobList();
            mobList.forEach(e -> e.m_146870_());
            this.summonType = WAIT;
            switch (this.wave) {
                case 2: {
                    this.waitTime = 0;
                    this.maxWaitTime = 20;
                    break;
                }
                case 3: {
                    this.waitTime = 0;
                    this.maxWaitTime = 20;
                    break;
                }
                case 4: {
                    this.waitTime = 0;
                    this.maxWaitTime = 50;
                    this.removeAllPlayerBossBar();
                }
            }
            this.setMobSize(world, pos);
            this.sendPKT();
        }
    }

    public void spawnParticle(Level world, BlockPos pos) {
        if (!(world instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)world;
        float addY = Math.min(2.0f, (float)this.tileTime * 0.0125f);
        for (int i = 0; i < 2; ++i) {
            float randX = this.getRand(this.rand, 4);
            float randY = this.getRand(this.rand, 4);
            float randZ = this.getRand(this.rand, 4);
            float x = (float)pos.m_123341_() + 0.5f + randX;
            float y = (float)pos.m_123342_() + 1.5f + randY + addY;
            float z = (float)pos.m_123343_() + 0.5f + randZ;
            float xSpeed = -randX * 0.115f;
            float ySpeed = -randY * 0.115f;
            float zSpeed = -randZ * 0.115f;
            server.m_8767_((ParticleOptions)ParticleInit.NORMAL, (double)x, (double)y, (double)z, 0, (double)xSpeed, (double)ySpeed, (double)zSpeed, 1.0);
        }
    }

    public void spawnDeathParticle(Level world, BlockPos pos, Monster entity) {
        if (!(world instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)world;
        float addY = Math.min(2.0f, (float)this.tileTime * 0.0125f);
        float entityX = (float)entity.m_20185_();
        float entityY = (float)entity.m_20186_();
        float entityZ = (float)entity.m_20189_();
        for (int i = 0; i < 5; ++i) {
            float randX = this.getRandFloat();
            float randY = this.getRandFloat();
            float randZ = this.getRandFloat();
            float x = entityX + 0.5f + randX;
            float y = entityY + 1.5f + randY + addY;
            float z = entityZ + 0.5f + randZ;
            float xSpeed = ((float)pos.m_123341_() - entityX - randX) * 0.115f;
            float ySpeed = ((float)pos.m_123342_() - entityY - randY) * 0.115f;
            float zSpeed = ((float)pos.m_123343_() - entityZ - randZ) * 0.115f;
            server.m_8767_((ParticleOptions)ParticleInit.BLOOD, (double)x, (double)y, (double)z, 0, (double)xSpeed, (double)ySpeed, (double)zSpeed, 1.0);
        }
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128379_("isButtle", this.isButtle);
        tag.m_128405_("summonType", this.summonType.getId());
        tag.m_128405_("tileTime", this.tileTime);
        tag.m_128405_("wave", this.wave);
        tag.m_128350_("chargeSummonSize", this.chargeSummonSize);
        tag.m_128405_("dethMobCount", this.dethMobCount);
        tag.m_128405_("summonCount", this.summonCount);
        tag.m_128405_("summonMaxSize", this.summonMaxCount);
        tag.m_128405_("waitTime", this.waitTime);
        tag.m_128405_("maxWaitTime", this.maxWaitTime);
        tag.m_128405_("chageTime", this.chageTime);
        tag.m_128379_("isHard", this.isHard);
        if (this.boss != null) {
            tag.m_128362_("bossId", this.boss.m_20148_());
        }
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.isButtle = tag.m_128471_("isButtle");
        this.summonType = SummonType.getType(tag.m_128451_("summonType"));
        this.tileTime = tag.m_128451_("tileTime");
        this.wave = tag.m_128451_("wave");
        this.chargeSummonSize = tag.m_128457_("chargeSummonSize");
        this.dethMobCount = tag.m_128451_("dethMobCount");
        this.summonCount = tag.m_128451_("summonCount");
        this.summonMaxCount = tag.m_128451_("summonMaxSize");
        this.waitTime = tag.m_128451_("waitTime");
        this.maxWaitTime = tag.m_128451_("maxWaitTime");
        this.chageTime = tag.m_128451_("chageTime");
        this.isHard = tag.m_128471_("isHard");
        if (tag.m_128403_("bossId")) {
            this.bossId = tag.m_128342_("bossId");
        }
    }

    @Override
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return null;
    }

    @Override
    public IItemHandler getInput() {
        return null;
    }

    public abstract ItemStack getStack();

    public abstract int getBattleLevel();

    @Override
    public boolean isInfoEmpty() {
        return true;
    }

    public static enum SummonType {
        START(0),
        CHARGE(1),
        SUMMON(2),
        WAIT(3),
        END(4);

        private final int id;

        private SummonType(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public static SummonType getType(int id) {
            return switch (id) {
                case 0 -> START;
                case 1 -> CHARGE;
                case 2 -> SUMMON;
                case 3 -> WAIT;
                case 4 -> END;
                default -> CHARGE;
            };
        }

        public boolean is(SummonType type) {
            return this.equals((Object)type);
        }
    }
}

