/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.sm;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.registries.ForgeRegistries;
import sweetmagic.init.TileInit;
import sweetmagic.init.block.magic.AetherHopper;
import sweetmagic.init.tile.menu.AetherHopperMenu;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileSMMagic;
import sweetmagic.util.ItemHelper;

public class TileAetherHopper
extends TileSMMagic {
    public int maxMagiaFlux = 20000;
    public boolean isChest = false;
    public Block targetBlock = null;
    public final TileAbstractSM.StackHandler inputInv = new TileAbstractSM.StackHandler(this.getInvSize());
    protected final TileAbstractSM.StackHandler wandInv = (TileAbstractSM)this.new TileAbstractSM.StackHandler(this.getInvSize(), 1);

    public TileAetherHopper(BlockPos pos, BlockState state) {
        this(TileInit.aetherHopper, pos, state);
    }

    public TileAetherHopper(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.resolver = (TileAbstractSM)this.new TileAbstractSM.SingleHandlerProvider((IItemHandlerModifiable)this.inputInv, IN_OUT);
    }

    @Override
    public void serverTick(Level world, BlockPos pos, BlockState state) {
        super.serverTick(world, pos, state);
        if (this.tickTime % this.getExecuteTime() != 0 || this.isRSPower()) {
            return;
        }
        this.tickTime = 0;
        this.suctionItem(pos);
        this.extractItem(pos);
        if (!this.isMFEmpty()) {
            this.setHopperItem(world, pos);
        }
    }

    public void extractItem(BlockPos pos) {
        BlockEntity tile = this.getTile(pos.m_121945_(this.getFace()));
        if (tile == null) {
            return;
        }
        IItemHandler handler = this.getItemHandler(tile, this.getFaceReverse());
        if (handler == null) {
            return;
        }
        block0: for (int h = 0; h < this.getInvSize(); ++h) {
            ItemStack input = this.getInputItem(h);
            if (input.m_41619_()) continue;
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack inStack = handler.insertItem(i, input.m_41777_(), false);
                input.m_41764_(inStack.m_41613_());
                if (inStack.m_41619_()) continue block0;
            }
        }
    }

    public void suctionItem(BlockPos pos) {
        Direction face = this.getFace() == Direction.UP ? Direction.DOWN : Direction.UP;
        BlockEntity tile = this.getTile(pos.m_121945_(face));
        if (tile == null) {
            return;
        }
        IItemHandler handler = this.getItemHandler(tile, this.getFace() == Direction.UP ? Direction.UP : Direction.DOWN);
        if (handler == null) {
            return;
        }
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack output = handler.getStackInSlot(i);
            if (output.m_41619_() || !this.checkFilter(output)) continue;
            ItemStack stack = ItemHelper.insertStack(this.getInput(), output.m_41777_(), false);
            output.m_41764_(stack.m_41613_());
        }
    }

    public void setHopperItem(Level world, BlockPos pos) {
        IItemHandler handler;
        ItemStack stack = this.getWandItem();
        if (stack.m_41619_()) {
            return;
        }
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_("X")) {
            return;
        }
        int x = tag.m_128451_("X");
        int y = tag.m_128451_("Y");
        int z = tag.m_128451_("Z");
        if (tag.m_128441_("dim")) {
            ResourceLocation dimId = new ResourceLocation(tag.m_128461_("dim"));
            world = world.m_7654_().m_129880_(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)dimId));
        }
        if ((handler = this.getItemHandler(world, new BlockPos(x, y, z))) == null) {
            return;
        }
        int sumMF = 0;
        int mf = this.getMF();
        block0: for (int h = 0; h < this.getInvSize(); ++h) {
            ItemStack input = this.getInputItem(h);
            if (input.m_41619_()) continue;
            if (mf - sumMF < input.m_41613_()) {
                return;
            }
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack inStack = handler.insertItem(i, input.m_41777_(), false);
                input.m_41764_(inStack.m_41613_());
                if (!inStack.m_41619_()) continue;
                sumMF += input.m_41613_();
                continue block0;
            }
        }
        if (sumMF > 0) {
            this.setMF(mf - sumMF);
            this.sendPKT();
        }
    }

    public IItemHandler getItemHandler(Level world, BlockPos pos) {
        BlockEntity tile = world.m_7702_(pos);
        return tile == null ? null : this.getItemHandler(tile, Direction.UP);
    }

    public int getExecuteTime() {
        return 40;
    }

    @Override
    public int getInvSize() {
        return 24;
    }

    @Override
    public int getMaxMF() {
        return this.maxMagiaFlux;
    }

    @Override
    public IItemHandler getInput() {
        return this.inputInv;
    }

    public ItemStack getInputItem(int i) {
        return this.getInput().getStackInSlot(i);
    }

    public IItemHandler getWand() {
        return this.wandInv;
    }

    public ItemStack getWandItem() {
        return this.getWand().getStackInSlot(0);
    }

    public void checkChest() {
        BlockPos pos;
        Level world = this.m_58904_();
        if (world.m_5776_()) {
            return;
        }
        ItemStack stack = this.getWandItem();
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_("X")) {
            return;
        }
        int x = tag.m_128451_("X");
        int y = tag.m_128451_("Y");
        int z = tag.m_128451_("Z");
        if (tag.m_128441_("dim")) {
            ResourceLocation dimId = new ResourceLocation(tag.m_128461_("dim"));
            world = world.m_7654_().m_129880_(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)dimId));
        }
        this.isChest = this.getItemHandler(world, pos = new BlockPos(x, y, z)) != null;
        this.targetBlock = world.m_8055_(pos).m_60734_();
        this.sendPKT();
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("inputInv", (Tag)this.inputInv.serializeNBT());
        tag.m_128365_("wandInv", (Tag)this.wandInv.serializeNBT());
        tag.m_128379_("isChest", this.isChest);
        if (this.targetBlock != null) {
            tag.m_128359_("blockId", ForgeRegistries.BLOCKS.getKey((Object)this.targetBlock).toString());
        }
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inputInv.deserializeNBT(tag.m_128469_("inputInv"));
        this.wandInv.deserializeNBT(tag.m_128469_("wandInv"));
        this.isChest = tag.m_128471_("isChest");
        if (tag.m_128441_("blockId")) {
            this.targetBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(tag.m_128461_("blockId")));
        }
    }

    @Override
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new AetherHopperMenu(windowId, inv, this);
    }

    @Override
    public Direction getFace() {
        return (Direction)this.getState(this.m_58899_()).m_61143_((Property)AetherHopper.FACING);
    }

    public Direction getFaceReverse() {
        return switch ((Direction)this.getState(this.m_58899_()).m_61143_((Property)AetherHopper.FACING)) {
            case Direction.NORTH -> Direction.SOUTH;
            case Direction.SOUTH -> Direction.NORTH;
            case Direction.WEST -> Direction.EAST;
            case Direction.EAST -> Direction.WEST;
            case Direction.UP -> Direction.UP;
            case Direction.DOWN -> Direction.UP;
            default -> Direction.NORTH;
        };
    }

    @Override
    public boolean isRSStop() {
        return true;
    }

    @Override
    public boolean isItemFilter() {
        return true;
    }

    public List<ItemStack> getInputList() {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        for (int i = 0; i < this.getInvSize(); ++i) {
            stackList.add(this.getInputItem(i));
        }
        return stackList;
    }

    public List<ItemStack> getInvList() {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        for (int i = 0; i < this.getInvSize(); ++i) {
            this.addStackList(stackList, this.getInputItem(i));
        }
        this.addStackList(stackList, this.getWandItem());
        return stackList;
    }

    @Override
    public boolean isInfoEmpty() {
        return this.getInvList().isEmpty() && this.isMFEmpty();
    }
}

