/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.sm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import sweetmagic.init.SoundInit;
import sweetmagic.init.TileInit;
import sweetmagic.init.tile.menu.AetherRecyclerMenu;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileSMMagic;
import sweetmagic.recipe.recycler.RecyclerRecipe;
import sweetmagic.util.ItemHelper;

public class TileAetherRecycler
extends TileSMMagic {
    public int maxMagiaFlux = 20000;
    public boolean isCraft = false;
    private static final int MAX_CRAFT_TIME = 10;
    public int craftTime = 0;
    public int amount = 0;
    public List<Float> chanceList = new ArrayList<Float>();
    public List<ItemStack> inputStackList = new ArrayList<ItemStack>();
    public List<List<ItemStack>> outStackListList = new ArrayList<List<ItemStack>>();
    public List<ItemStack> outStackOverList = new ArrayList<ItemStack>();
    protected final TileAbstractSM.StackHandler handInv = new TileAbstractSM.StackHandler(24);
    protected final TileAbstractSM.StackHandler inputInv = new TileAbstractSM.StackHandler(1);
    protected final TileAbstractSM.StackHandler outputInv = new TileAbstractSM.StackHandler(this.getInvSize());

    public TileAetherRecycler(BlockPos pos, BlockState state) {
        this(TileInit.aetherRecycler, pos, state);
    }

    public TileAetherRecycler(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.resolver = (TileAbstractSM)this.new TileAbstractSM.InOutHandlerProvider((IItemHandlerModifiable)this.handInv, (IItemHandlerModifiable)this.outputInv);
    }

    @Override
    public void serverTick(Level world, BlockPos pos, BlockState state) {
        super.serverTick(world, pos, state);
        if (this.tickTime % 10 != 0 || this.isRSPower()) {
            return;
        }
        if (!this.outStackOverList.isEmpty()) {
            this.craftOverInsert();
        } else if (!this.isCraft) {
            this.craftStart();
        } else {
            if (this.tickTime % 20 == 0 && this.craftTime <= 8) {
                this.playSound(this.m_58899_(), SoundInit.RECYCLER_ON, 0.375f, 1.0f);
            }
            if (this.craftTime++ >= 10) {
                this.craftFinish();
            }
            this.sendPKT();
        }
    }

    @Override
    public void clientTick(Level world, BlockPos pos, BlockState state) {
        super.clientTick(world, pos, state);
        if (!this.isCraft || this.inputStackList.isEmpty() || this.isRSPower()) {
            return;
        }
        if (this.craftTime <= 8) {
            ItemParticleOption par = new ItemParticleOption(ParticleTypes.f_123752_, this.inputStackList.get(0));
            this.spawnParticleRing(world, (ParticleOptions)par, 1.01, pos, -0.5, 0.0, 0.01f);
        } else if (this.tickTime % 20 == 10) {
            this.spawnParticleRing(world, (ParticleOptions)ParticleTypes.f_123796_, 0.75, pos, -0.5, 0.0, 0.33f);
        }
    }

    public void craftStart() {
        if (this.tickTime % 20 == 0) {
            this.insertInput();
            return;
        }
        ItemStack input = this.getInputItem();
        if (input.m_41619_()) {
            return;
        }
        if (!this.checkRecipe()) {
            ItemHelper.insertStack(this.getOutput(), input.m_41777_(), false);
            input.m_41774_(input.m_41613_());
            return;
        }
        List<ItemStack> stackList = this.getStackList();
        RecyclerRecipe recipe = RecyclerRecipe.getRecipe(this.m_58904_(), stackList).get();
        List<ItemStack> requestList = recipe.getRequestList();
        ItemStack hasndStack = stackList.get(0);
        int amount = hasndStack.m_41613_() / requestList.get(0).m_41613_();
        if ((amount = Math.min(amount, this.getMF() / (Math.max(1, (amount - 1) / 16 + 1) * this.getUseMF()))) <= 0) {
            return;
        }
        this.inputStackList = new ArrayList<ItemStack>(requestList);
        List<ItemStack> resultList = recipe.getResultList();
        resultList = new ArrayList<ItemStack>(resultList);
        for (ItemStack request : recipe.getRequestList()) {
            if (!request.m_150930_(hasndStack.m_41720_())) continue;
            hasndStack.m_41774_(request.m_41613_() * amount);
            break;
        }
        this.amount = amount;
        this.isCraft = true;
        this.chanceList = new ArrayList<Float>(recipe.getChanceList());
        this.tickTime = 0;
        this.setMF(this.getMF() - Math.max(1, (amount - 1) / 16 + 1) * this.getUseMF());
        List<Ingredient> ingList = recipe.getResultIngList();
        this.outStackListList = new ArrayList<List<ItemStack>>();
        for (Ingredient ing : ingList) {
            ItemStack[] stackArray = ing.m_43908_();
            ArrayList<ItemStack> outStackList = new ArrayList<ItemStack>();
            for (int i = 0; i < amount; ++i) {
                outStackList.add(stackArray[stackArray.length > 1 ? this.rand.nextInt(stackArray.length) : 0]);
            }
            this.outStackListList.add(outStackList);
        }
        this.playSound(this.m_58899_(), SoundInit.RECYCLER_ON, 0.375f, 1.0f);
        this.sendPKT();
    }

    public void craftFinish() {
        for (int i = 0; i < this.outStackListList.size(); ++i) {
            float chance = this.chanceList.isEmpty() ? 0.0f : this.chanceList.get(i).floatValue();
            List<ItemStack> ouStackList = this.outStackListList.get(i);
            for (int k = 0; k < this.amount; ++k) {
                ItemStack stack;
                if (chance < this.rand.nextFloat() || (stack = ItemHelper.insertStack(this.getOutput(), ouStackList.get(k).m_41777_(), false)).m_41619_()) continue;
                this.outStackOverList.add(stack);
            }
        }
        this.clearInfo();
        this.playSound(this.m_58899_(), SoundInit.RECYCLER_FIN, 0.15f, 1.0f);
        this.sendPKT();
    }

    public void craftOverInsert() {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        for (ItemStack stack : this.outStackOverList) {
            ItemStack result = ItemHelper.insertStack(this.getOutput(), stack.m_41777_(), false);
            if (result.m_41619_()) continue;
            stackList.add(result);
        }
        this.outStackOverList.clear();
        if (!stackList.isEmpty()) {
            this.outStackOverList = stackList;
        }
    }

    public void insertInput() {
        for (int i = 0; i < 24; ++i) {
            ItemStack stack = this.getHandItem(i);
            if (stack.m_41619_()) continue;
            ItemStack out = ItemHelper.insertStack(this.getInput(), stack.m_41777_(), false);
            stack.m_41774_(stack.m_41613_() - out.m_41613_());
        }
    }

    public void clearInfo() {
        this.amount = 0;
        this.craftTime = 0;
        this.isCraft = false;
        this.chanceList.clear();
        this.inputStackList.clear();
        this.outStackListList.clear();
        this.sendPKT();
    }

    public boolean checkRecipe() {
        return !RecyclerRecipe.getRecipe(this.m_58904_(), this.getStackList()).isEmpty();
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("handInv", (Tag)this.handInv.serializeNBT());
        tag.m_128365_("inputInv", (Tag)this.inputInv.serializeNBT());
        tag.m_128365_("outputInv", (Tag)this.outputInv.serializeNBT());
        tag.m_128379_("isCraft", this.isCraft);
        tag.m_128405_("tickTime", this.tickTime);
        tag.m_128405_("craftTime", this.craftTime);
        tag.m_128405_("amount", this.amount);
        this.saveFloatList(tag, this.chanceList, "chanceList");
        this.saveStackList(tag, this.inputStackList, "inputStackList");
        this.saveStackListList(tag, this.outStackListList, "outStackList");
        this.saveStackList(tag, this.outStackOverList, "outStackOverList");
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.handInv.deserializeNBT(tag.m_128469_("handInv"));
        this.inputInv.deserializeNBT(tag.m_128469_("inputInv"));
        this.outputInv.deserializeNBT(tag.m_128469_("outputInv"));
        this.isCraft = tag.m_128471_("isCraft");
        this.tickTime = tag.m_128451_("tickTime");
        this.craftTime = tag.m_128451_("craftTime");
        this.amount = tag.m_128451_("amount");
        this.chanceList = this.loadAllFloat(tag, "chanceList");
        this.inputStackList = this.loadAllStack(tag, "inputStackList");
        this.outStackListList = this.loadAllStackList(tag, "outStackList");
        this.outStackOverList = this.loadAllStack(tag, "outStackOverList");
    }

    public int getCraftProgress(int value) {
        return this.getProgress(value, this.craftTime, 10);
    }

    @Override
    public int getReceiveMF() {
        return 10000;
    }

    @Override
    public int getMaxMF() {
        return this.maxMagiaFlux;
    }

    public int getUseMF() {
        return 50;
    }

    @Override
    public int getInvSize() {
        return 27;
    }

    public List<ItemStack> getStackList() {
        return Arrays.asList(this.getInputItem());
    }

    public IItemHandler getHand() {
        return this.handInv;
    }

    public ItemStack getHandItem(int i) {
        return this.getHand().getStackInSlot(i);
    }

    @Override
    public IItemHandler getInput() {
        return this.inputInv;
    }

    public ItemStack getInputItem() {
        return this.getInput().getStackInSlot(0);
    }

    public IItemHandler getOutput() {
        return this.outputInv;
    }

    public ItemStack getOutputItem(int i) {
        return this.getOutput().getStackInSlot(i);
    }

    @Override
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new AetherRecyclerMenu(windowId, inv, this);
    }

    @Override
    public boolean isRSStop() {
        return true;
    }

    public List<ItemStack> getInvList() {
        int i;
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        for (i = 0; i < 10; ++i) {
            this.addStackList(stackList, this.getHandItem(i));
        }
        this.addStackList(stackList, this.getInputItem());
        for (i = 0; i < this.getInvSize(); ++i) {
            this.addStackList(stackList, this.getOutputItem(i));
        }
        return stackList;
    }

    @Override
    public boolean isInfoEmpty() {
        return this.getInvList().isEmpty() && this.isMFEmpty();
    }
}

