/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.sm;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import sweetmagic.init.ParticleInit;
import sweetmagic.init.TileInit;
import sweetmagic.init.tile.menu.AetherRepairMenu;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileSMMagic;

public class TileAetherRepair
extends TileSMMagic {
    public int maxMagiaFlux = 100000;
    private static final float[] xPosArray = new float[]{0.0f, 0.125f, 0.0f, -0.125f};
    private static final float[] zPosArray = new float[]{-0.125f, 0.0f, 0.125f, 0.0f};
    protected final TileAbstractSM.StackHandler inputInv = (TileAbstractSM)this.new TileAbstractSM.StackHandler(this.getInvSize(), true);

    public TileAetherRepair(BlockPos pos, BlockState state) {
        super(TileInit.aetherRepair, pos, state);
    }

    public TileAetherRepair(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void serverTick(Level world, BlockPos pos, BlockState state) {
        super.serverTick(world, pos, state);
        if (this.tickTime % 20 != 0 || this.isMFEmpty()) {
            return;
        }
        this.repairTool();
    }

    @Override
    public void clientTick(Level world, BlockPos pos, BlockState state) {
        super.clientTick(world, pos, state);
        if (this.tickTime % 20 != 0 || this.isMFEmpty()) {
            return;
        }
        for (int i = 0; i < this.getInvSize(); ++i) {
            ItemStack stack = this.getInputItem(i);
            if (stack.m_41619_() || stack.m_41773_() <= 0) continue;
            this.spawnParticl(pos, xPosArray[i], zPosArray[i]);
        }
    }

    public void repairTool() {
        for (int i = 0; i < this.getInvSize(); ++i) {
            ItemStack stack = this.getInputItem(i);
            if (stack.m_41619_() || stack.m_41773_() <= 0) continue;
            int damage = stack.m_41773_();
            int maxDamage = stack.m_41776_();
            int useMF = Math.max(1, Math.min(1000, (int)((float)(maxDamage * maxDamage) * 1.0E-4f)));
            int healValue = Math.min(10, damage);
            if (this.getMF() < (useMF *= healValue)) continue;
            stack.m_41721_(damage - healValue);
            this.setMF(this.getMF() - useMF);
            this.sendPKT();
        }
    }

    public void spawnParticl(BlockPos pos, float pX, float pZ) {
        for (int i = 0; i < 2; ++i) {
            float randX = this.getRandFloat(0.1f);
            float randY = this.getRandFloat(0.1f);
            float randZ = this.getRandFloat(0.1f);
            float x = (float)pos.m_123341_() + 0.5f + randX;
            float y = (float)pos.m_123342_() + 0.525f + randY;
            float z = (float)pos.m_123343_() + 0.5f + randZ;
            float xSpeed = pX * 0.25f;
            float ySpeed = 0.040000003f;
            float zSpeed = pZ * 0.25f;
            this.addParticle((ParticleOptions)ParticleInit.NORMAL, x, y, z, xSpeed, ySpeed, zSpeed);
        }
    }

    @Override
    public int getInvSize() {
        return 4;
    }

    @Override
    public int getMaxMF() {
        return this.maxMagiaFlux;
    }

    @Override
    public IItemHandler getInput() {
        return this.inputInv;
    }

    public ItemStack getInputItem(int i) {
        return this.getInput().getStackInSlot(i);
    }

    @Override
    public int getShrinkMF() {
        return 10000;
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("inputInv", (Tag)this.inputInv.serializeNBT());
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inputInv.deserializeNBT(tag.m_128469_("inputInv"));
    }

    @Override
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new AetherRepairMenu(windowId, inv, this);
    }

    public List<ItemStack> getInvList() {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        for (int i = 0; i < this.getInvSize(); ++i) {
            this.addStackList(stackList, this.getInputItem(i));
        }
        return stackList;
    }

    @Override
    public boolean isInfoEmpty() {
        return this.getInvList().isEmpty() && this.isMFEmpty();
    }
}

