/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.sm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import sweetmagic.init.ParticleInit;
import sweetmagic.init.TagInit;
import sweetmagic.init.TileInit;
import sweetmagic.init.tile.menu.AetherReverseMenu;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileSMMagic;
import sweetmagic.util.ItemHelper;

public class TileAetherReverse
extends TileSMMagic {
    public int craftTime = 0;
    public int shrinkValue = 0;
    private int maxCraftTime = 9;
    public int maxMagiaFlux = 100000;
    public boolean isCraft = false;
    public boolean canCraft = false;
    public ItemStack stack = ItemStack.f_41583_;
    public List<ItemStack> craftList = new ArrayList<ItemStack>();
    protected final TileAbstractSM.StackHandler inputInv = (TileAbstractSM)this.new TileAbstractSM.StackHandler(1, true);
    protected final TileAbstractSM.StackHandler outputInv = (TileAbstractSM)this.new TileAbstractSM.StackHandler(9, true);
    protected final TileAbstractSM.StackHandler chestInv = new TileAbstractSM.StackHandler(27);

    public TileAetherReverse(BlockPos pos, BlockState state) {
        this(TileInit.aetherReverse, pos, state);
    }

    public TileAetherReverse(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.resolver = (TileAbstractSM)this.new TileAbstractSM.InOutHandlerProvider((IItemHandlerModifiable)this.inputInv, (IItemHandlerModifiable)this.chestInv);
    }

    @Override
    public void serverTick(Level world, BlockPos pos, BlockState state) {
        super.serverTick(this.f_58857_, pos, state);
        if (this.tickTime % 10 != 0) {
            return;
        }
        if (this.isCraft) {
            if (this.craftTime++ >= this.maxCraftTime) {
                this.craftFinish();
            }
        } else {
            List<ItemStack> stackList = this.getReverseStack(world);
            if (stackList.isEmpty()) {
                this.craftList.clear();
                this.canCraft = false;
            } else {
                this.craftList = new ArrayList<ItemStack>(stackList);
                this.canCraft = true;
                if (this.isRSPower()) {
                    this.craftStart();
                }
            }
        }
        this.sendPKT();
    }

    @Override
    public void clientTick(Level world, BlockPos pos, BlockState state) {
        super.clientTick(world, pos, state);
        if (this.clientTime % 30 != 0 || this.getInputItem().m_41619_()) {
            return;
        }
        SimpleParticleType par = ParticleInit.CYCLE_ORB;
        for (int i = 0; i < 8; ++i) {
            this.spawnParticleCycle(world, (ParticleOptions)par, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.35, (double)pos.m_123343_() + 0.5, Direction.UP, 0.25, i * 45, false);
            this.spawnParticleCycle(world, (ParticleOptions)par, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.1, (double)pos.m_123343_() + 0.5, Direction.UP, 0.4, i * 45, true);
        }
    }

    public void craftStart() {
        int needMF = this.getReverseCost();
        if (needMF > this.getMF()) {
            return;
        }
        for (ItemStack stack : this.craftList) {
            ItemStack input = ItemHelper.insertStack(this.getChest(), stack, true);
            if (input.m_41619_()) continue;
            return;
        }
        this.stack = this.getInputItem().m_41777_();
        this.maxCraftTime = this.craftList.size();
        this.isCraft = true;
        this.canCraft = false;
        this.getInputItem().m_41774_(this.shrinkValue);
        this.setMF(this.getMF() - needMF);
        this.sendPKT();
        this.clickButton();
    }

    public void craftFinish() {
        this.craftList.forEach(s -> ItemHelper.insertStack(this.getChest(), s.m_41777_(), false));
        this.playSound(this.m_58899_(), SoundEvents.f_11671_, 0.1f, 1.125f);
        this.clearInfo();
    }

    public void clearInfo() {
        this.craftTime = 0;
        this.maxCraftTime = 9;
        this.shrinkValue = 0;
        this.isCraft = false;
        this.craftList.clear();
        this.stack = ItemStack.f_41583_;
        this.sendPKT();
    }

    public List<ItemStack> getReverseStack(Level world) {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        ItemStack stack = this.getInputItem();
        if (stack.m_41619_()) {
            return stackList;
        }
        Recipe recipe = null;
        RegistryAccess access = world.m_9598_();
        List<Recipe> allRecipeList = world.m_7465_().m_44051_().stream().filter(r -> this.checkRecipe((Recipe<?>)r)).toList();
        for (Recipe allRecipe : allRecipeList) {
            ItemStack result = allRecipe.m_8043_(access);
            if (!result.m_150930_(stack.m_41720_()) || stack.m_41613_() < result.m_41613_()) continue;
            recipe = allRecipe;
            this.shrinkValue = result.m_41613_();
            break;
        }
        if (recipe == null) {
            return stackList;
        }
        List<ItemStack> ingredList = this.getIngredientList(recipe);
        if (recipe instanceof IShapedRecipe) {
            IShapedRecipe rec = (IShapedRecipe)recipe;
            int recipeWidth = rec.getRecipeWidth();
            int recipeHeight = rec.getRecipeHeight();
            for (int invY = 0; invY < recipeHeight; ++invY) {
                for (int invX = 0; invX < recipeWidth; ++invX) {
                    ItemStack ingred;
                    int index = invX + invY * recipeWidth;
                    if (index >= ingredList.size() || (ingred = ingredList.get(index).m_41777_()).m_204117_(TagInit.RECIPE_BOOK) || ingred.m_41611_().toString().contains("bucket")) continue;
                    stackList.add(this.getSingleStack(ingred));
                }
            }
        } else {
            for (int i = 0; i < 9; ++i) {
                ItemStack ingred;
                if (i >= ingredList.size() || (ingred = ingredList.get(i).m_41777_()).m_41619_() || ingred.m_204117_(TagInit.RECIPE_BOOK) || ingred.m_41611_().toString().contains("bucket")) continue;
                stackList.add(this.getSingleStack(ingred));
            }
        }
        return stackList;
    }

    public boolean checkRecipe(Recipe<?> recipe) {
        return (recipe instanceof CraftingRecipe || recipe instanceof ShapedRecipe) && !recipe.m_142505_() && recipe.m_8004_(3, 3) && !recipe.m_7527_().isEmpty();
    }

    private List<ItemStack> getIngredientList(Recipe<?> recipe) {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        for (int i = 0; i < recipe.m_7527_().size(); ++i) {
            List<ItemStack> recipeStackList = Arrays.stream(((Ingredient)recipe.m_7527_().get(i)).m_43908_()).toList();
            stackList.add(recipeStackList.size() > 0 ? recipeStackList.get(Math.floorMod(0, recipeStackList.size())) : ItemStack.f_41583_);
        }
        return stackList;
    }

    private ItemStack getSingleStack(ItemStack stack) {
        if (stack.m_41613_() > 1) {
            stack.m_41764_(1);
        }
        return stack;
    }

    public int getReverseCost() {
        int mf = 500;
        float rate = 1.0f;
        ItemStack stack = this.getInputItem();
        if (stack.m_41776_() > 0) {
            rate += (float)stack.m_41776_() * 0.01f;
        }
        return (int)((float)this.craftList.size() * rate * (float)mf);
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("inputInv", (Tag)this.inputInv.serializeNBT());
        tag.m_128365_("outputInv", (Tag)this.outputInv.serializeNBT());
        tag.m_128365_("chestInv", (Tag)this.chestInv.serializeNBT());
        tag.m_128379_("isCraft", this.isCraft);
        tag.m_128379_("canCraft", this.canCraft);
        tag.m_128405_("craftTime", this.craftTime);
        tag.m_128405_("maxCraftTime", this.maxCraftTime);
        tag.m_128405_("shrinkValue", this.shrinkValue);
        tag.m_128365_("stack", (Tag)this.stack.m_41739_(new CompoundTag()));
        this.saveStackList(tag, this.craftList, "craftList");
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inputInv.deserializeNBT(tag.m_128469_("inputInv"));
        this.outputInv.deserializeNBT(tag.m_128469_("outputInv"));
        this.chestInv.deserializeNBT(tag.m_128469_("chestInv"));
        this.isCraft = tag.m_128471_("isCraft");
        this.canCraft = tag.m_128471_("canCraft");
        this.craftTime = tag.m_128451_("craftTime");
        this.maxCraftTime = tag.m_128451_("maxCraftTime");
        this.shrinkValue = tag.m_128451_("shrinkValue");
        this.stack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("stack"));
        this.craftList = this.loadAllStack(tag, "craftList");
    }

    @Override
    public int getReceiveMF() {
        return 10000;
    }

    @Override
    public int getMaxMF() {
        return this.maxMagiaFlux;
    }

    @Override
    public IItemHandler getInput() {
        return this.inputInv;
    }

    public ItemStack getInputItem() {
        return this.getInput().getStackInSlot(0);
    }

    public IItemHandler getOut() {
        return this.outputInv;
    }

    public ItemStack getOutItem(int i) {
        return this.getOut().getStackInSlot(i);
    }

    public IItemHandler getChest() {
        return this.chestInv;
    }

    public ItemStack getChestItem(int i) {
        return this.getChest().getStackInSlot(i);
    }

    public int getCraftProgress(int value) {
        return this.getProgress(value, this.craftTime, this.maxCraftTime);
    }

    @Override
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new AetherReverseMenu(windowId, inv, this);
    }

    public List<ItemStack> getInvList() {
        int i;
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        this.addStackList(stackList, this.getInputItem());
        for (i = 0; i < 9; ++i) {
            this.addStackList(stackList, this.getOutItem(i));
        }
        for (i = 0; i < 27; ++i) {
            this.addStackList(stackList, this.getChestItem(i));
        }
        return stackList;
    }

    @Override
    public boolean isInfoEmpty() {
        return this.getInvList().isEmpty() && this.isMFEmpty();
    }
}

