/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.sm;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import sweetmagic.init.BlockInit;
import sweetmagic.init.TagInit;
import sweetmagic.init.TileInit;
import sweetmagic.init.tile.sm.TilePedalCreate;
import sweetmagic.util.WorldHelper;

public class TileAltarCreat
extends TilePedalCreate {
    public int maxMagiaFlux = 200000;
    public boolean isRangeBlock = false;

    public TileAltarCreat(BlockPos pos, BlockState state) {
        super(TileInit.altarCreat, pos, state);
    }

    public TileAltarCreat(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void clientTick(Level world, BlockPos pos, BlockState state) {
        super.clientTick(world, pos, state);
        if (this.tickTime % 20 != 0) {
            return;
        }
        this.isHaveBlock = this.getState(pos.m_7495_()).m_204336_(TagInit.DC_BLOCK);
        this.isRangeBlock = this.checkRangeBlock(false);
        if (!this.isCraft || this.nowTick > (this.maxCrafttime - 1) * 20) {
            return;
        }
        float addY = (float)this.nowTick * 0.00575f * (this.quickCraft ? 2.0f : 1.0f);
        this.spawnParticleRing(world, (float)pos.m_123341_() + 0.5f, (float)pos.m_123342_() + 1.4f + addY, (float)pos.m_123343_() + 0.5f, 0.0, 0.0, 0.0, 0.75);
    }

    @Override
    public MutableComponent checkCanCraft(List<ItemStack> stackList) {
        if (!this.checkRangeBlock(false)) {
            return this.getTipArray(new Object[]{this.getText("pedastal_norangeblock"), ":", this.getRangeBlock().m_49954_().m_130940_(RED)});
        }
        return super.checkCanCraft(stackList);
    }

    public boolean checkRangeBlock(boolean isClient) {
        BlockPos pos = this.m_58899_().m_7495_();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                if (x == 0 && z == 0 || this.getState(WorldHelper.offset(pos, x, 0.0, z)).m_204336_(TagInit.AC_BLOCK)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Block getNeedBlock() {
        return BlockInit.divinecrystal_block;
    }

    public Block getRangeBlock() {
        return BlockInit.aethercrystal_block;
    }

    @Override
    public int getMaxMF() {
        return this.maxMagiaFlux;
    }

    @Override
    public int getReceiveMF() {
        return 40000;
    }
}

