/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.sm;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import sweetmagic.api.iblock.ITileFluid;
import sweetmagic.init.TileInit;
import sweetmagic.init.fluid.FluidTankHandler;
import sweetmagic.init.item.sm.SMBucket;
import sweetmagic.init.tile.menu.AlternativeTankMenu;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.util.ItemHelper;

public class TileAlternativeTank
extends TileAbstractSM
implements ITileFluid {
    private static final int MAX_FLUID_VALUE = 256000;
    public FluidStack fluid = new FluidStack(Fluids.f_76191_, 0);
    protected final FluidTankHandler.TankProperty fluidPro;
    public LazyOptional<IFluidHandler> fluidHandler = LazyOptional.of(() -> this.createFluidHandler());
    protected final TileAbstractSM.StackHandler inputInv = new TileAbstractSM.StackHandler(this.getInvSize());

    public TileAlternativeTank(BlockPos pos, BlockState state) {
        this(TileInit.alternativeTank, pos, state);
    }

    public TileAlternativeTank(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.resolver = (TileAbstractSM)this.new TileAbstractSM.SingleHandlerProvider((IItemHandlerModifiable)this.inputInv, IN_OUT);
        this.fluidPro = new FluidTankHandler.TankProperty(256000, true, true);
    }

    @Override
    public void serverTick(Level level, BlockPos pos, BlockState state) {
        super.serverTick(level, pos, state);
        if (this.tickTime % 10 != 0 || this.isRSPower()) {
            return;
        }
        if (!this.isMaxFluid()) {
            this.drainBucket();
        }
    }

    public void drainBucket() {
        Item item;
        ItemStack stack = this.getInputItem().m_41777_();
        if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof SMBucket)) {
            return;
        }
        SMBucket bucket = (SMBucket)item;
        FluidStack fStack = bucket.getFluidStack(stack);
        if (fStack.isEmpty()) {
            return;
        }
        Fluid fluid = fStack.getFluid();
        FluidStack tileStack = this.getContent();
        Fluid tileFluid = tileStack.getFluid();
        if (!(fluid.m_6212_(Fluids.f_76191_) || tileFluid.m_6212_(Fluids.f_76191_) || fluid.m_6212_(tileStack.getFluid()))) {
            return;
        }
        int value = Math.min(1000, fStack.getAmount());
        if (tileFluid.m_6212_(Fluids.f_76191_)) {
            this.setContent(new FluidStack(fluid, value));
        } else {
            tileStack.grow(value);
        }
        stack = bucket.shrinkWater(stack, value);
        this.getInputItem().m_41774_(1);
        ItemHelper.insertStack(this.getInput(), stack, false);
        this.sendPKT();
    }

    @Override
    public int fluidTanks() {
        return 1;
    }

    @Override
    public IFluidHandler createFluidHandler() {
        return new FluidTankHandler(this);
    }

    @Override
    public void setContent(FluidStack fluid) {
        this.fluid = fluid;
        this.m_6596_();
    }

    @Override
    public FluidTankHandler.TankProperty getTank() {
        return this.fluidPro;
    }

    @Override
    public FluidStack getContent() {
        return this.fluid;
    }

    @Override
    public void setAmount(int amount) {
        this.fluid.setAmount(amount);
    }

    @Override
    public int getFluidValue() {
        return this.getContent().getAmount();
    }

    @Override
    public void sendData() {
        this.sendInfo();
    }

    public LazyOptional<IFluidHandler> getFluidHandler() {
        return this.fluidHandler;
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction face) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.getFluidHandler();
        }
        return super.getCapability(cap, face);
    }

    public void m_7651_() {
        super.m_7651_();
        if (this.getFluidHandler() != null) {
            this.getFluidHandler().invalidate();
        }
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        CompoundTag fluidNBT = new CompoundTag();
        this.getContent().writeToNBT(fluidNBT);
        tag.m_128365_("fluid", (Tag)fluidNBT);
        tag.m_128365_("inputInv", (Tag)this.inputInv.serializeNBT());
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.setContent(FluidStack.loadFluidStackFromNBT((CompoundTag)tag.m_128469_("fluid")));
        this.inputInv.deserializeNBT(tag.m_128469_("inputInv"));
    }

    public IItemHandler getInput() {
        return this.inputInv;
    }

    public ItemStack getInputItem() {
        return this.getInput().getStackInSlot(0);
    }

    @Override
    public int getInvSize() {
        return 1;
    }

    @Override
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new AlternativeTankMenu(windowId, inv, this);
    }

    @Override
    public int getMaxFuildValue() {
        return 256000;
    }

    @Override
    public boolean isInfoEmpty() {
        return this.getContent().isEmpty();
    }
}

