/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.sm;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import sweetmagic.init.TagInit;
import sweetmagic.init.TileInit;
import sweetmagic.init.tile.menu.ClerodendrumLampMenu;
import sweetmagic.init.tile.sm.TileSMMagic;
import sweetmagic.util.SMDamage;

public class TileClerodendrumLamp
extends TileSMMagic {
    public int maxMagiaFlux = 20000;
    public int spawnRange = 5;
    public boolean isPeace = false;
    public boolean viewRange = false;

    public TileClerodendrumLamp(BlockPos pos, BlockState state) {
        super(TileInit.clerodendrumLamp, pos, state);
    }

    public TileClerodendrumLamp(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void serverTick(Level world, BlockPos pos, BlockState state) {
        super.serverTick(world, pos, state);
        if (this.tickTime % 40 != 0 || !this.hasNeedMF() || this.isPeaceful(world) || this.isRSPower()) {
            return;
        }
        this.attackMob();
    }

    public void attackMob() {
        List<LivingEntity> entityList = this.getEntityListHalf(LivingEntity.class, e -> e.m_6084_() && e instanceof Enemy && !e.m_6095_().m_204039_(TagInit.BOSS), (double)this.getRange() + 0.25);
        if (entityList.isEmpty()) {
            return;
        }
        entityList.forEach(e -> this.magicDamage((LivingEntity)e, SMDamage.getDamage(SMDamage.poisonDamage, this.m_58904_()), 3.0f));
        this.setMF(this.getMF() - this.getShrinkMF());
        this.sendInfo();
    }

    public void magicDamage(LivingEntity entity, DamageSource src, float dame) {
        entity.m_6469_(src, dame);
        entity.f_19802_ = 0;
    }

    public int getRange() {
        return this.spawnRange;
    }

    @Override
    public int getMaxMF() {
        return this.maxMagiaFlux;
    }

    @Override
    public boolean hasNeedMF() {
        return this.getMF() >= this.getShrinkMF();
    }

    @Override
    public int getReceiveMF() {
        return 20000;
    }

    @Override
    public int getShrinkMF() {
        return 200;
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("spawnRange", this.spawnRange);
        tag.m_128379_("viewRange", this.viewRange);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.spawnRange = tag.m_128451_("spawnRange");
        this.viewRange = tag.m_128471_("viewRange");
    }

    @Override
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new ClerodendrumLampMenu(windowId, inv, this);
    }

    @Override
    public boolean isRSStop() {
        return true;
    }

    @Override
    public IItemHandler getInput() {
        return null;
    }

    @Override
    public boolean isInfoEmpty() {
        return this.spawnRange == 5 && this.isMFEmpty();
    }
}

