/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.sm;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import sweetmagic.api.iitem.IWand;
import sweetmagic.api.iitem.info.WandInfo;
import sweetmagic.init.SoundInit;
import sweetmagic.init.TileInit;
import sweetmagic.init.block.sm.IrisCreation;
import sweetmagic.init.tile.inventory.SMInventory;
import sweetmagic.init.tile.menu.IrisCreationMenu;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.recipe.iris.IrisRecipe;
import sweetmagic.util.ItemHelper;

public class TileIrisCreation
extends TileAbstractSM {
    public int maxCraftTime = 16;
    public int craftTime = 0;
    public boolean isCraft = false;
    public ItemStack outStack = ItemStack.f_41583_;
    public List<ItemStack> craftList = new ArrayList<ItemStack>();
    protected final TileAbstractSM.StackHandler handInv = new TileAbstractSM.StackHandler(1);
    protected final TileAbstractSM.StackHandler inputInv = new TileAbstractSM.StackHandler(this.getInvSize());
    protected final TileAbstractSM.StackHandler outputInv = new TileAbstractSM.StackHandler(1);

    public TileIrisCreation(BlockPos pos, BlockState state) {
        this(TileInit.iris, pos, state);
    }

    public TileIrisCreation(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.resolver = (TileAbstractSM)this.new TileAbstractSM.InOutHandlerProvider((IItemHandlerModifiable)this.inputInv, (IItemHandlerModifiable)this.outputInv);
    }

    @Override
    public void serverTick(Level level, BlockPos pos, BlockState state) {
        super.serverTick(level, pos, state);
        if (this.tickTime % 10 != 0) {
            return;
        }
        if (this.tickTime >= 20) {
            this.tickTime = 0;
            if (this.isCraft && this.craftTime + 18 >= this.maxCraftTime) {
                this.playSound(pos, SoundInit.POT, 0.1f, 1.0f);
            }
        }
        if (this.isCraft) {
            if (this.craftTime++ >= this.maxCraftTime) {
                this.craftFinish();
            }
            this.sendPKT();
        }
        if (this.isCraft || this.getHandItem().m_41619_()) {
            return;
        }
        if (this.checkRecipe()) {
            this.craftStart();
        }
    }

    @Override
    public void clientTick(Level world, BlockPos pos, BlockState state) {
        super.clientTick(world, pos, state);
        if (this.tickTime % 3 != 0 || !this.isCraft) {
            return;
        }
        this.tickTime = 0;
        boolean under = (Boolean)state.m_61143_((Property)IrisCreation.UNDER);
        double addY = under ? 0.8 : 0.1;
        for (int i = 0; i < this.rand.nextInt(4) + 1; ++i) {
            double x = (double)pos.m_123341_() + 0.5 + (this.rand.nextDouble() * 0.4 - 0.2);
            double y = (double)pos.m_123342_() + addY;
            double z = (double)pos.m_123343_() + 0.5 + (this.rand.nextDouble() * 0.4 - 0.2);
            world.m_7106_((ParticleOptions)ParticleTypes.f_123772_, x, y, z, 0.0, 0.0, 0.0);
        }
        if (under && this.rand.nextFloat() >= 0.75f) {
            double x = (double)pos.m_123341_() + 0.5 + (this.rand.nextDouble() * 0.4 - 0.2);
            double y = (double)pos.m_123342_() + 0.9;
            double z = (double)pos.m_123343_() + 0.5 + (this.rand.nextDouble() * 0.4 - 0.2);
            double speedY = this.rand.nextDouble() * 0.015;
            world.m_6485_((ParticleOptions)ParticleTypes.f_123778_, true, x, y, z, 0.0, 0.02 + speedY, 0.0);
        }
    }

    public List<ItemStack> getStackList() {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        stackList.add(this.getHandItem());
        for (int i = 0; i < this.getInvSize(); ++i) {
            this.addStackList(stackList, this.getInputItem(i));
        }
        return stackList;
    }

    public boolean checkRecipe() {
        return !IrisRecipe.getRecipe(this.m_58904_(), this.getStackList()).isEmpty();
    }

    public void craftStart() {
        List<ItemStack> stackList = this.getStackList();
        IrisRecipe recipe = IrisRecipe.getRecipe(this.m_58904_(), stackList).get();
        ItemStack resultStack = recipe.getResultItem().m_41777_();
        CompoundTag tags = this.getHandItem().m_41783_();
        if (tags != null) {
            IWand wand;
            List<Object> invStackList = new ArrayList();
            Item outItem = resultStack.m_41720_();
            if (outItem instanceof IWand) {
                wand = (IWand)outItem;
                tags.m_128405_("slotCount", wand.getSlot());
                invStackList = wand.getMagicList(stackList.get(0));
            }
            resultStack.m_41751_(tags);
            if (outItem instanceof IWand) {
                wand = (IWand)outItem;
                SMInventory.SMWandInventory inv = new SMInventory.SMWandInventory(new WandInfo(resultStack));
                inv.inv = new ItemStackHandler(wand.getSlot());
                for (int i = 0; i < invStackList.size(); ++i) {
                    inv.insertItem(i, (ItemStack)invStackList.get(i), false);
                }
                inv.writeBack();
            }
        }
        if (!ItemHelper.insertStack(this.getOutput(), resultStack, true).m_41619_()) {
            return;
        }
        this.craftList = new ArrayList<ItemStack>(recipe.getRequestList());
        this.outStack = resultStack;
        block1: for (ItemStack request : recipe.getRequestList()) {
            for (ItemStack stack : stackList) {
                if (!request.m_150930_(stack.m_41720_())) continue;
                stack.m_41774_(request.m_41613_());
                continue block1;
            }
        }
        this.isCraft = true;
        this.maxCraftTime = this.getBlock(this.m_58899_().m_7495_()) instanceof CampfireBlock ? 4 : 16;
        this.playSound(this.m_58899_(), SoundInit.POT, 0.1f, 1.0f);
    }

    public void craftFinish() {
        ItemHelper.insertStack(this.getOutput(), this.outStack, false);
        this.clearInfo();
        this.playSound(this.m_58899_(), SoundInit.IRIS_FINISH, 0.5f, 1.0f);
        Level level = this.m_58904_();
        if (level instanceof ServerLevel) {
            ServerLevel sever = (ServerLevel)level;
            BlockPos pos = this.m_58899_();
            SimpleParticleType par = ParticleTypes.f_123756_;
            for (int i = 0; i < 16; ++i) {
                sever.m_8767_((ParticleOptions)par, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.75, (double)pos.m_123343_() + 0.5, 0, 0.0, 0.0, 0.0, 1.0);
            }
        }
    }

    public void clearInfo() {
        this.craftTime = 0;
        this.isCraft = false;
        this.outStack = ItemStack.f_41583_;
        this.craftList.clear();
    }

    @Override
    public boolean isInfoEmpty() {
        return this.getDropList().isEmpty();
    }

    public List<ItemStack> getDropList() {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        this.addStackList(stackList, this.getHandItem());
        for (int i = 0; i < this.getInvSize(); ++i) {
            this.addStackList(stackList, this.getInputItem(i));
        }
        this.addStackList(stackList, this.getOutputItem());
        stackList.addAll(this.craftList);
        return stackList;
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("handInv", (Tag)this.handInv.serializeNBT());
        tag.m_128365_("inputInv", (Tag)this.inputInv.serializeNBT());
        tag.m_128365_("outputInv", (Tag)this.outputInv.serializeNBT());
        tag.m_128379_("isCraft", this.isCraft);
        tag.m_128405_("craftTime", this.craftTime);
        tag.m_128405_("maxCraftTime", this.maxCraftTime);
        this.saveStackList(tag, this.craftList, "craftList");
        tag.m_128365_("outPutStack", (Tag)this.outStack.m_41739_(new CompoundTag()));
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.handInv.deserializeNBT(tag.m_128469_("handInv"));
        this.inputInv.deserializeNBT(tag.m_128469_("inputInv"));
        this.outputInv.deserializeNBT(tag.m_128469_("outputInv"));
        this.isCraft = tag.m_128471_("isCraft");
        this.craftTime = tag.m_128451_("craftTime");
        this.maxCraftTime = tag.m_128451_("maxCraftTime");
        this.craftList = this.loadAllStack(tag, "craftList");
        this.outStack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("outPutStack"));
    }

    @Override
    public int getInvSize() {
        return 8;
    }

    public IItemHandler getHand() {
        return this.handInv;
    }

    public ItemStack getHandItem() {
        return this.getHand().getStackInSlot(0);
    }

    public IItemHandler getInput() {
        return this.inputInv;
    }

    public ItemStack getInputItem(int i) {
        return this.getInput().getStackInSlot(i);
    }

    public IItemHandler getOutput() {
        return this.outputInv;
    }

    public ItemStack getOutputItem() {
        return this.getOutput().getStackInSlot(0);
    }

    public int getProgress(int value) {
        return this.getProgress(value, this.craftTime, this.maxCraftTime);
    }

    @Override
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new IrisCreationMenu(windowId, inv, this);
    }

    @Override
    public boolean isRSStop() {
        return true;
    }
}

