/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.sm;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.registries.ForgeRegistries;
import sweetmagic.api.SweetMagicAPI;
import sweetmagic.init.ItemInit;
import sweetmagic.init.ParticleInit;
import sweetmagic.init.TagInit;
import sweetmagic.init.TileInit;
import sweetmagic.init.block.magic.MFFisher;
import sweetmagic.init.tile.menu.MFFisherMenu;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileSMMagic;
import sweetmagic.util.ItemHelper;

public class TileMFFisher
extends TileSMMagic {
    public int craftTime = 0;
    public int maxCraftTime = 0;
    public int maxMagiaFlux = 10000;
    public static final ItemStack FISHING_ROD = new ItemStack((ItemLike)Items.f_42523_);
    public static final ItemStack MACHETE = new ItemStack((ItemLike)ItemInit.machete);
    public static final ItemStack MILK_PACK = new ItemStack((ItemLike)ItemInit.milk_pack);
    public static final ItemStack AETHER_CRYSTAL = new ItemStack((ItemLike)ItemInit.aether_crystal);
    public static final ItemStack DIVINE_CRYSTAL = new ItemStack((ItemLike)ItemInit.divine_crystal);
    public static final ItemStack ALT_PICK = new ItemStack((ItemLike)ItemInit.alt_pick);
    public static final ItemStack EGG_BAG = new ItemStack((ItemLike)ItemInit.egg_bag);
    protected final TileAbstractSM.StackHandler inputInv = new TileAbstractSM.MagiaHandler(this.getInvSize());

    public TileMFFisher(BlockPos pos, BlockState state) {
        this(TileInit.mfFisher, pos, state);
    }

    public TileMFFisher(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.resolver = (TileAbstractSM)this.new TileAbstractSM.SingleHandlerProvider((IItemHandlerModifiable)this.inputInv, OUT);
    }

    @Override
    public void serverTick(Level world, BlockPos pos, BlockState state) {
        super.serverTick(world, pos, state);
        if (this.tickTime % 10 != 0 || this.isRSPower()) {
            return;
        }
        if (this.maxCraftTime <= 0) {
            this.setMaxCraftTime();
        }
        if (!this.canCraft()) {
            return;
        }
        if (this.craftTime++ >= this.maxCraftTime) {
            this.craftFinish(world, pos);
        }
        this.sendPKT();
        if (this.tickTime % 20 == 0) {
            this.tickTime = 0;
        }
    }

    @Override
    public void clientTick(Level world, BlockPos pos, BlockState state) {
        super.clientTick(world, pos, state);
        if (!(this.tickTime % 10 != 0 || this.isMFEmpty() || this.maxCraftTime < this.craftTime + 2 || this.getData() != 3 && this.getData() != 4)) {
            this.tickTime = 0;
            for (int i = 0; i < 2; ++i) {
                float randX = this.getRandFloat();
                float randY = this.getRandFloat(0.25f);
                float randZ = this.getRandFloat();
                float x = (float)pos.m_123341_() + 0.5f + randX;
                float y = (float)pos.m_123342_() + 0.5f + randY;
                float z = (float)pos.m_123343_() + 0.5f + randZ;
                float xSpeed = -randX * 0.1175f;
                float ySpeed = -(randY * 0.025f - 0.065f);
                float zSpeed = -randZ * 0.1175f;
                this.addParticle((ParticleOptions)ParticleInit.NORMAL, x, y, z, xSpeed, ySpeed, zSpeed);
            }
        }
    }

    public void craftFinish(Level world, BlockPos pos) {
        boolean isCraft = false;
        int useMF = this.getNeedMF();
        int data = this.getData();
        if ((data == 2 || data == 5 || data == 6) && this.getMF() < useMF) {
            isCraft = true;
            useMF = 0;
        } else if (this.getMF() >= useMF) {
            isCraft = true;
        }
        if (!isCraft) {
            return;
        }
        List<ItemStack> stackList = this.getDropList(world, pos);
        for (ItemStack stack : stackList) {
            ItemStack out = ItemHelper.insertStack(this.getInput(), stack.m_41777_(), true);
            if (out.m_41619_()) continue;
            return;
        }
        stackList.forEach(s -> ItemHelper.insertStack(this.getInput(), s.m_41777_(), false));
        this.setMF(this.getMF() - useMF);
        this.playSound(this.m_58899_(), this.getSound(), 0.1f, 1.0f);
        this.craftTime = 0;
        this.maxCraftTime = 0;
        this.sendPKT();
        if (data == 3 || data == 4) {
            this.renderParicle(world, pos, data);
        }
    }

    public List<ItemStack> getDropList(Level world, BlockPos pos) {
        RandomSource rand = this.m_58904_().m_213780_();
        ObjectArrayList stackList = new ArrayList();
        switch (this.getData()) {
            case 0: {
                int addY = world.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_49990_) ? -1 : 0;
                Vec3 vec = new Vec3((double)pos.m_123341_(), (double)(pos.m_123342_() + addY), (double)pos.m_123343_());
                LootParams loot = new LootParams.Builder((ServerLevel)this.m_58904_()).m_287286_(LootContextParams.f_81460_, (Object)vec).m_287286_(LootContextParams.f_81463_, (Object)FISHING_ROD).m_287239_(1.0f).m_287235_(LootContextParamSets.f_81414_);
                stackList = world.m_7654_().m_278653_().m_278676_(BuiltInLootTables.f_78720_).m_287195_(loot);
                if (rand.m_188501_() <= 0.125f) {
                    stackList.add(new ItemStack((ItemLike)Items.f_41910_));
                }
                if (rand.m_188501_() <= 0.125f) {
                    stackList.add(new ItemStack((ItemLike)Items.f_42527_));
                }
                if (rand.m_188501_() <= 0.25f) {
                    stackList.add(new ItemStack((ItemLike)ItemInit.shrimp));
                }
                if (!(rand.m_188501_() <= 0.35f)) break;
                stackList.add(new ItemStack((ItemLike)ItemInit.seaweed, rand.m_188503_(2) + 1));
                break;
            }
            case 1: {
                ArrayList meatList = new ArrayList();
                ForgeRegistries.ITEMS.tags().getTag(TagInit.MEAT).forEach(s -> meatList.add(new ItemStack((ItemLike)s)));
                stackList.add((ItemStack)((ItemStack)meatList.get(rand.m_188503_(meatList.size()))));
                if (rand.m_188501_() <= 0.25f) {
                    stackList.add((ItemStack)new ItemStack((ItemLike)Items.f_42579_));
                }
                if (rand.m_188501_() <= 0.25f) {
                    stackList.add((ItemStack)new ItemStack((ItemLike)Items.f_42485_));
                }
                if (!(rand.m_188501_() <= 0.25f)) break;
                stackList.add((ItemStack)new ItemStack((ItemLike)Items.f_42581_));
                break;
            }
            case 2: {
                stackList.add((ItemStack)new ItemStack((ItemLike)ItemInit.milk_pack, this.rand.nextInt(10) + 6));
                break;
            }
            case 3: {
                stackList.add((ItemStack)new ItemStack((ItemLike)AETHER_CRYSTAL.m_41720_(), this.getNeedMF() / SweetMagicAPI.getMF(AETHER_CRYSTAL)));
                break;
            }
            case 4: {
                stackList.add((ItemStack)new ItemStack((ItemLike)DIVINE_CRYSTAL.m_41720_(), this.getNeedMF() / SweetMagicAPI.getMF(DIVINE_CRYSTAL)));
                break;
            }
            case 5: {
                int rate = this.getMF() >= this.getNeedMF() ? 2 : 1;
                stackList.add((ItemStack)new ItemStack((ItemLike)Blocks.f_50652_, (this.rand.nextInt(5) + 2) * rate));
                break;
            }
            case 6: {
                stackList.add((ItemStack)new ItemStack((ItemLike)Items.f_42521_, this.rand.nextInt(10) + 6));
            }
        }
        return stackList;
    }

    public void renderParicle(Level world, BlockPos pos, int data) {
        if (!(world instanceof ServerLevel)) {
            return;
        }
        ServerLevel sever = (ServerLevel)world;
        SimpleParticleType par = data == 3 ? ParticleInit.AETHER : ParticleInit.DIVINE;
        for (int i = 0; i < 5; ++i) {
            float x = (float)pos.m_123341_() + 0.25f + this.rand.nextFloat() * 0.5f;
            float y = (float)pos.m_123342_() + 1.0f + this.rand.nextFloat() * 0.25f;
            float z = (float)pos.m_123343_() + 0.25f + this.rand.nextFloat() * 0.5f;
            sever.m_8767_((ParticleOptions)par, (double)x, (double)y, (double)z, 0, 0.0, -0.125, 0.0, 1.0);
        }
    }

    public void setMaxCraftTime() {
        int randTime = this.getRandTime();
        this.maxCraftTime = this.rand.nextInt((int)((float)randTime * 0.5f)) + randTime;
        this.sendPKT();
    }

    public int getRandTime() {
        return switch (this.getData()) {
            case 2 -> {
                if (this.getMF() >= this.getNeedMF()) {
                    yield 14;
                }
                yield 134;
            }
            case 3 -> 80;
            case 4 -> 120;
            case 5 -> {
                if (this.getMF() >= this.getNeedMF()) {
                    yield 20;
                }
                yield 80;
            }
            case 6 -> {
                if (this.getMF() >= this.getNeedMF()) {
                    yield 14;
                }
                yield 134;
            }
            default -> 20;
        };
    }

    public int getNeedMF() {
        switch (this.getData()) {
            case 2: {
                return 100;
            }
            case 3: {
                int mf = SweetMagicAPI.getMF(AETHER_CRYSTAL);
                int needMF = Math.max(mf, Math.min(this.getMF() / mf, 8) * mf);
                return needMF;
            }
            case 4: {
                int mfDiv = SweetMagicAPI.getMF(DIVINE_CRYSTAL);
                int needMFDiv = Math.max(mfDiv, Math.min(this.getMF() / mfDiv, 8) * mfDiv);
                return needMFDiv;
            }
            case 6: {
                return 100;
            }
        }
        return 300;
    }

    public boolean canCraft() {
        int data = this.getData();
        return data == 2 || data == 5 || data == 6 || this.getMF() >= this.getNeedMF();
    }

    public SoundEvent getSound() {
        return switch (this.getData()) {
            case 0 -> SoundEvents.f_11940_;
            case 1 -> SoundEvents.f_12344_;
            case 2 -> SoundEvents.f_11833_;
            case 3 -> SoundEvents.f_144242_;
            case 4 -> SoundEvents.f_144242_;
            case 5 -> SoundEvents.f_12442_;
            case 6 -> SoundEvents.f_11752_;
            default -> SoundEvents.f_11833_;
        };
    }

    @Override
    public int getInvSize() {
        return 27;
    }

    @Override
    public int getMaxMF() {
        return switch (this.getData()) {
            case 3 -> 40000;
            case 4 -> 400000;
            default -> this.maxMagiaFlux;
        };
    }

    @Override
    public int getReceiveMF() {
        return switch (this.getData()) {
            case 3 -> 10000;
            case 4 -> 50000;
            default -> 5000;
        };
    }

    @Override
    public IItemHandler getInput() {
        return this.inputInv;
    }

    public ItemStack getInputItem(int i) {
        return this.getInput().getStackInSlot(i);
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("inputInv", (Tag)this.inputInv.serializeNBT());
        tag.m_128405_("craftTime", this.craftTime);
        tag.m_128405_("maxCraftTime", this.maxCraftTime);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inputInv.deserializeNBT(tag.m_128469_("inputInv"));
        this.craftTime = tag.m_128451_("craftTime");
        this.maxCraftTime = tag.m_128451_("maxCraftTime");
    }

    public int getCraftProgress(int value) {
        return this.getProgress(value, this.craftTime, this.maxCraftTime);
    }

    @Override
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new MFFisherMenu(windowId, inv, this);
    }

    public int getData() {
        return this.isAir() ? 0 : ((MFFisher)this.getBlock(this.m_58899_())).getData();
    }

    @Override
    public boolean isRSStop() {
        return true;
    }

    public List<ItemStack> getInvList() {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        for (int i = 0; i < this.getInvSize(); ++i) {
            this.addStackList(stackList, this.getInputItem(i));
        }
        return stackList;
    }

    @Override
    public boolean isInfoEmpty() {
        return this.getInvList().isEmpty() && this.isMFEmpty();
    }
}

