/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.sm;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.Tags;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.registries.ForgeRegistries;
import sweetmagic.init.TagInit;
import sweetmagic.init.TileInit;
import sweetmagic.init.tile.menu.MFMinerAdvancedMenu;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileSMMagic;
import sweetmagic.util.ItemHelper;

public class TileMFMinerAdvanced
extends TileSMMagic {
    public int craftTime = 0;
    public int maxMagiaFlux = 100000;
    public static final int MAX_CRAFT_TIME = 10;
    public boolean isCraft = false;
    public ItemStack outStack = ItemStack.f_41583_;
    protected final TileAbstractSM.StackHandler inputInv = new TileAbstractSM.StackHandler(10);
    protected final TileAbstractSM.StackHandler outInv = new TileAbstractSM.StackHandler(this.getInvSize());

    public TileMFMinerAdvanced(BlockPos pos, BlockState state) {
        this(TileInit.mfMinerAdvanced, pos, state);
    }

    public TileMFMinerAdvanced(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.resolver = (TileAbstractSM)this.new TileAbstractSM.InOutHandlerProvider((IItemHandlerModifiable)this.inputInv, (IItemHandlerModifiable)this.outInv);
    }

    @Override
    public void serverTick(Level world, BlockPos pos, BlockState state) {
        super.serverTick(world, pos, state);
        if (this.tickTime % 10 != 0 || this.isRSPower()) {
            return;
        }
        if (!this.isCraft) {
            this.craftStart();
        } else if (this.craftTime++ >= 10) {
            this.craftEnd();
        }
        this.sendInfo();
    }

    public void craftStart() {
        ItemHelper.compactSimpleInventory((IItemHandlerModifiable)this.inputInv);
        ItemStack stack = this.getInputItem(0);
        if (stack.m_41619_() || !stack.m_204117_(Tags.Items.COBBLESTONE) || stack.m_41613_() < 64) {
            return;
        }
        int mf = this.getMF();
        if (mf < this.getNeedMF()) {
            return;
        }
        List<ItemStack> oresList = this.getList(ForgeRegistries.ITEMS.tags().getTag(Tags.Items.ORES).stream());
        ItemStack oreStack = oresList.get(this.rand.nextInt(oresList.size()));
        if (oreStack.m_41619_()) {
            return;
        }
        ItemStack itemStack = oreStack = oreStack.m_204117_(TagInit.COSMIC_ORE) ? new ItemStack((ItemLike)Blocks.f_49996_) : oreStack;
        if (oreStack.m_204117_(Tags.Items.ORES_NETHERITE_SCRAP) && this.rand.nextFloat() > 0.001f) {
            oreStack = new ItemStack((ItemLike)Blocks.f_49995_);
        }
        if (!ItemHelper.insertStack(this.getOut(), oreStack.m_41777_(), true).m_41619_()) {
            return;
        }
        this.isCraft = true;
        this.outStack = oreStack;
        stack.m_41774_(64);
        this.setMF(mf - this.getNeedMF());
        this.sendInfo();
    }

    public void craftEnd() {
        ItemHelper.insertStack(this.getOut(), this.outStack.m_41777_(), false);
        this.outStack = ItemStack.f_41583_;
        ItemHelper.compactSimpleInventory((IItemHandlerModifiable)this.inputInv);
        ItemStack stack = this.getInputItem(0);
        this.isCraft = !stack.m_41619_() && stack.m_204117_(Tags.Items.COBBLESTONE) && stack.m_41613_() >= 64;
        this.craftTime = this.isCraft ? 6 : 0;
        this.isCraft = false;
        this.playSound(this.m_58899_(), SoundEvents.f_144242_, 0.5f, 1.0f);
        this.sendInfo();
    }

    public List<ItemStack> getList(Stream<Item> stream) {
        return stream.map(Item::m_7968_).collect(Collectors.toList());
    }

    @Override
    public int getInvSize() {
        return 27;
    }

    @Override
    public int getMaxMF() {
        return this.maxMagiaFlux;
    }

    @Override
    public int getReceiveMF() {
        return 5000;
    }

    public int getNeedMF() {
        return 1000;
    }

    @Override
    public IItemHandler getInput() {
        return this.inputInv;
    }

    public ItemStack getInputItem(int i) {
        return this.getInput().getStackInSlot(i);
    }

    public IItemHandler getOut() {
        return this.outInv;
    }

    public ItemStack getOutItem(int i) {
        return this.getOut().getStackInSlot(i);
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("inputInv", (Tag)this.inputInv.serializeNBT());
        tag.m_128365_("outInv", (Tag)this.outInv.serializeNBT());
        tag.m_128405_("craftTime", this.craftTime);
        tag.m_128379_("isCraft", this.isCraft);
        tag.m_128365_("outStack", (Tag)this.outStack.m_41739_(new CompoundTag()));
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inputInv.deserializeNBT(tag.m_128469_("inputInv"));
        this.outInv.deserializeNBT(tag.m_128469_("outInv"));
        this.craftTime = tag.m_128451_("craftTime");
        this.isCraft = tag.m_128471_("isCraft");
        this.outStack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("outStack"));
    }

    @Override
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new MFMinerAdvancedMenu(windowId, inv, this);
    }

    @Override
    public boolean isRSStop() {
        return true;
    }

    public int getCraftProgress(int value) {
        return this.getProgress(value, this.craftTime, 10);
    }

    public List<ItemStack> getInvList() {
        int i;
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        for (i = 0; i < this.getInvSize(); ++i) {
            this.addStackList(stackList, this.getOutItem(i));
        }
        for (i = 0; i < 9; ++i) {
            this.addStackList(stackList, this.getInputItem(i));
        }
        return stackList;
    }

    @Override
    public boolean isInfoEmpty() {
        return this.getInvList().isEmpty() && this.isMFEmpty();
    }
}

