/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.sm;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import sweetmagic.api.ientity.ISMMob;
import sweetmagic.init.TileInit;
import sweetmagic.init.entity.monster.ArchSpider;
import sweetmagic.init.entity.monster.BlazeTempest;
import sweetmagic.init.entity.monster.CreeperCalamity;
import sweetmagic.init.entity.monster.DwarfZombie;
import sweetmagic.init.entity.monster.ElectricCube;
import sweetmagic.init.entity.monster.EnderMage;
import sweetmagic.init.entity.monster.SkullFlame;
import sweetmagic.init.entity.monster.SkullFrost;
import sweetmagic.init.entity.monster.WindWitch;
import sweetmagic.init.tile.menu.MFSpawnerMenu;
import sweetmagic.init.tile.sm.TileSMMagic;
import sweetmagic.util.WorldHelper;

public class TileMFSpawner
extends TileSMMagic {
    public int maxMagiaFlux = 200000;
    public int mobType = 0;
    public int spawnRange = 5;
    public int randTick = 0;
    public int maxRandTick = 20;
    public boolean isPeace = false;
    public boolean viewRange = false;
    public LivingEntity entity = null;
    private static final int MAX_SPAWNCOUNT = 12;

    public TileMFSpawner(BlockPos pos, BlockState state) {
        super(TileInit.mfSpawner, pos, state);
    }

    public TileMFSpawner(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void serverTick(Level world, BlockPos pos, BlockState state) {
        super.serverTick(world, pos, state);
        if (this.tickTime % 20 != 0 || !this.hasNeedMF() || this.isPeaceful(world) || this.isRSPower()) {
            return;
        }
        if (this.randTick++ < this.maxRandTick) {
            this.sendInfo();
            return;
        }
        this.spawnMob(world, pos);
    }

    @Override
    public void clientTick(Level world, BlockPos pos, BlockState state) {
        super.clientTick(world, pos, state);
        if (this.tickTime % 20 != 0 || this.isMFEmpty() || this.isRSPower()) {
            return;
        }
        this.isPeace = this.isPeaceful(world);
        if (this.isPeace) {
            return;
        }
    }

    public void spawnMob(Level world, BlockPos pos) {
        if (!(world instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)world;
        int maxCount = 16;
        Random rand = this.rand;
        BlockPos targetPos = this.getTargetPos();
        String uniqueName = this.getUniqueTagName();
        int entityListSize = this.getEntityList(LivingEntity.class, e -> e.m_6084_() && e.getPersistentData().m_128471_(uniqueName), this.getRange() * 5).size();
        int canSpawnCount = 12 - entityListSize;
        if (canSpawnCount <= 0) {
            return;
        }
        canSpawnCount = rand.nextInt(4) + 1;
        for (int i = 0; i < canSpawnCount; ++i) {
            int count = 0;
            BlockPos summonPos = WorldHelper.offset(targetPos, this.getRand(rand, this.getRange()), 1.0, this.getRand(rand, this.getRange()));
            while (!this.checkAABB(world, summonPos)) {
                summonPos = WorldHelper.offset(targetPos, this.getRand(rand, this.getRange()), 1.0, this.getRand(rand, this.getRange()));
                if (count++ <= maxCount) continue;
            }
            Mob entity = this.getEntity();
            entity.m_146884_(summonPos.m_252807_());
            entity.getPersistentData().m_128379_(uniqueName, true);
            world.m_7967_((Entity)entity);
            entity.m_21373_();
        }
        this.randTick = 0;
        this.maxRandTick = 15 + this.rand.nextInt(10);
        this.setMF(this.getMF() - this.getShrinkMF());
        this.sendInfo();
    }

    public int getRand(Random rand, int range) {
        return rand.nextInt(range) - rand.nextInt(range);
    }

    public float getRand(Random rand) {
        return rand.nextFloat() - rand.nextFloat();
    }

    public BlockPos getTargetPos() {
        return this.m_58899_().m_5484_(this.getFace(), -(this.spawnRange + 1));
    }

    public LivingEntity getRenderEntity() {
        if (this.entity == null) {
            this.entity = this.getEntity();
        }
        return this.entity;
    }

    public Mob getEntity() {
        Level world = this.m_58904_();
        ISMMob entity = null;
        switch (this.mobType) {
            case 1: {
                entity = new SkullFlame(world);
                entity.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
                break;
            }
            case 2: {
                entity = new BlazeTempest(world);
                break;
            }
            case 3: {
                entity = new EnderMage(world);
                break;
            }
            case 4: {
                entity = new ArchSpider(world);
                break;
            }
            case 5: {
                entity = new CreeperCalamity(world);
                break;
            }
            case 6: {
                entity = new ElectricCube(world);
                break;
            }
            case 7: {
                entity = new DwarfZombie(world);
                break;
            }
            case 8: {
                entity = new WindWitch(world);
                break;
            }
            default: {
                entity = new SkullFrost(world);
                entity.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
            }
        }
        entity.m_21051_(Attributes.f_22276_).m_22100_(30.0);
        entity.m_21153_(entity.m_21233_());
        return entity;
    }

    public int getRange() {
        return this.spawnRange;
    }

    public int getMobType() {
        return this.mobType;
    }

    @Override
    public int getMaxMF() {
        return this.maxMagiaFlux;
    }

    @Override
    public boolean hasNeedMF() {
        return this.getMF() >= this.getShrinkMF();
    }

    @Override
    public int getReceiveMF() {
        return 20000;
    }

    @Override
    public int getShrinkMF() {
        return 5000;
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("mobType", this.mobType);
        tag.m_128405_("spawnRange", this.spawnRange);
        tag.m_128405_("randTick", this.randTick);
        tag.m_128405_("maxRandTick", this.maxRandTick);
        tag.m_128379_("viewRange", this.viewRange);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.mobType = tag.m_128451_("mobType");
        this.spawnRange = tag.m_128451_("spawnRange");
        this.randTick = tag.m_128451_("randTick");
        this.maxRandTick = tag.m_128451_("maxRandTick");
        this.viewRange = tag.m_128471_("viewRange");
    }

    @Override
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new MFSpawnerMenu(windowId, inv, this);
    }

    public String getUniqueTagName() {
        BlockPos pos = this.m_58899_();
        return pos.m_123341_() + "_" + pos.m_123342_() + "_" + pos.m_123343_();
    }

    public Component getEntityName() {
        return this.getRenderEntity().m_7755_();
    }

    @Override
    public boolean isRSStop() {
        return true;
    }

    @Override
    public IItemHandler getInput() {
        return null;
    }

    @Override
    public boolean isInfoEmpty() {
        return this.spawnRange == 5 && this.mobType == 0 && this.isMFEmpty();
    }
}

