/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.sm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import sweetmagic.api.SweetMagicAPI;
import sweetmagic.api.iblock.ITileMF;
import sweetmagic.init.TileInit;
import sweetmagic.init.tile.menu.MFTankMenu;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileSMMagic;
import sweetmagic.recipe.tank.TankRecipe;
import sweetmagic.util.ItemHelper;

public class TileMFTank
extends TileSMMagic {
    public int maxMagiaFlux = 100000;
    public int viewMFInsert = 0;
    public int viewMFExtract = 0;
    public int newMFInsert = 0;
    public int newMFExtract = 0;
    public int oldMFInsert = 0;
    public int oldMFExtract = 0;
    protected final TileAbstractSM.StackHandler inputInv = new TileAbstractSM.StackHandler(this.getInvSize());
    protected final TileAbstractSM.StackHandler outputInv = new TileAbstractSM.StackHandler(this.getSubInvSize());

    public TileMFTank(BlockPos pos, BlockState state) {
        this(TileInit.tank, pos, state);
    }

    public TileMFTank(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.resolver = (TileAbstractSM)this.new TileAbstractSM.InOutHandlerProvider((IItemHandlerModifiable)this.inputInv, (IItemHandlerModifiable)this.outputInv);
    }

    @Override
    public void serverTick(Level level, BlockPos pos, BlockState state) {
        super.serverTick(level, pos, state);
        if (this.getTickTime() % 10 != 0) {
            return;
        }
        this.smeltAction();
        if (!this.isMFEmpty()) {
            this.underInsertMF(pos);
        }
        if (this.getTickTime() % 20 == 0) {
            this.getMFStatistics();
        }
    }

    public void smeltAction() {
        for (int i = 0; i < this.getInvSize(); ++i) {
            if (!this.canSmelt(i)) continue;
            this.smeltItem(i);
        }
    }

    public boolean canSmelt(int index) {
        ItemStack toSmelt = this.getInputItem(index);
        if (toSmelt.m_41619_()) {
            return false;
        }
        return !TankRecipe.getRecipe(this.m_58904_(), Arrays.asList(toSmelt)).isEmpty();
    }

    protected void smeltItem(int index) {
        ItemStack inputStack = this.getInputItem(index);
        TankRecipe recipe = TankRecipe.getRecipe(this.m_58904_(), Arrays.asList(inputStack)).get();
        int needMF = recipe.getMFList().get(0);
        ItemStack smeltResult = recipe.getResultItem();
        if (smeltResult.m_41619_() || this.getMF() < needMF) {
            return;
        }
        if (!ItemHelper.insertStack(this.getOut(), smeltResult, true).m_41619_()) {
            return;
        }
        this.setMF(this.getMF() - needMF);
        ItemHelper.insertStack(this.getOut(), smeltResult, false);
        inputStack.m_41774_(recipe.getRequestList().get(0).m_41613_());
        this.sentClient();
    }

    public void getMFStatistics() {
        this.oldMFInsert = this.newMFInsert -= this.oldMFInsert;
        this.viewMFInsert = this.newMFInsert;
        this.oldMFExtract = this.newMFExtract -= this.oldMFExtract;
        this.viewMFExtract = this.newMFExtract;
        this.tickTime = 0;
        this.sendPKT();
    }

    public int getNeedMF(ItemStack stack) {
        return SweetMagicAPI.getMF(stack);
    }

    @Override
    public void maxMFInsert(ITileMF tran) {
        BlockEntity bEntity = this.getTile(this.m_58899_().m_7494_());
        if (bEntity == null || !(bEntity instanceof TileMFTank)) {
            return;
        }
        TileMFTank tile = (TileMFTank)bEntity;
        tile.insertMF(tile, tran, tile.getTickTime());
    }

    public void underInsertMF(BlockPos pos) {
        TileMFTank tile;
        if (this.hasPosList(pos)) {
            return;
        }
        BlockEntity bEntity = this.getTile(pos.m_7495_());
        if (bEntity == null || !(bEntity instanceof TileMFTank) || (tile = (TileMFTank)bEntity).isMaxMF()) {
            return;
        }
        this.insertMF(tile, this, this.getTickTime());
    }

    @Override
    public void recipedMFInsert() {
        TileMFTank tile;
        BlockEntity bEntity = this.getTile(this.m_58899_().m_7495_());
        if (bEntity == null || !(bEntity instanceof TileMFTank) || (tile = (TileMFTank)bEntity).isMaxMF()) {
            return;
        }
        this.insertMF(tile, this, this.getTickTime());
    }

    @Override
    public void loadNBT(CompoundTag tags) {
        this.inputInv.deserializeNBT(tags.m_128469_("inputInv"));
        this.outputInv.deserializeNBT(tags.m_128469_("outputInv"));
        this.tickTime = tags.m_128451_("tickTime");
        this.viewMFInsert = tags.m_128451_("viewMFInsert");
        this.newMFInsert = tags.m_128451_("newMFInsert");
        this.oldMFInsert = tags.m_128451_("oldMFInsert");
        this.viewMFExtract = tags.m_128451_("viewMFExtract");
        this.newMFExtract = tags.m_128451_("newMFExtract");
        this.oldMFExtract = tags.m_128451_("oldMFExtract");
    }

    @Override
    public void saveNBT(CompoundTag tags) {
        tags.m_128365_("inputInv", (Tag)this.inputInv.serializeNBT());
        tags.m_128365_("outputInv", (Tag)this.outputInv.serializeNBT());
        tags.m_128405_("tickTime", this.tickTime);
        tags.m_128405_("viewMFInsert", this.viewMFInsert);
        tags.m_128405_("newMFInsert", this.newMFInsert);
        tags.m_128405_("oldMFInsert", this.oldMFInsert);
        tags.m_128405_("viewMFExtract", this.viewMFExtract);
        tags.m_128405_("newMFExtract", this.newMFExtract);
        tags.m_128405_("oldMFExtract", this.oldMFExtract);
    }

    @Override
    public void setMF(int mf) {
        int oldMF = this.getMF();
        super.setMF(mf);
        int newMF = this.getMF();
        if (this.m_58904_() == null || !this.isSever()) {
            return;
        }
        if (newMF > oldMF) {
            this.newMFInsert += newMF - oldMF;
        } else if (oldMF > newMF) {
            this.newMFExtract += oldMF - newMF;
        }
    }

    @Override
    public int getMaxMF() {
        return this.maxMagiaFlux;
    }

    @Override
    public int getReceiveMF() {
        return this.getMaxMF();
    }

    @Override
    public int getInvSize() {
        return 1;
    }

    public int getSubInvSize() {
        return 3;
    }

    @Override
    public IItemHandler getInput() {
        return this.inputInv;
    }

    public ItemStack getInputItem(int i) {
        return this.getInput().getStackInSlot(i);
    }

    public IItemHandler getOut() {
        return this.outputInv;
    }

    public ItemStack getOutItem(int i) {
        return this.getOut().getStackInSlot(i);
    }

    @Override
    public int getShrinkMF() {
        return 1000;
    }

    @Override
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new MFTankMenu(windowId, inv, this);
    }

    public List<ItemStack> getInvList() {
        int i;
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        for (i = 0; i < this.getInvSize(); ++i) {
            this.addStackList(stackList, this.getInputItem(i));
        }
        for (i = 0; i < this.getSubInvSize(); ++i) {
            this.addStackList(stackList, this.getOutItem(i));
        }
        return stackList;
    }

    @Override
    public boolean isInfoEmpty() {
        return this.getInvList().isEmpty() && this.isMFEmpty();
    }
}

