/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.sm;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import sweetmagic.init.TileInit;
import sweetmagic.init.tile.menu.MagiaAcceleratorMenu;
import sweetmagic.init.tile.sm.TileSMMagic;

public class TileMagiaAccelerator
extends TileSMMagic {
    private static final int MIN_RANGE = 1;
    private static final int MAX_RANGE = 16;
    public int maxMagiaFlux = 200000;
    public int range = 12;
    public boolean isRangeView = false;

    public TileMagiaAccelerator(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public TileMagiaAccelerator(BlockPos pos, BlockState state) {
        super(TileInit.magiaAccelerator, pos, state);
    }

    @Override
    public void serverTick(Level world, BlockPos pos, BlockState state) {
        super.serverTick(world, pos, state);
        if (this.tickTime % 4 == 0 && !this.isRSPower() && this.getMF() >= 4) {
            this.roundMFAccelerator(world);
        }
    }

    public void roundMFAccelerator(Level world) {
        int sumMF = 0;
        int mf = this.getMF();
        Iterable<BlockPos> posList = this.getRangePosUnder(this.m_58899_(), this.range);
        for (BlockPos pos : posList) {
            TileSMMagic tile;
            BlockEntity blockEntity = this.getTile(pos);
            if (!(blockEntity instanceof TileSMMagic) || !(tile = (TileSMMagic)blockEntity).getReceive() || tile instanceof TileMagiaAccelerator) continue;
            tile.serverTick(this.f_58857_, pos, this.getState(pos));
            if ((sumMF += 4) < mf) continue;
            break;
        }
        this.setMF(mf - sumMF);
        this.sendPKT();
    }

    public void addRange(int id) {
        int addValue = 0;
        switch (id) {
            case 0: {
                addValue = 1;
                break;
            }
            case 1: {
                addValue = 10;
                break;
            }
            case 2: {
                addValue = -1;
                break;
            }
            case 3: {
                addValue = -10;
                break;
            }
            case 4: {
                this.isRangeView = !this.isRangeView;
            }
        }
        this.range = Math.min(16, Math.max(1, this.range + addValue));
        this.clickButton();
        this.sendPKT();
    }

    @Override
    public int getMaxMF() {
        return this.maxMagiaFlux;
    }

    @Override
    public int getReceiveMF() {
        return 10000;
    }

    @Override
    public IItemHandler getInput() {
        return null;
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("range", this.range);
        tag.m_128379_("isRangeView", this.isRangeView);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.range = tag.m_128451_("range");
        this.isRangeView = tag.m_128471_("isRangeView");
    }

    @Override
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new MagiaAcceleratorMenu(windowId, inv, this);
    }

    @Override
    public boolean isInfoEmpty() {
        return this.isMFEmpty();
    }
}

