/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.sm;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import sweetmagic.init.BlockInit;
import sweetmagic.init.TileInit;
import sweetmagic.init.tile.menu.MagiaChestMenu;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileWoodChest;
import sweetmagic.util.ItemHelper;

public class TileMagiaChest
extends TileWoodChest {
    public int range = 4;
    private static final int MIN_RANGE = 0;
    private static final int MAX_RANGE = 16;
    public final TileAbstractSM.StackHandler targetInv = new TileAbstractSM.StackHandler(1);

    public TileMagiaChest(BlockPos pos, BlockState state) {
        this(TileInit.magiaChest, pos, state);
    }

    public TileMagiaChest(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void serverTick(Level world, BlockPos pos, BlockState state) {
        Object object;
        super.serverTick(world, pos, state);
        if (this.tickTime % 20 != 0 || this.isRSPower() || this.range <= 0) {
            return;
        }
        this.tickTime = 0;
        Block block = null;
        ItemStack stack = this.getTargetBlock();
        if (!stack.m_41619_() && (object = stack.m_41720_()) instanceof BlockItem) {
            BlockItem bItem = (BlockItem)object;
            block = bItem.m_40614_();
        }
        Iterable<BlockPos> posList = this.getRangePosUnder(pos, this.range);
        for (BlockPos p : posList) {
            Block target = this.getBlock(p);
            if (block != null && !target.equals(block) || target.equals(BlockInit.magia_chest)) continue;
            this.suctionItem(world, p);
        }
    }

    public void suctionItem(Level world, BlockPos pos) {
        BlockEntity tile = this.getTile(pos);
        if (tile == null) {
            return;
        }
        IItemHandler handler = this.getItemHandler(tile, Direction.DOWN);
        if (handler == null) {
            return;
        }
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack output = handler.getStackInSlot(i);
            if (output.m_41619_() || !this.checkFilter(output)) continue;
            ItemStack insert = ItemHelper.insertStack(this.getInput(), output.m_41777_(), false);
            output.m_41764_(insert.m_41613_());
        }
    }

    public void addRange(int id) {
        int addValue = 0;
        switch (id) {
            case 0: {
                addValue = 1;
                break;
            }
            case 1: {
                addValue = 10;
                break;
            }
            case 2: {
                addValue = -1;
                break;
            }
            case 3: {
                addValue = -10;
            }
        }
        this.range = Math.min(16, Math.max(0, this.range + addValue));
        this.clickButton();
        this.sendPKT();
    }

    public IItemHandler getTarget() {
        return this.targetInv;
    }

    public ItemStack getTargetBlock() {
        return this.getTarget().getStackInSlot(0);
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("range", this.range);
        tag.m_128365_("targetInv", (Tag)this.targetInv.serializeNBT());
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.range = tag.m_128451_("range");
        this.targetInv.deserializeNBT(tag.m_128469_("targetInv"));
    }

    @Override
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new MagiaChestMenu(windowId, inv, this);
    }

    @Override
    public boolean isRSStop() {
        return true;
    }

    @Override
    public boolean isItemFilter() {
        return true;
    }
}

