/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.sm;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import sweetmagic.init.ItemInit;
import sweetmagic.init.ParticleInit;
import sweetmagic.init.SoundInit;
import sweetmagic.init.TileInit;
import sweetmagic.init.item.sm.SMBook;
import sweetmagic.init.tile.menu.MagiaRewriteMenu;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileSMMagic;
import sweetmagic.util.ItemHelper;

public class TileMagiaRewrite
extends TileSMMagic {
    public boolean isCraft = false;
    public int nowLevel = 1;
    public int craftTime = 0;
    public int craftTick = 0;
    public int maxMagiaFlux = 1000000;
    private static final int MAX_CRAFT_TIME = 30;
    public ItemStack outStack = ItemStack.f_41583_;
    protected final TileAbstractSM.StackHandler inputInv = (TileAbstractSM)this.new TileAbstractSM.StackHandler(1, true);
    protected final TileAbstractSM.StackHandler outInv = (TileAbstractSM)this.new TileAbstractSM.StackHandler(1, true);
    protected final TileAbstractSM.StackHandler bookInv = new TileAbstractSM.StackHandler(1);

    public TileMagiaRewrite(BlockPos pos, BlockState state) {
        this(TileInit.magiaWrite, pos, state);
    }

    public TileMagiaRewrite(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.resolver = (TileAbstractSM)this.new TileAbstractSM.InOutHandlerProvider((IItemHandlerModifiable)this.inputInv, (IItemHandlerModifiable)this.outInv);
    }

    @Override
    public void serverTick(Level world, BlockPos pos, BlockState state) {
        super.serverTick(world, pos, state);
        if (this.isCraft) {
            ++this.craftTick;
            this.sendPKT();
            int value = 10;
            if (this.craftTime > 10 && this.craftTime <= 25) {
                value = 5;
            }
            if (this.tickTime % value == 0 && this.craftTime < 29) {
                this.playSound(pos, SoundInit.SWING, 0.15f, 1.0f);
            }
        }
        if (this.tickTime % 10 != 0) {
            return;
        }
        if (this.tickTime >= 20) {
            this.tickTime = 0;
        }
        if (this.isCraft) {
            if (this.craftTime++ >= 30) {
                this.craftFinish();
            }
            this.sendPKT();
        } else if (this.getNowLevel() > 1 && this.getBookItem().m_41619_()) {
            this.nowLevel = 1;
            this.sendPKT();
        }
    }

    @Override
    public void clientTick(Level world, BlockPos pos, BlockState state) {
        super.clientTick(world, pos, state);
        if (this.isCraft && this.tickTime % 6 == 0 && this.craftTime < 24) {
            this.spawnParticl();
        }
        if (this.isCraft && this.tickTime % 10 == 0 && this.craftTime > 3 && this.craftTime < 27) {
            SimpleParticleType par = ParticleInit.CYCLE_RERITE;
            for (int i = 0; i < 2; ++i) {
                this.spawnParticleCycle(world, (ParticleOptions)par, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.85, (double)pos.m_123343_() + 0.5, Direction.UP, 0.7, i * 180, false);
                this.spawnParticleCycle(world, (ParticleOptions)par, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.55, (double)pos.m_123343_() + 0.5, Direction.UP, 0.6, i * 180, true);
            }
        }
    }

    public void craftStart(int id) {
        ItemStack magicBook = this.getBookItem();
        if (magicBook.m_41619_()) {
            return;
        }
        ItemStack input = this.getInputItem();
        if (input.m_41619_() || !this.getOutItem().m_41619_()) {
            return;
        }
        int needMF = this.getEnchantCost(id);
        if (this.getMF() < needMF || needMF <= 0) {
            return;
        }
        int changedLevel = this.getChanedLevel(id, input);
        if (changedLevel <= 0) {
            return;
        }
        int tier = this.getTier();
        int nowLevel = this.getNowEnchantLevel(id, input);
        this.setEnchant(id, input, changedLevel);
        this.isCraft = true;
        ++this.craftTick;
        this.tickTime = 0;
        this.outStack = input.m_41777_();
        input.m_41774_(1);
        this.setMF(this.getMF() - needMF);
        if (tier == 3) {
            int levelUp = changedLevel - nowLevel;
            magicBook.m_41774_(levelUp);
        }
        this.sendPKT();
        this.clickButton();
    }

    public void craftFinish() {
        boolean isChange = this.changeOutput && this.getInputItem().m_41619_();
        ItemHelper.insertStack(isChange ? this.getInput() : this.getOut(), this.outStack, false);
        this.playSound(this.m_58899_(), SoundEvents.f_11887_, 1.0f, 1.0f);
        this.clearInfo();
    }

    public Enchantment getEnchant(int id) {
        ItemStack stack = this.getInputItem();
        if (stack.m_41619_()) {
            return null;
        }
        List<Enchantment> enchaList = this.stackEnchaList(stack);
        if (enchaList.isEmpty() || id >= enchaList.size()) {
            return null;
        }
        return enchaList.get(id);
    }

    public int getEnchaLevel(int id) {
        ItemStack stack = this.getInputItem();
        ListTag listTags = stack.m_41785_();
        CompoundTag tags = listTags.m_128728_(id);
        int level = EnchantmentHelper.m_182438_((CompoundTag)tags);
        return level;
    }

    public List<Enchantment> getEnchaList() {
        return this.stackEnchaList(this.getInputItem());
    }

    public List<Enchantment> stackEnchaList(ItemStack stack) {
        ListTag listTag = stack.m_41785_();
        ArrayList<Enchantment> stackEncha = new ArrayList<Enchantment>();
        if (!listTag.isEmpty()) {
            listTag.forEach(t -> stackEncha.add((Enchantment)BuiltInRegistries.f_256876_.m_6612_(this.getEnchantId(this.getTag((Tag)t))).get()));
        }
        return stackEncha;
    }

    public int getEnchantCost(int id) {
        ItemStack stack = this.getInputItem();
        if (stack.m_41619_()) {
            return 0;
        }
        ListTag listTags = stack.m_41785_();
        if (listTags.isEmpty() || id >= listTags.size()) {
            return 0;
        }
        CompoundTag tags = listTags.m_128728_(id);
        ResourceLocation enchaSRC = EnchantmentHelper.m_182446_((CompoundTag)tags);
        if (enchaSRC == null) {
            return 0;
        }
        List<Enchantment> enchaList = this.stackEnchaList(stack);
        if (enchaList.isEmpty()) {
            return 0;
        }
        Enchantment encha = enchaList.get(id);
        int level = EnchantmentHelper.m_182438_((CompoundTag)tags);
        if (level >= this.getMaxEnchantLevel()) {
            return 0;
        }
        int tier = this.getTier();
        int maxLevel = encha.m_6586_();
        int canAddLevel = this.getMaxRwiteLevel(maxLevel);
        if (maxLevel == 1 || level >= canAddLevel || tier >= 3 && level < maxLevel) {
            return 0;
        }
        int rate = 6 - Math.min(maxLevel, 5);
        int addRate = Math.min(maxLevel, level + this.nowLevel) - level;
        if (tier >= 3) {
            ItemStack magicBook = this.getBookItem();
            int changedLevel = this.getChanedLevel(id, stack);
            int nowLevel = this.getNowEnchantLevel(id, stack);
            if (magicBook.m_41613_() < changedLevel - nowLevel) {
                return -1;
            }
            addRate = (Math.min(maxLevel * 2, level + this.nowLevel) - level) * 5;
            if (encha.m_44699_().m_44716_() == 1 || encha == Enchantments.f_44987_) {
                return this.maxMagiaFlux;
            }
        }
        return (11 - encha.m_44699_().m_44716_()) * 1500 * rate * rate * addRate;
    }

    public int getChanedLevel(int id) {
        return this.getChanedLevel(id, this.getInputItem());
    }

    public int getChanedLevel(int id, ItemStack stack) {
        int addLevel;
        Enchantment encha = this.getEnchant(id);
        if (encha == null) {
            return 0;
        }
        ListTag listTags = stack.m_41785_();
        CompoundTag tags = listTags.m_128728_(id);
        int level = EnchantmentHelper.m_182438_((CompoundTag)tags);
        int maxLevel = encha.m_6586_();
        int addMaxLevel = this.getMaxRwiteLevel(maxLevel);
        if (addMaxLevel > maxLevel) {
            maxLevel = addMaxLevel;
        }
        return (addLevel = Math.min(maxLevel, level + this.nowLevel) - level) <= 0 ? 0 : level + addLevel;
    }

    public int getNowEnchantLevel(int id) {
        return this.getNowEnchantLevel(id, this.getInputItem());
    }

    public int getNowEnchantLevel(int id, ItemStack stack) {
        ListTag listTags = stack.m_41785_();
        CompoundTag tags = listTags.m_128728_(id);
        return EnchantmentHelper.m_182438_((CompoundTag)tags);
    }

    public void setEnchant(int id, ItemStack stack, int level) {
        ListTag listTags = stack.m_41785_();
        CompoundTag tags = listTags.m_128728_(id);
        EnchantmentHelper.m_182440_((CompoundTag)tags, (int)level);
        stack.m_41783_().m_128365_("Enchantments", (Tag)listTags);
    }

    @Nullable
    public ResourceLocation getEnchantId(CompoundTag id) {
        return ResourceLocation.m_135820_((String)id.m_128461_("id"));
    }

    public void clickLevelButton(int id) {
        ItemStack stack = this.getBookItem();
        if (stack.m_41619_()) {
            return;
        }
        int tier = this.getTier();
        int maxLevel = this.getAddMaxEnchantLevel(tier) - 1;
        if (id == 1 && this.getNowLevel() > 1) {
            --this.nowLevel;
        } else if (id == 0 && maxLevel > this.getNowLevel()) {
            ++this.nowLevel;
        } else {
            return;
        }
        this.clickButton();
        this.sendPKT();
    }

    public void clearInfo() {
        this.isCraft = false;
        this.craftTime = 0;
        this.craftTick = 0;
        this.outStack = ItemStack.f_41583_;
        this.sendPKT();
    }

    public int getMaxEnchantLevel() {
        return this.getMaxEnchantLevel(this.getTier());
    }

    public int getMaxRwiteLevel(int maxLevel) {
        int tier = this.getTier();
        if (tier == 1) {
            return Math.min(3, maxLevel);
        }
        if (tier == 3) {
            return maxLevel * 2;
        }
        return Math.min(5, maxLevel);
    }

    public int getMaxEnchantLevel(int tier) {
        return switch (tier) {
            case 1 -> 3;
            case 2 -> 5;
            case 3 -> this.getWishMaxLevel();
            default -> 3;
        };
    }

    public int getAddMaxEnchantLevel() {
        return this.getAddMaxEnchantLevel(this.getTier());
    }

    public int getAddMaxEnchantLevel(int tier) {
        return switch (tier) {
            case 1 -> 3;
            case 2 -> 5;
            case 3 -> 6;
            default -> 3;
        };
    }

    public int getTier() {
        ItemStack stack = this.getBookItem();
        Item item = stack.m_41720_();
        if (item instanceof SMBook) {
            SMBook book = (SMBook)item;
            return Math.min(2, book.getTier());
        }
        if (stack.m_150930_(ItemInit.wish_crystal)) {
            return 3;
        }
        return 0;
    }

    public int getMaxLevel(int maxLevel) {
        return !this.getBookItem().m_150930_(ItemInit.wish_crystal) ? maxLevel : this.getWishMaxLevel();
    }

    public int getWishMaxLevel() {
        return switch (this.getBookItem().m_41613_()) {
            case 0 -> 0;
            case 1 -> 6;
            case 2 -> 7;
            case 3 -> 8;
            case 4 -> 9;
            default -> 10;
        };
    }

    public int getWishShirinCount() {
        return switch (this.nowLevel) {
            case 6 -> 1;
            case 7 -> 2;
            case 8 -> 3;
            case 9 -> 4;
            case 10 -> 5;
            default -> 1;
        };
    }

    public int getNowLevel() {
        return this.nowLevel;
    }

    @Override
    public int getMaxMF() {
        return this.maxMagiaFlux;
    }

    @Override
    public int getReceiveMF() {
        return 20000;
    }

    @Override
    public int getInvSize() {
        return 1;
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("bookInv", (Tag)this.bookInv.serializeNBT());
        tag.m_128365_("inputInv", (Tag)this.inputInv.serializeNBT());
        tag.m_128365_("outInv", (Tag)this.outInv.serializeNBT());
        tag.m_128379_("isCraft", this.isCraft);
        tag.m_128405_("craftTime", this.craftTime);
        tag.m_128405_("craftTick", this.craftTick);
        tag.m_128405_("nowLevel", this.nowLevel);
        tag.m_128365_("outPutStack", (Tag)this.outStack.m_41739_(new CompoundTag()));
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.bookInv.deserializeNBT(tag.m_128469_("bookInv"));
        this.inputInv.deserializeNBT(tag.m_128469_("inputInv"));
        this.outInv.deserializeNBT(tag.m_128469_("outInv"));
        this.isCraft = tag.m_128471_("isCraft");
        this.craftTime = tag.m_128451_("craftTime");
        this.craftTick = tag.m_128451_("craftTick");
        this.nowLevel = tag.m_128451_("nowLevel");
        this.outStack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("outPutStack"));
    }

    public IItemHandler getBook() {
        return this.bookInv;
    }

    public ItemStack getBookItem() {
        return this.getBook().getStackInSlot(0);
    }

    @Override
    public IItemHandler getInput() {
        return this.inputInv;
    }

    public ItemStack getInputItem() {
        return this.getInput().getStackInSlot(0);
    }

    public IItemHandler getOut() {
        return this.outInv;
    }

    public ItemStack getOutItem() {
        return this.getOut().getStackInSlot(0);
    }

    public int getCraftProgress(int value) {
        return this.getProgress(value, this.craftTime, 30);
    }

    public void spawnParticl() {
        BlockPos pos = this.m_58899_();
        for (int i = 0; i < this.craftTime / 6; ++i) {
            float randX = this.getRandFloat();
            float randY = this.getRandFloat();
            float randZ = this.getRandFloat();
            float x = (float)pos.m_123341_() + 0.5f + randX;
            float y = (float)pos.m_123342_() + 1.1f + randY;
            float z = (float)pos.m_123343_() + 0.5f + randZ;
            float xSpeed = -randX * 0.075f;
            float ySpeed = -randY * 0.075f;
            float zSpeed = -randZ * 0.075f;
            this.addParticle((ParticleOptions)ParticleInit.NORMAL, x, y, z, xSpeed, ySpeed, zSpeed);
        }
    }

    @Override
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new MagiaRewriteMenu(windowId, inv, this);
    }

    public List<ItemStack> getInvList() {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        this.addStackList(stackList, this.getInputItem());
        this.addStackList(stackList, this.getOutItem());
        this.addStackList(stackList, this.getBookItem());
        return stackList;
    }

    @Override
    public boolean isInfoEmpty() {
        return this.getInvList().isEmpty() && this.isMFEmpty();
    }
}

