/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.sm;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import sweetmagic.init.PotionInit;
import sweetmagic.init.TileInit;
import sweetmagic.init.tile.menu.MagicBarrierMenu;
import sweetmagic.init.tile.sm.TileAbstractSM;

public class TileMagicBarrier
extends TileAbstractSM {
    public int range = 32;

    public TileMagicBarrier(BlockPos pos, BlockState state) {
        super(TileInit.barrierGlass, pos, state);
    }

    public TileMagicBarrier(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void serverTick(Level world, BlockPos pos, BlockState state) {
        super.serverTick(world, pos, state);
        if (this.tickTime % 100 != 0) {
            return;
        }
        List<Player> playerList = this.getEntityList(Player.class, e -> e.m_6084_() && !e.m_7500_() && !e.m_5833_(), this.range);
        playerList.forEach(p -> this.addPotion((LivingEntity)p, PotionInit.non_destructive, 130, 0));
    }

    public void removeDestructive(Level world) {
        List<Player> playerList = this.getEntityList(Player.class, e -> e.m_6084_(), this.range * 2);
        playerList.forEach(p -> p.m_21195_(PotionInit.non_destructive));
    }

    public void clickButton(int id) {
        switch (id) {
            case 0: {
                this.setRange(Math.min(128, this.getRange() + 1));
                break;
            }
            case 1: {
                this.setRange(Math.max(1, this.getRange() - 1));
            }
        }
        this.sendPKT();
        this.clickButton();
    }

    public int getRange() {
        return this.range;
    }

    public void setRange(int range) {
        this.range = range;
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("range", this.getRange());
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.setRange(tag.m_128451_("range"));
    }

    @Override
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new MagicBarrierMenu(windowId, inv, this);
    }
}

