/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.sm;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import sweetmagic.init.BlockInit;
import sweetmagic.init.ItemInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.TileInit;
import sweetmagic.init.entity.monster.WitchCrystal;
import sweetmagic.init.entity.monster.boss.WindWitchMaster;
import sweetmagic.init.tile.sm.TileAbstractMagicianLectern;

public class TileMagicianLecternWind
extends TileAbstractMagicianLectern {
    private static final ItemStack ACCE = new ItemStack((ItemLike)ItemInit.wind_relief);

    public TileMagicianLecternWind(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public TileMagicianLecternWind(BlockPos pos, BlockState state) {
        super(TileInit.magicianLecternWind, pos, state);
    }

    @Override
    public void summonBoss(Level world, BlockPos pos, float addHealth) {
        int rate = this.isHard ? 5 : 3;
        WindWitchMaster entity = new WindWitchMaster(world);
        entity.m_146884_(pos.m_122013_(2).m_252807_());
        entity.m_21051_(Attributes.f_22276_).m_22100_((double)(entity.m_21233_() * addHealth));
        this.addPotion((LivingEntity)entity, PotionInit.resistance_blow, 99999, 4);
        if (this.isHard) {
            this.addPotion((LivingEntity)entity, MobEffects.f_19600_, 99999, 4);
            this.addPotion((LivingEntity)entity, PotionInit.reflash_effect, 99999, 0);
            entity.m_21051_(Attributes.f_22276_).m_22100_(900.0 * (double)addHealth);
        }
        List<Player> playerList = this.getPlayer(Player.class);
        entity.clearInfo();
        entity.setLectern(true);
        entity.setSpawnPos(pos.m_7494_());
        entity.m_21153_(entity.m_21233_());
        world.m_7967_((Entity)entity);
        for (int i = 0; i < playerList.size() * rate; ++i) {
            WitchCrystal crystal = new WitchCrystal(world);
            int setPosCount = 0;
            BlockPos targetPos = new BlockPos(pos.m_123341_() + this.getRand(this.rand, 16), pos.m_123342_(), pos.m_123343_() + this.getRand(this.rand, 16));
            while (!world.m_46859_(targetPos) && !world.m_8055_(targetPos).m_60713_(BlockInit.rune_character)) {
                targetPos = new BlockPos(targetPos.m_123341_() + this.getRand(this.rand, 3), targetPos.m_123342_(), targetPos.m_123343_() + this.getRand(this.rand, 3));
                if (setPosCount++ < 16) continue;
            }
            if (this.isHard) {
                crystal.m_21051_(Attributes.f_22276_).m_22100_(60.0);
                crystal.m_21153_(crystal.m_21233_());
            }
            crystal.m_6034_((double)targetPos.m_123341_() + 0.5, (double)targetPos.m_123342_() + 0.5, (double)targetPos.m_123343_() + 0.5);
            crystal.setOwnerID((LivingEntity)entity);
            world.m_7967_((Entity)crystal);
        }
        entity.setArmor(playerList.size() * rate);
        entity.setAetherBattier();
        this.boss = entity;
        this.sendPKT();
    }

    @Override
    public ItemStack getStack() {
        return ACCE;
    }

    @Override
    public String deadTip() {
        return "smDeadFire";
    }

    @Override
    public int getBattleLevel() {
        return 4;
    }

    @Override
    public int getMaxMF() {
        return 0;
    }
}

