/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.sm;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import sweetmagic.init.ParticleInit;
import sweetmagic.init.TileInit;
import sweetmagic.init.tile.menu.ParallelInterfereMenu;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileWoodChest;

public class TileParallelInterfere
extends TileWoodChest {
    public int time;
    public float flip;
    public float oFlip;
    public float flipT;
    public float flipA;
    public float open;
    public float oOpen;
    public float rot;
    public float oRot;
    public float tRot;
    private static final float PI = (float)Math.PI;
    public final TileAbstractSM.StackHandler inputInv = new TileAbstractSM.StackHandler(this.getInvSize());

    public TileParallelInterfere(BlockPos pos, BlockState state) {
        this(TileInit.parallelInterfere, pos, state);
    }

    public TileParallelInterfere(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.resolver = (TileAbstractSM)this.new TileAbstractSM.SingleHandlerProvider((IItemHandlerModifiable)this.inputInv, IN_OUT);
    }

    public TileAbstractSM.StackHandler getInputInv() {
        return this.inputInv;
    }

    @Override
    public void clientTick(Level world, BlockPos pos, BlockState state) {
        float f2;
        super.clientTick(world, pos, state);
        this.oOpen = this.open;
        this.oRot = this.rot;
        Player player = world.m_45924_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 3.0, false);
        if (player != null) {
            double x = player.m_20185_() - (double)pos.m_123341_() + 0.5;
            double z = player.m_20189_() - (double)pos.m_123343_() + 0.5;
            this.tRot = (float)Mth.m_14136_((double)z, (double)x);
            this.open += 0.1f;
            if (this.open < 0.5f || this.rand.nextInt(40) == 0) {
                float f1 = this.flipT;
                do {
                    this.flipT += (float)(this.rand.nextInt(4) - this.rand.nextInt(4));
                } while (f1 == this.flipT);
            }
            if (this.tickTime % 10 == 0) {
                this.spawnParticle(pos, this.rand);
            }
        } else {
            this.tRot += 0.02f;
            this.open -= 0.1f;
        }
        while (this.rot >= (float)Math.PI) {
            this.rot -= (float)Math.PI * 2;
        }
        while (this.rot < (float)(-Math.PI)) {
            this.rot += (float)Math.PI * 2;
        }
        while (this.tRot >= (float)Math.PI) {
            this.tRot -= (float)Math.PI * 2;
        }
        while (this.tRot < (float)(-Math.PI)) {
            this.tRot += (float)Math.PI * 2;
        }
        for (f2 = this.tRot - this.rot; f2 >= (float)Math.PI; f2 -= (float)Math.PI * 2) {
        }
        while (f2 < (float)(-Math.PI)) {
            f2 += (float)Math.PI * 2;
        }
        this.rot += f2 * 0.4f;
        this.open = Mth.m_14036_((float)this.open, (float)0.0f, (float)1.0f);
        ++this.time;
        this.oFlip = this.flip;
        float f = (this.flipT - this.flip) * 0.4f;
        f = Mth.m_14036_((float)f, (float)-0.2f, (float)0.2f);
        this.flipA += (f - this.flipA) * 0.9f;
        this.flip += this.flipA;
    }

    public void spawnParticle(BlockPos pos, Random rand) {
        float randX = this.getRandFloat(0.5f);
        float randZ = this.getRandFloat(0.5f);
        float x = (float)pos.m_123341_() + 0.5f + randX;
        float y = (float)pos.m_123342_() + 1.0f;
        float z = (float)pos.m_123343_() + 0.5f + randZ;
        float xSpeed = this.getRandFloat(0.05f);
        float ySpeed = 0.025f + rand.nextFloat() * 0.05f;
        float zSpeed = this.getRandFloat(0.05f);
        this.addParticle((ParticleOptions)ParticleInit.NORMAL, x, y, z, xSpeed, ySpeed, zSpeed);
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128391_(this.inputInv.serializeNBT());
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inputInv.deserializeNBT(tag);
    }

    @Override
    public int getInvSize() {
        return 540;
    }

    @Override
    public IItemHandler getInput() {
        return this.inputInv;
    }

    @Override
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new ParallelInterfereMenu(windowId, inv, this);
    }

    @Override
    public int getData() {
        return 1024;
    }
}

