/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.sm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import sweetmagic.api.iitem.IMagicBook;
import sweetmagic.api.iitem.IPorch;
import sweetmagic.api.iitem.IWand;
import sweetmagic.api.iitem.info.BookInfo;
import sweetmagic.api.iitem.info.PorchInfo;
import sweetmagic.api.iitem.info.WandInfo;
import sweetmagic.init.BlockInit;
import sweetmagic.init.ParticleInit;
import sweetmagic.init.SoundInit;
import sweetmagic.init.TagInit;
import sweetmagic.init.TileInit;
import sweetmagic.init.block.base.BaseMFBlock;
import sweetmagic.init.block.sm.ParallelInterfere;
import sweetmagic.init.tile.inventory.SMInventory;
import sweetmagic.init.tile.sm.TileSMMagic;
import sweetmagic.recipe.RecipeHelper;
import sweetmagic.recipe.pedal.PedalRecipe;
import sweetmagic.util.RenderUtil;

public class TilePedalCreate
extends TileSMMagic {
    public int maxMagiaFlux = 20000;
    private static final int MAX_CRAFT_TIME = 10;
    public int maxCrafttime = 10;
    public int craftTime = 0;
    public int nowTick = 0;
    public int amount = 0;
    public boolean isCraft = false;
    public boolean isHaveBlock = false;
    public boolean quickCraft = false;
    public List<ItemStack> craftList = new ArrayList<ItemStack>();
    public List<ItemStack> resultList = new ArrayList<ItemStack>();
    private static final List<RenderUtil.RGBColor> colorList = Arrays.asList(new RenderUtil.RGBColor(255, 138, 147), new RenderUtil.RGBColor(255, 196, 138), new RenderUtil.RGBColor(255, 255, 138), new RenderUtil.RGBColor(255, 138, 147), new RenderUtil.RGBColor(147, 255, 138), new RenderUtil.RGBColor(138, 183, 255), new RenderUtil.RGBColor(255, 138, 238));

    public TilePedalCreate(BlockPos pos, BlockState state) {
        super(TileInit.pedal, pos, state);
    }

    public TilePedalCreate(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void serverTick(Level world, BlockPos pos, BlockState state) {
        super.serverTick(world, pos, state);
        if (this.isCraft) {
            ++this.nowTick;
            this.sendPKT();
        }
        if (this.tickTime % 20 != 0 || !this.isCraft) {
            return;
        }
        if (++this.craftTime >= this.maxCrafttime) {
            for (ItemStack stack : this.resultList) {
                ItemEntity entity = new ItemEntity(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 2.0, (double)pos.m_123343_() + 0.5, stack.m_41777_());
                world.m_7967_((Entity)entity);
                entity.f_19854_ = 0.0;
                entity.f_19856_ = 0.0;
                entity.m_32064_();
            }
            this.craftFinish();
            this.clearInfo();
        } else {
            this.sendPKT();
            this.playSound(pos, SoundInit.MAGIC_CRAFT, 0.0625f, 1.0f);
        }
    }

    @Override
    public void clientTick(Level world, BlockPos pos, BlockState state) {
        super.clientTick(world, pos, state);
        if (this.tickTime % 20 != 0) {
            return;
        }
        this.isHaveBlock = this.getState(pos.m_7495_()).m_204336_(TagInit.AC_BLOCK);
        if (!this.isCraft) {
            return;
        }
        this.spawnParticle(world, pos);
    }

    public boolean checkBlock() {
        return this.getState(this.m_58899_().m_7495_()).m_204336_(TagInit.AC_BLOCK);
    }

    public MutableComponent checkCanCraft(List<ItemStack> stackList) {
        if (!this.checkBlock()) {
            return this.getTipArray(new Object[]{this.getText("pedastal_noblock"), ":", this.getNeedBlock().m_49954_().m_130940_(RED)});
        }
        Optional<PedalRecipe> recipeOp = PedalRecipe.getRecipe(this.m_58904_(), stackList);
        if (recipeOp.isEmpty()) {
            return this.getText("pedastal_norecipe");
        }
        PedalRecipe recipe = recipeOp.get();
        int needMF = recipe.getMFList().get(0);
        if (this.getMF() < needMF) {
            return this.getTipArray(new Object[]{this.getText("pedastal_nomf"), ":" + this.format(needMF)});
        }
        RecipeHelper.RecipeUtil recipeUtil = RecipeHelper.recipeSingleCraft(stackList, recipe);
        this.craftList = recipeUtil.getInputList();
        this.setCraftList(recipeUtil, needMF);
        return null;
    }

    public MutableComponent checkCanAllCraft(List<ItemStack> stackList) {
        if (!this.checkBlock()) {
            return this.getTipArray(new Object[]{this.getText("pedastal_noblock"), ":", this.getNeedBlock().m_49954_().m_130940_(RED)});
        }
        for (int i = 0; i < 8; ++i) {
            Optional<PedalRecipe> recipeOp = PedalRecipe.getRecipe(this.m_58904_(), stackList);
            if (recipeOp.isEmpty()) {
                return i > 0 ? null : this.getText("pedastal_norecipe");
            }
            PedalRecipe recipe = recipeOp.get();
            int needMF = recipe.getMFList().get(0);
            if (this.getMF() < needMF) {
                return i > 0 ? null : this.getTipArray(new Object[]{this.getText("pedastal_nomf"), ":" + this.format(needMF)});
            }
            RecipeHelper.RecipeUtil recipeUtil = RecipeHelper.recipeSingleCraft(stackList, recipe);
            this.craftList.addAll(recipeUtil.getInputList());
            this.setCraftList(recipeUtil, needMF);
        }
        return null;
    }

    public void setCraftList(RecipeHelper.RecipeUtil recipeUtil, int needMF) {
        Object invStackList2;
        this.setMF(this.getMF() - needMF);
        ArrayList resultList = new ArrayList();
        recipeUtil.getResultList().forEach(s -> resultList.add(s.m_41777_()));
        ItemStack inputStack = this.craftList.get(0);
        CompoundTag tags = inputStack.m_41783_();
        if (tags != null && inputStack.m_41720_() instanceof IWand) {
            IWand wand;
            List<Object> invStackList2 = new ArrayList();
            ItemStack outStack = (ItemStack)resultList.get(0);
            Item outItem = outStack.m_41720_();
            if (outItem instanceof IWand) {
                wand = (IWand)outItem;
                tags.m_128405_("slotCount", wand.getSlot());
                invStackList2 = wand.getMagicList(inputStack);
            }
            outStack.m_41751_(tags);
            if (outItem instanceof IWand) {
                wand = (IWand)outItem;
                SMInventory.SMWandInventory inv = new SMInventory.SMWandInventory(new WandInfo(outStack));
                inv.inv = new ItemStackHandler(wand.getSlot());
                for (int i = 0; i < invStackList2.size(); ++i) {
                    inv.insertItem(i, (ItemStack)invStackList2.get(i), false);
                }
                inv.writeBack();
            }
        } else if (tags != null && (invStackList2 = inputStack.m_41720_()) instanceof IMagicBook) {
            ItemStack oldBook;
            IMagicBook book = (IMagicBook)invStackList2;
            invStackList2 = new ArrayList();
            ItemStack outStack = (ItemStack)resultList.get(0);
            Item outItem = outStack.m_41720_();
            if (outItem instanceof IMagicBook) {
                IMagicBook wand = (IMagicBook)outItem;
                tags.m_128405_("slotCount", wand.getSlotSize());
                invStackList2 = wand.getInvList(new BookInfo(inputStack));
            }
            outStack.m_41751_(tags);
            if (outItem instanceof IMagicBook) {
                IMagicBook book2 = (IMagicBook)outItem;
                SMInventory.SMBookInventory inv = new SMInventory.SMBookInventory(new BookInfo(outStack));
                inv.inv = new ItemStackHandler(book2.getSlotSize());
                for (int i = 0; i < invStackList2.size(); ++i) {
                    inv.insertItem(i, (ItemStack)invStackList2.get(i), false);
                }
                inv.writeBack();
            }
            if (resultList.size() > 2 && !(oldBook = (ItemStack)resultList.get(1)).m_41619_()) {
                oldBook.m_41751_(new CompoundTag());
            }
        } else if (tags != null && (invStackList2 = inputStack.m_41720_()) instanceof IPorch) {
            IPorch porch = (IPorch)invStackList2;
            invStackList2 = new ArrayList();
            ItemStack outStack = (ItemStack)resultList.get(0);
            Item outItem = outStack.m_41720_();
            if (outItem instanceof IPorch) {
                IPorch porch2 = (IPorch)outItem;
                tags.m_128405_("slotCount", porch2.getSlotSize());
                invStackList2 = porch2.getStackList(inputStack);
            }
            outStack.m_41751_(tags);
            if (outItem instanceof IPorch) {
                IPorch wand = (IPorch)outItem;
                SMInventory.SMPorchInventory inv = new SMInventory.SMPorchInventory(new PorchInfo(outStack));
                inv.inv = new ItemStackHandler(wand.getSlotSize());
                for (int i = 0; i < invStackList2.size(); ++i) {
                    inv.insertItem(i, (ItemStack)invStackList2.get(i), false);
                }
                inv.writeBack();
            }
        } else if (tags != null && (invStackList2 = inputStack.m_41720_()) instanceof BlockItem) {
            BaseMFBlock mfBlock;
            BlockItem bItem = (BlockItem)invStackList2;
            Block outItem = bItem.m_40614_();
            if (outItem instanceof BaseMFBlock && (mfBlock = (BaseMFBlock)outItem).keepTileInfo()) {
                mfBlock.inheritingNBT(inputStack, (ItemStack)resultList.get(0));
            } else {
                outItem = bItem.m_40614_();
                if (outItem instanceof ParallelInterfere) {
                    ParallelInterfere parallel = (ParallelInterfere)outItem;
                    parallel.inheritingNBT(inputStack, (ItemStack)resultList.get(0));
                } else {
                    ItemStack outStack = (ItemStack)resultList.get(0);
                    outStack.m_41751_(tags);
                }
            }
        } else if (tags != null) {
            ItemStack outStack = (ItemStack)resultList.get(0);
            outStack.m_41751_(tags);
        }
        this.resultList.addAll(resultList);
    }

    public void craftStart() {
        this.isCraft = true;
        this.nowTick = 0;
        this.tickTime = 0;
        this.maxCrafttime = this.quickCraft ? 5 : 10;
        this.sendPKT();
        this.playSound(this.m_58899_(), SoundInit.MAGIC_CRAFT, 0.1f, 1.0f);
    }

    public void craftFinish() {
        this.isCraft = false;
        this.playSound(this.m_58899_(), SoundEvents.f_12275_, 0.5f, 1.0f);
        this.m_58904_().m_46796_(2003, this.m_58899_().m_6630_(2), 0);
        this.sendPKT();
    }

    public void clearInfo() {
        this.amount = 0;
        this.craftTime = 0;
        this.nowTick = 0;
        this.maxCrafttime = 10;
        this.isCraft = false;
        this.quickCraft = false;
        this.craftList.clear();
        this.resultList.clear();
        this.sendPKT();
    }

    public void spawnParticle(Level world, BlockPos pos) {
        float posX = (float)pos.m_123341_() + 0.5f;
        float posY = (float)pos.m_123342_() + 0.5f;
        float posZ = (float)pos.m_123343_() + 0.5f;
        float rate = this.quickCraft ? 2.0f : 1.0f;
        for (int k = 0; k <= 4; ++k) {
            float f1 = posX - 0.5f + this.rand.nextFloat();
            float f2 = posY + 0.85f + this.rand.nextFloat() * 0.75f + (float)this.nowTick * 0.00375f * rate;
            float f3 = posZ - 0.5f + this.rand.nextFloat();
            world.m_6493_((ParticleOptions)ParticleInit.TWILIGHTLIGHT, true, (double)f1, (double)f2, (double)f3, 0.0, 0.0, 0.0);
            float f4 = posX - 0.5f + this.rand.nextFloat();
            float f5 = posY + 0.35f + this.rand.nextFloat() * 0.75f + (float)this.nowTick * 0.003875f * rate;
            float f6 = posZ - 0.5f + this.rand.nextFloat();
            RenderUtil.RGBColor color = colorList.get(this.rand.nextInt(colorList.size()));
            world.m_6493_((ParticleOptions)ParticleInit.LAY, true, (double)f4, (double)f5, (double)f6, (double)color.red(), (double)color.green(), (double)color.blue());
        }
    }

    public void spawnParticleRing(Level world, double x, double y, double z, double vecX, double vecY, double vecZ, double step) {
        double spped = 0.1;
        for (double degree = 0.0; degree < Math.PI * 2; degree += step) {
            world.m_6493_((ParticleOptions)ParticleInit.NORMAL, true, x + Math.cos(degree), y, z + Math.sin(degree), -Math.cos(degree) * spped, vecY, -Math.sin(degree) * spped);
        }
    }

    public List<ItemStack> getDropList() {
        return this.craftList;
    }

    public int getMaxCookTime() {
        return this.maxCrafttime;
    }

    public int getCookTime() {
        return this.craftTime;
    }

    public Block getNeedBlock() {
        return BlockInit.aethercrystal_block;
    }

    @Override
    public int getMaxMF() {
        return this.maxMagiaFlux;
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128379_("isCraft", this.isCraft);
        tag.m_128379_("quickCraft", this.quickCraft);
        tag.m_128405_("craftTime", this.craftTime);
        tag.m_128405_("maxCrafttime", this.maxCrafttime);
        tag.m_128405_("nowTick", this.nowTick);
        tag.m_128405_("amount", this.amount);
        this.saveStackList(tag, this.craftList, "craftList");
        this.saveStackList(tag, this.resultList, "resultList");
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.isCraft = tag.m_128471_("isCraft");
        this.quickCraft = tag.m_128471_("quickCraft");
        this.craftTime = tag.m_128451_("craftTime");
        this.maxCrafttime = tag.m_128451_("maxCrafttime");
        this.nowTick = tag.m_128451_("nowTick");
        this.amount = tag.m_128451_("amount");
        this.craftList = this.loadAllStack(tag, "craftList");
        this.resultList = this.loadAllStack(tag, "resultList");
    }

    @Override
    public IItemHandler getInput() {
        return null;
    }
}

