/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.sm;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.state.BlockState;
import sweetmagic.init.TileInit;
import sweetmagic.init.tile.menu.RegisterMenu;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.util.PlayerHelper;

public class TileRegister
extends TileAbstractSM {
    public int exp;

    public TileRegister(BlockPos pos, BlockState state) {
        super(TileInit.register, pos, state);
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("exp", this.exp);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.exp = tag.m_128451_("exp");
    }

    public int getExpForLevel(int level) {
        return PlayerHelper.getExpForLevel(Math.max(0, level));
    }

    public int getExpLevel() {
        return this.getExpLevel(this.exp);
    }

    public int getExpLevel(int exp) {
        return PlayerHelper.getLevelForExperience(exp);
    }

    public void addButton(Player player, int id) {
        if (!this.isSever()) {
            return;
        }
        this.clickButton();
        int playerExp = player.f_36079_;
        if (playerExp <= 0 && id >= 3) {
            return;
        }
        int addValue = 0;
        int playerLevel = player.f_36078_;
        switch (id) {
            case 0: {
                addValue = -1;
                break;
            }
            case 1: {
                addValue = -10;
                break;
            }
            case 2: {
                addValue = -64;
                break;
            }
            case 3: {
                addValue = 1;
                break;
            }
            case 4: {
                addValue = 10;
                break;
            }
            case 5: {
                addValue = 64;
            }
        }
        if (addValue > 0) {
            int nowLevel = this.getExpForLevel(playerLevel);
            int shrinkExp = (int)((float)(nowLevel - this.getExpForLevel(playerLevel - addValue)) + player.f_36080_ * (float)(this.getExpForLevel(playerLevel + 1) - nowLevel));
            PlayerHelper.addExp(player, -shrinkExp);
            this.exp += shrinkExp;
        } else {
            int nowLevel = this.getExpForLevel(playerLevel);
            int addExp = (int)Math.min((float)this.exp, (float)(this.getExpForLevel(playerLevel - addValue) - nowLevel) - player.f_36080_ * (float)(this.getExpForLevel(playerLevel + 1) - nowLevel));
            PlayerHelper.addExp(player, addExp);
            this.exp -= addExp;
        }
        this.sendPKT();
    }

    @Override
    public boolean isInfoEmpty() {
        return this.exp <= 0;
    }

    @Override
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new RegisterMenu(windowId, inv, this);
    }
}

