/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.sm;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import sweetmagic.api.ientity.ISMMob;
import sweetmagic.init.ParticleInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.TileInit;
import sweetmagic.init.entity.monster.ArchSpider;
import sweetmagic.init.entity.monster.BlazeTempest;
import sweetmagic.init.entity.monster.CreeperCalamity;
import sweetmagic.init.entity.monster.DwarfZombie;
import sweetmagic.init.entity.monster.EnderMage;
import sweetmagic.init.entity.monster.SkullFlame;
import sweetmagic.init.entity.monster.SkullFrost;
import sweetmagic.init.entity.monster.boss.AbstractSMBoss;
import sweetmagic.init.tile.menu.SMSpawnerMenu;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.util.WorldHelper;

public class TileSMSpawner
extends TileAbstractSM {
    private int range = 4;
    private int mobLevel = 1;
    private int mobType = 0;
    protected LivingEntity entity = null;
    private int spawnTick = 0;
    private int maxSpawnTick = 0;
    public boolean randFlag = false;
    public boolean isPlayer = false;
    public boolean isPeace = false;
    private static final int MAX_SPAWNTICK = 15;
    private static final int RAND_SPAWNTICK = 8;
    private static final int MAX_SPAWNCOUNT = 5;

    public TileSMSpawner(BlockPos pos, BlockState state) {
        super(TileInit.smSpawner, pos, state);
    }

    public TileSMSpawner(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void serverTick(Level world, BlockPos pos, BlockState state) {
        super.serverTick(world, pos, state);
        if (this.tickTime % 10 != 0 || this.isPeaceful(world)) {
            return;
        }
        if (this.maxSpawnTick == 0) {
            this.maxSpawnTick = this.rand.nextInt(8) + 15;
        }
        if (!this.checkTick()) {
            return;
        }
        this.spawnEntity(world, pos);
    }

    @Override
    public void clientTick(Level world, BlockPos pos, BlockState state) {
        super.clientTick(world, pos, state);
        if (this.tickTime % 10 != 0) {
            return;
        }
        this.isPeace = this.isPeaceful(world);
        if (this.isPeace) {
            return;
        }
        this.isPlayer = this.checkPlayer(world, 16.0);
    }

    public boolean checkTick() {
        return this.spawnTick++ >= this.maxSpawnTick;
    }

    public void spawnEntity(Level world, BlockPos pos) {
        this.clearInfo();
        if (this.getMobType() == -1 && this.checkPlayer(world, 48.0)) {
            this.setMobType();
        }
        this.doSpawnEntity(world, pos, this.rand);
    }

    public void setMobType() {
        this.setMobType(this.rand.nextInt(this.maxMobType()));
        this.randFlag = true;
    }

    public void doSpawnEntity(Level world, BlockPos pos, Random rand) {
        int i;
        ServerLevel server;
        block9: {
            block8: {
                if (!(world instanceof ServerLevel)) break block8;
                server = (ServerLevel)world;
                if (this.checkPlayer(world, this.getRange() * 2)) break block9;
            }
            return;
        }
        int maxCount = this.getRange() * this.getRange();
        String uniqueName = this.getUniqueTagName();
        int entityListSize = this.getEntityList(LivingEntity.class, e -> e.m_6084_() && e.getPersistentData().m_128471_(uniqueName), this.getRange() * 4).size();
        int canSpawnCount = 5 - entityListSize;
        if (canSpawnCount <= 0) {
            return;
        }
        canSpawnCount = canSpawnCount == 0 ? 0 : Math.min(canSpawnCount, rand.nextInt(canSpawnCount) + 1);
        for (i = 0; i < canSpawnCount; ++i) {
            int count = 0;
            BlockPos summonPos = WorldHelper.offset(pos, this.getRand(rand, this.getRange()), 1.0, this.getRand(rand, this.getRange()));
            while (!this.checkAABB(world, summonPos)) {
                summonPos = WorldHelper.offset(pos, this.getRand(rand, this.getRange()), 1.0, this.getRand(rand, this.getRange()));
                if (count++ <= maxCount) continue;
            }
            Mob entity = this.getEntity();
            entity.m_146884_(summonPos.m_252807_());
            entity.getPersistentData().m_128379_(uniqueName, true);
            this.setEntityBuff(entity);
            world.m_7967_((Entity)entity);
            entity.m_21373_();
        }
        if (canSpawnCount <= 0) {
            return;
        }
        for (i = 0; i < 16; ++i) {
            float x = (float)pos.m_123341_() + 0.5f + (rand.nextFloat() * 0.5f + 1.0f) * (rand.nextBoolean() ? 1.0f : -1.0f);
            float y = (float)pos.m_123342_() + rand.nextFloat() * 0.5f + 0.25f;
            float z = (float)pos.m_123343_() + 0.5f + (rand.nextFloat() * 0.5f + 1.0f) * (rand.nextBoolean() ? 1.0f : -1.0f);
            float aX = this.getRand(rand) * 0.1f;
            float aY = rand.nextFloat() * 0.15f;
            float aZ = this.getRand(rand) * 0.1f;
            server.m_8767_((ParticleOptions)ParticleInit.NORMAL, (double)x, (double)y, (double)z, 0, (double)aX, (double)aY, (double)aZ, 1.0);
        }
    }

    public void startInfo(AbstractSMBoss mob) {
    }

    public boolean checkPlayer(Level world, double range) {
        return !this.getEntityListHalf(Player.class, e -> e.m_6084_() && !e.m_7500_() && !e.m_5833_(), Math.max(16.0, range)).isEmpty();
    }

    public int getRand(Random rand, int range) {
        return rand.nextInt(range) - rand.nextInt(range);
    }

    public float getRand(Random rand) {
        return rand.nextFloat() - rand.nextFloat();
    }

    public void clearInfo() {
        this.maxSpawnTick = this.rand.nextInt(8) + 15;
        this.tickTime = 0;
        this.spawnTick = 0;
        this.sendPKT();
    }

    public void clickButton(int id) {
        switch (id) {
            case 0: {
                this.setRange(Math.min(16, this.getRange() + 1));
                break;
            }
            case 1: {
                this.setRange(Math.max(1, this.getRange() - 1));
                break;
            }
            case 2: {
                this.setMobLevel(Math.min(10, this.getMobLevel() + 1));
                break;
            }
            case 3: {
                this.setMobLevel(Math.max(1, this.getMobLevel() - 1));
                break;
            }
            case 4: {
                this.setMobType(Math.min(this.maxMobType() - 1, this.getMobType() + 1));
                break;
            }
            case 5: {
                this.setMobType(Math.max(-1, this.getMobType() - 1));
            }
        }
        this.sendPKT();
        this.clickButton();
        if (id >= 4) {
            this.buttonEntity();
        }
    }

    public void buttonEntity() {
        this.entity = this.getEntity();
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("range", this.getRange());
        tag.m_128405_("mobLevel", this.getMobLevel());
        tag.m_128405_("mobType", this.getMobType());
        tag.m_128405_("spawnTick", this.spawnTick);
        tag.m_128405_("maxSpawnTick", this.maxSpawnTick);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.setRange(tag.m_128451_("range"));
        this.setMobLevel(tag.m_128451_("mobLevel"));
        this.setMobType(tag.m_128451_("mobType"));
        this.spawnTick = tag.m_128451_("spawnTick");
        this.maxSpawnTick = tag.m_128451_("maxSpawnTick");
    }

    public int getRange() {
        return this.range;
    }

    public void setRange(int range) {
        this.range = range;
    }

    public int getMobLevel() {
        return this.mobLevel;
    }

    public void setMobLevel(int level) {
        this.mobLevel = level;
    }

    public int getMobType() {
        return this.mobType;
    }

    public void setMobType(int mobType) {
        this.mobType = mobType;
    }

    public LivingEntity getRenderEntity() {
        if (this.entity == null) {
            this.entity = this.getEntity();
        }
        return this.entity;
    }

    public Mob getEntity() {
        Level world = this.m_58904_();
        ISMMob entity = null;
        switch (this.getMobType()) {
            case 0: {
                entity = new SkullFrost(world);
                entity.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
                break;
            }
            case 1: {
                entity = new EnderMage(world);
                break;
            }
            case 2: {
                entity = new BlazeTempest(world);
                break;
            }
            case 3: {
                entity = new ArchSpider(world);
                break;
            }
            case 4: {
                entity = new CreeperCalamity(world);
                break;
            }
            case 5: {
                entity = new SkullFlame(world);
                entity.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
                break;
            }
            case 6: {
                entity = new DwarfZombie(world);
            }
        }
        return entity;
    }

    public int maxMobType() {
        return 7;
    }

    public String getEntityName() {
        if (this.getMobType() == -1) {
            return "random";
        }
        return this.getRenderEntity().m_7755_().getString();
    }

    public void setEntityBuff(Mob entity) {
        int level = this.getMobLevel() - 1;
        this.addPotion((LivingEntity)entity, PotionInit.resistance_blow, 99999, 5);
        if (level <= 1) {
            return;
        }
        float rate = 1.0f * (float)level * 0.5f;
        entity.m_21051_(Attributes.f_22276_).m_22100_((double)(entity.m_21233_() * rate));
        entity.m_21153_(entity.m_21233_());
        this.addPotion((LivingEntity)entity, MobEffects.f_19600_, 99999, level / 2);
        this.addPotion((LivingEntity)entity, PotionInit.aether_barrier, 99999, level / 2);
    }

    public String getUniqueTagName() {
        BlockPos pos = this.m_58899_();
        return pos.m_123341_() + "_" + pos.m_123342_() + "_" + pos.m_123343_();
    }

    @Override
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new SMSpawnerMenu(windowId, inv, this);
    }
}

