/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.sm;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import sweetmagic.api.iblock.ITileFluid;
import sweetmagic.init.TileInit;
import sweetmagic.init.fluid.FluidTankHandler;
import sweetmagic.init.tile.sm.TileAbstractSM;

public class TileSink
extends TileAbstractSM
implements ITileFluid {
    private static final int MAX_FLUID_VALUE = 1000;
    public FluidStack fluid = new FluidStack(Fluids.f_76191_, 0);
    protected final FluidTankHandler.TankProperty fluidPro;
    public LazyOptional<IFluidHandler> fluidHandler = LazyOptional.of(() -> this.createFluidHandler());

    public TileSink(BlockPos pos, BlockState state) {
        this(TileInit.sink, pos, state);
    }

    public TileSink(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.fluidPro = new FluidTankHandler.TankProperty(1000, true, true);
    }

    @Override
    public void serverTick(Level level, BlockPos pos, BlockState state) {
        super.serverTick(level, pos, state);
        if (this.tickTime % 10 != 0 || this.isRSPower()) {
            return;
        }
        if (!this.isMaxFluid()) {
            this.fillWater();
        }
    }

    public void fillWater() {
        this.setContent(new FluidStack((Fluid)Fluids.f_76193_, 1000));
    }

    @Override
    public int fluidTanks() {
        return 1;
    }

    @Override
    public IFluidHandler createFluidHandler() {
        return new FluidTankHandler(this);
    }

    @Override
    public void setContent(FluidStack fluid) {
        this.fluid = fluid;
        this.m_6596_();
    }

    @Override
    public FluidTankHandler.TankProperty getTank() {
        return this.fluidPro;
    }

    @Override
    public FluidStack getContent() {
        return this.fluid;
    }

    @Override
    public void setAmount(int amount) {
        this.fluid.setAmount(amount);
    }

    @Override
    public int getFluidValue() {
        return this.getContent().getAmount();
    }

    @Override
    public void sendData() {
        this.sendInfo();
    }

    public LazyOptional<IFluidHandler> getFluidHandler() {
        return this.fluidHandler;
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction face) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.getFluidHandler();
        }
        return super.getCapability(cap, face);
    }

    public void m_7651_() {
        super.m_7651_();
        if (this.getFluidHandler() != null) {
            this.getFluidHandler().invalidate();
        }
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        CompoundTag fluidNBT = new CompoundTag();
        this.getContent().writeToNBT(fluidNBT);
        tag.m_128365_("fluid", (Tag)fluidNBT);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.setContent(FluidStack.loadFluidStackFromNBT((CompoundTag)tag.m_128469_("fluid")));
    }

    @Override
    public int getMaxFuildValue() {
        return 1000;
    }

    @Override
    public boolean isInfoEmpty() {
        return this.getContent().isEmpty();
    }
}

