/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.sm;

import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import sweetmagic.api.ientity.ISMMob;
import sweetmagic.config.SMConfig;
import sweetmagic.init.ItemInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.SoundInit;
import sweetmagic.init.TileInit;
import sweetmagic.init.block.magic.SpawnCrystal;
import sweetmagic.init.entity.animal.AbstractSummonMob;
import sweetmagic.init.entity.monster.ArchSpider;
import sweetmagic.init.entity.monster.BlazeTempest;
import sweetmagic.init.entity.monster.DwarfZombie;
import sweetmagic.init.entity.monster.ElectricCube;
import sweetmagic.init.entity.monster.EnderMage;
import sweetmagic.init.entity.monster.SkullFlame;
import sweetmagic.init.entity.monster.SkullFrost;
import sweetmagic.init.tile.menu.SpawnCrystalMenu;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.util.WorldHelper;

public class TileSpawnCrystal
extends TileAbstractSM {
    public int range = 7;

    public TileSpawnCrystal(BlockPos pos, BlockState state) {
        super(TileInit.spawn_crystal, pos, state);
    }

    public TileSpawnCrystal(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void serverTick(Level world, BlockPos pos, BlockState state) {
        super.serverTick(world, pos, state);
        if (this.tickTime % 10 != 0 || this.isPeaceful(world)) {
            return;
        }
        List<Player> playerList = this.getEntityListUp(Player.class, e -> e.m_6084_() && !e.m_7500_() && !e.m_5833_(), this.range);
        if (playerList.isEmpty()) {
            return;
        }
        SpawnCrystal crystal = (SpawnCrystal)this.getBlock(pos);
        int data = crystal.getData();
        this.spawnMob(world, pos, data);
    }

    public void spawnMob(Level world, BlockPos pos, int data) {
        int count = 0;
        int maxCount = this.range * this.range / 2;
        Random rand = this.rand;
        float maxDay = (float)((Integer)SMConfig.spawnDate.get()).intValue() * 2.0f;
        float day = 1.0f - Math.min(1.0f, (float)world.m_8044_() / 24000.0f / maxDay);
        boolean isFirst = world.m_46472_() == Level.f_46428_ && data <= 2;
        int debuffLevel = isFirst ? (int)(4.0f * day) : 0;
        int spawnMobType = rand.nextInt(7);
        int summonSize = this.getSummonSize(data);
        int playerAllListSize = this.getEntityList(Player.class, e -> e.m_6084_() && !e.m_7500_() && !e.m_5833_(), 80.0).size() - 1;
        if (playerAllListSize > 0) {
            summonSize = (int)((float)summonSize * (1.0f + (float)playerAllListSize * 0.5f));
        }
        int summonMobSize = this.getEntityList(AbstractSummonMob.class, e -> e.m_6084_(), 80.0).size();
        float addHealth = 1.0f + (float)summonMobSize * 0.05f;
        for (int i = 0; i < summonSize; ++i) {
            boolean isZero = i % this.getSummonSize(data) == 0;
            BlockPos secondPos = new BlockPos(pos.m_123341_() + this.getRand(rand, 3), pos.m_123342_(), pos.m_123343_() + this.getRand(rand, 3));
            count = 0;
            while (!this.checkAABB(world, secondPos)) {
                secondPos = new BlockPos(pos.m_123341_() + this.getRand(rand, 3), pos.m_123342_(), pos.m_123343_() + this.getRand(rand, 3));
                if (count++ < maxCount / 2) continue;
            }
            LivingEntity entity = isZero ? this.setBigMob(world, spawnMobType, data, addHealth) : this.setMob(world, spawnMobType, data, addHealth);
            entity.m_146884_(secondPos.m_252807_());
            world.m_7967_((Entity)entity);
            ((ISMMob)entity).refreshInfo();
            if (debuffLevel <= 0) continue;
            this.addPotion(entity, MobEffects.f_19613_, 99999, debuffLevel);
        }
        world.m_46961_(pos, false);
        world.m_7471_(pos, false);
        this.playSound(pos, SoundInit.HORAMAGIC, 0.15f, 1.0f);
    }

    public LivingEntity setMob(Level world, int spawnMobType, int data, float addHealth) {
        ISMMob entity = null;
        switch (spawnMobType) {
            case 0: {
                entity = new BlazeTempest(world);
                break;
            }
            case 1: {
                entity = new EnderMage(world);
                entity.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
                break;
            }
            case 2: {
                entity = new SkullFrost(world);
                entity.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
                break;
            }
            case 3: {
                entity = new ArchSpider(world);
                break;
            }
            case 4: {
                entity = new ElectricCube(world);
                ((ElectricCube)entity).setSize(4);
                ((ElectricCube)entity).setFixed();
                break;
            }
            case 5: {
                entity = new SkullFlame(world);
                entity.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
                break;
            }
            case 6: {
                entity = new DwarfZombie(world);
                entity.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ItemInit.alt_pick));
            }
        }
        entity.m_21051_(Attributes.f_22276_).m_22100_(this.getMobHealth(data) * (double)addHealth);
        entity.m_21153_(entity.m_21233_());
        this.setMobBuff((LivingEntity)entity, data);
        return entity;
    }

    public LivingEntity setBigMob(Level world, int spawnMobType, int data, float addHealth) {
        ISMMob entity = null;
        switch (spawnMobType) {
            case 0: {
                entity = new BlazeTempest(world);
                break;
            }
            case 1: {
                entity = new EnderMage(world);
                entity.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
                break;
            }
            case 2: {
                entity = new SkullFrost(world);
                entity.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
                entity.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_42472_));
                break;
            }
            case 3: {
                entity = new ArchSpider(world);
                break;
            }
            case 4: {
                entity = new ElectricCube(world);
                ((ElectricCube)entity).setSize(8);
                ((ElectricCube)entity).setFixed();
                this.addPotion((LivingEntity)entity, PotionInit.leader_flag, 99999, 0);
                break;
            }
            case 5: {
                entity = new SkullFlame(world);
                entity.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
                break;
            }
            case 6: {
                entity = new DwarfZombie(world);
                entity.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ItemInit.alt_pick));
            }
        }
        entity.m_21051_(Attributes.f_22276_).m_22100_(this.getBigMobHealth(data) * (double)addHealth);
        entity.m_21153_(entity.m_21233_());
        this.setBigMobBuff((LivingEntity)entity, data);
        return entity;
    }

    public int getRand(Random rand, int range) {
        return rand.nextInt(range) - rand.nextInt(range);
    }

    public int getSummonSize(int data) {
        return switch (data) {
            case 1 -> 6;
            case 2 -> 8;
            case 3 -> 9;
            case 4 -> 10;
            case 5 -> 12;
            default -> 4;
        };
    }

    public double getMobHealth(int data) {
        return switch (data) {
            case 1 -> 50.0;
            case 2 -> 70.0;
            case 3 -> 100.0;
            case 4 -> 120.0;
            case 5 -> 160.0;
            default -> 30.0;
        };
    }

    public void setMobBuff(LivingEntity entity, int data) {
        this.addPotion(entity, PotionInit.resistance_blow, 99999, 5);
        if (data >= 1) {
            this.addPotion(entity, MobEffects.f_19600_, 99999, data);
            this.addPotion(entity, PotionInit.aether_barrier, 4800, data);
        }
    }

    public void setBigMobBuff(LivingEntity entity, int data) {
        this.addPotion(entity, PotionInit.leader_flag, 99999, 0);
        this.addPotion(entity, PotionInit.resistance_blow, 99999, 5);
        this.addPotion(entity, MobEffects.f_19600_, 99999, data * 2);
    }

    public double getBigMobHealth(int data) {
        return switch (data) {
            case 1 -> 120.0;
            case 2 -> 150.0;
            case 3 -> 170.0;
            case 4 -> 200.0;
            case 5 -> 240.0;
            default -> 70.0;
        };
    }

    @Override
    public AABB getAABB(double x, double y, double z) {
        BlockPos pos = this.m_58899_();
        return new AABB(WorldHelper.offset(pos, -x, 0.0, -z), WorldHelper.offset(pos, x, y, z));
    }

    @Override
    public boolean checkAABB(Level world, BlockPos pos) {
        BlockState underState = world.m_8055_(pos.m_6625_(2));
        VoxelShape underAABB = underState.m_60734_().m_7947_(underState, (BlockGetter)world, pos.m_7495_());
        return super.checkAABB(world, pos) && underAABB.equals(Shapes.m_83040_());
    }

    public void clickButton(int id) {
        switch (id) {
            case 0: {
                this.setRange(Math.min(16, this.getRange() + 1));
                break;
            }
            case 1: {
                this.setRange(Math.max(1, this.getRange() - 1));
            }
        }
        this.sendPKT();
        this.clickButton();
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("range", this.getRange());
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("range")) {
            this.setRange(tag.m_128451_("range"));
        }
    }

    public int getRange() {
        return this.range;
    }

    public void setRange(int range) {
        this.range = range;
    }

    @Override
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new SpawnCrystalMenu(windowId, inv, this);
    }
}

