/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.sm;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.IItemHandler;
import sweetmagic.init.ParticleInit;
import sweetmagic.init.TileInit;
import sweetmagic.init.item.magic.MFTeleport;
import sweetmagic.init.tile.menu.TransferGateVerticalMenu;
import sweetmagic.init.tile.sm.TileAbstractSM;

public class TileTransferGateVertical
extends TileAbstractSM {
    protected final TileAbstractSM.StackHandler inputInv = (TileAbstractSM)this.new TileAbstractSM.StackHandler(1, 1);

    public TileTransferGateVertical(BlockPos pos, BlockState state) {
        super(TileInit.transferGateVertical, pos, state);
    }

    public TileTransferGateVertical(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void clientTick(Level world, BlockPos pos, BlockState state) {
        super.clientTick(world, pos, state);
        if (this.rand.nextFloat() >= 0.67f || this.isAir()) {
            return;
        }
        this.clientEffect(world, pos);
    }

    public void clientEffect(Level world, BlockPos pos) {
        Direction face = this.getFaceVertical();
        float x = 0.5f + (float)pos.m_123341_() + this.getRandFloat(1.65f);
        float y = pos.m_123342_();
        float z = 0.5f + (float)pos.m_123343_() + this.getRandFloat(1.65f);
        float xSpeed = 0.0f;
        float ySpeed = this.getRandFloat(0.05f);
        float zSpeed = 0.0f;
        switch (face) {
            case DOWN: {
                y += 2.0f;
                ySpeed = -this.getRandFloat(0.25f) - 0.25f;
                break;
            }
            case UP: {
                y -= 0.5f;
                ySpeed = this.getRandFloat(0.25f) + 0.25f;
            }
        }
        world.m_7106_((ParticleOptions)ParticleInit.DIVINE, (double)x, (double)y, (double)z, (double)xSpeed, (double)ySpeed, (double)zSpeed);
    }

    public Direction getFaceVertical() {
        BlockState state = this.getState(this.m_58899_());
        return !state.m_61138_((Property)BlockStateProperties.f_61372_) ? Direction.NORTH : (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
    }

    public boolean doTereport(LivingEntity entity) {
        ItemStack stack = this.getInputItem();
        if (stack.m_41619_() || !(stack.m_41720_() instanceof MFTeleport)) {
            return false;
        }
        CompoundTag tags = stack.m_41783_();
        if (tags == null || !tags.m_128441_("pX")) {
            return false;
        }
        if (entity.m_20194_() != null && entity instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)entity;
            if (!entity.m_20092_()) {
                Level level = this.m_58904_();
                if (level instanceof ServerLevel) {
                    ServerLevel ser = (ServerLevel)level;
                    double range = 0.875;
                    double ySpeed = -2.0;
                    for (int i = -1; i < 5; ++i) {
                        this.spawnParticleRing(ser, (ParticleOptions)ParticleTypes.f_123760_, range, entity.m_20183_().m_6630_(1), (double)i / 3.0, ySpeed, 1.0);
                    }
                }
                BlockPos pos = new BlockPos(tags.m_128451_("pX"), tags.m_128451_("pY") + 1, tags.m_128451_("pZ"));
                ResourceLocation dim = new ResourceLocation(tags.m_128461_("dim"));
                ServerLevel server = sp.m_20194_().m_129880_(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)dim));
                sp.m_8999_(server, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, 0.0f, 0.0f);
                entity.m_287199_(50);
                sp.m_6756_(0);
                entity.f_19789_ = 0.0f;
                double range = 0.875;
                double ySpeed = 1.0;
                for (int i = -1; i < 5; ++i) {
                    this.spawnParticleRing(server, (ParticleOptions)ParticleTypes.f_123760_, range, pos.m_6625_(2), (double)i / 3.0, ySpeed, 1.0);
                }
                this.playSound((Level)server, pos, SoundEvents.f_11852_, 1.0f, 1.0f);
            }
        }
        return true;
    }

    public IItemHandler getInput() {
        return this.inputInv;
    }

    public ItemStack getInputItem() {
        return this.getInput().getStackInSlot(0);
    }

    @Override
    public boolean isInfoEmpty() {
        return this.getInputItem().m_41619_();
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("handInv", (Tag)this.inputInv.serializeNBT());
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inputInv.deserializeNBT(tag.m_128469_("handInv"));
    }

    @Override
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new TransferGateVerticalMenu(windowId, inv, this);
    }
}

