/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.sm;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import sweetmagic.init.TileInit;
import sweetmagic.init.block.sm.WoodChest;
import sweetmagic.init.tile.menu.WoodChestMenu;
import sweetmagic.init.tile.sm.TileAbstractSM;

public class TileWoodChest
extends TileAbstractSM {
    public int count = 4;
    public float chance = 0.825f;
    public ResourceLocation lootTable = null;
    public final TileAbstractSM.StackHandler inputInv = (TileAbstractSM)this.new TileAbstractSM.StackHandler(this.getInvSize(), true);

    public TileWoodChest(BlockPos pos, BlockState state) {
        this(TileInit.woodChest, pos, state);
    }

    public TileWoodChest(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.resolver = (TileAbstractSM)this.new TileAbstractSM.SingleHandlerProvider((IItemHandlerModifiable)this.inputInv, IN_OUT);
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128391_(this.inputInv.serializeNBT());
        if (this.lootTable != null) {
            tag.m_128359_("LootTable", this.lootTable.toString());
            tag.m_128405_("count", this.count);
            tag.m_128350_("chance", this.chance);
        }
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inputInv.deserializeNBT(tag);
        if (tag.m_128441_("LootTable")) {
            this.lootTable = new ResourceLocation(tag.m_128461_("LootTable"));
            this.count = tag.m_128451_("count");
            this.chance = tag.m_128457_("chance");
        }
    }

    public void setLootInv(@Nullable Player player) {
        if (this.lootTable == null) {
            return;
        }
        RandomSource rand = this.m_58904_().m_213780_();
        LootParams builder = new LootParams.Builder((ServerLevel)this.m_58904_()).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)this.f_58858_)).m_287235_(LootContextParamSets.f_81411_);
        LootTable table = this.m_58904_().m_7654_().m_278653_().m_278676_(this.lootTable);
        ArrayList stackList = new ArrayList();
        for (int i = 0; i < this.count; ++i) {
            stackList.addAll(table.m_287195_(builder));
        }
        IItemHandler handler = this.getItemHandler(this, Direction.UP);
        block1: for (int i = 0; i < this.getInvSize(); ++i) {
            if (rand.m_188501_() < this.chance) continue;
            for (int s = 0; s < stackList.size(); ++s) {
                ItemStack result;
                ItemStack stack = (ItemStack)stackList.get(s);
                if (stack.m_41619_() || !(result = handler.insertItem(i, stack.m_41777_(), true)).m_41619_()) continue;
                handler.insertItem(i, stack.m_41777_(), false);
                stackList.remove(s);
                continue block1;
            }
        }
        this.lootTable = null;
        this.sendPKT();
    }

    @Override
    public int getInvSize() {
        return 104;
    }

    public IItemHandler getInput() {
        return this.inputInv;
    }

    public ItemStack getInputItem(int i) {
        return this.getInput().getStackInSlot(i);
    }

    @Override
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new WoodChestMenu(windowId, inv, this);
    }

    @Override
    public boolean isInfoEmpty() {
        return this.getInputList().isEmpty() && this.lootTable == null;
    }

    public List<ItemStack> getInputList() {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        for (int i = 0; i < this.getInvSize(); ++i) {
            this.addStackList(stackList, this.getInputItem(i));
        }
        return stackList;
    }

    public List<ItemStack> getInvList() {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        for (int i = 0; i < this.getInvSize(); ++i) {
            stackList.add(this.getInputItem(i));
        }
        return stackList;
    }

    public void invTrash(boolean isRS) {
        boolean isTrash = isRS;
        for (int i = 0; i < this.getInvSize(); ++i) {
            ItemStack stack = this.getInputItem(i);
            if (stack.m_41619_()) continue;
            stack.m_41774_(stack.m_41613_());
            isTrash = true;
        }
        if (isTrash) {
            this.playSound(this.m_58899_(), SoundEvents.f_12331_, 0.0625f, 1.0f);
        } else {
            this.clickButton();
        }
    }

    public int getData() {
        return ((WoodChest)this.getBlock((BlockPos)this.m_58899_())).data;
    }
}

