/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SimpleAnimatedParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.phys.Vec3;
import sweetmagic.init.item.sm.SMItem;
import sweetmagic.particle.ParticleSMBase;
import sweetmagic.util.MathHelper;

public class RotationParticle
extends SimpleAnimatedParticle {
    public boolean isUp = false;
    public boolean isFadeOut = false;
    public float rate = 1.0f;
    private final Vec3 axis;
    private final Vec3 origin;
    private final double radius;
    private float angularVelocity;
    private float currentAngle;
    public ParticleRenderType renderType = ParticleRenderType.f_107431_;

    private RotationParticle(ClientLevel world, double x, double y, double z, Vec3 center, Vec3 rot, int ccw, double radius, double angle, SpriteSet sprite) {
        super(world, x, y, z, sprite, -5.0E-4f);
        this.origin = center;
        this.axis = rot;
        this.angularVelocity = (float)((double)((float)ccw * SMItem.SPEED) * Math.PI / 180.0);
        this.radius = radius;
        this.currentAngle = (float)angle;
        this.f_107217_ = 0.0;
        this.f_107216_ = 0.0;
        this.f_107215_ = 0.0;
        this.f_107229_ = 1.0f;
        this.f_107228_ = 1.0f;
        this.f_107227_ = 1.0f;
        this.f_107225_ = 30;
        this.f_107663_ = 0.075f;
        this.m_107271_(0.0f);
        this.m_108339_(sprite);
        this.f_107219_ = false;
    }

    public ParticleRenderType m_7556_() {
        return this.renderType;
    }

    public void setQuadSize(float scale) {
        this.f_107663_ = scale;
    }

    public void m_5989_() {
        super.m_5989_();
        this.m_107271_(this.f_107224_ <= 0 ? 0.0f : 1.0f);
        if (this.isFadeOut && this.f_107224_ >= this.f_107225_ - 5) {
            this.f_107230_ = 1.0f - Math.min(5.0f - (float)(this.f_107225_ - this.f_107224_), 5.0f) / 5.0f;
        }
    }

    public void m_6257_(double x, double y, double z) {
        this.currentAngle += this.angularVelocity;
        Vec3 rot = new Vec3(this.radius, 0.0, 0.0).m_82524_(this.currentAngle);
        Vec3 newPos = MathHelper.changeBasisN(this.axis, rot).m_82549_(this.origin);
        double addY = (this.isUp ? (double)this.f_107224_ * 0.375 : 0.0) * (double)this.rate;
        super.m_6257_(newPos.f_82479_ - this.f_107212_, newPos.f_82480_ - this.f_107213_ + addY, newPos.f_82481_ - this.f_107214_);
    }

    public void addColor(float r, float g, float b) {
        this.m_107253_(r / 255.0f, g / 255.0f, b / 255.0f);
    }

    public record Shine(SpriteSet sprite) implements ParticleSMBase.BaseCreateParticle
    {
        public Particle createParticle(SimpleParticleType type, ClientLevel world, double centerX, double centerY, double centerZ, double face, double radius, double angle) {
            Vec3 center = new Vec3(centerX, centerY, centerZ);
            int ccw = 1;
            if (face < 0.0) {
                ccw = -1;
                face = -face;
            }
            Direction dir = Direction.m_122376_((int)((int)face));
            float radAngle = (float)(angle * Math.PI / 180.0);
            Vec3 axis = MathHelper.V3itoV3(dir.m_122436_());
            Vec3 rot = new Vec3(radius, 0.0, 0.0).m_82524_(radAngle);
            Vec3 newPos = MathHelper.changeBasisN(axis, rot).m_82549_(center);
            RotationParticle par = new RotationParticle(world, newPos.f_82479_, newPos.f_82480_, newPos.f_82481_, center, axis, ccw, radius, radAngle, this.sprite);
            par.addColor(255.0f - this.getRand(5.0f), 233.0f + this.getRandF(20.0f), 96.0f + this.getRandF(20.0f));
            par.f_107225_ = 25 + Shine.rand.nextInt(15);
            par.setQuadSize(0.1f + this.getRand(0.1f));
            par.f_107216_ = 2.0;
            par.isUp = true;
            par.isFadeOut = true;
            return par;
        }
    }

    public record Toxic(SpriteSet sprite) implements ParticleSMBase.BaseCreateParticle
    {
        public Particle createParticle(SimpleParticleType type, ClientLevel world, double centerX, double centerY, double centerZ, double face, double radius, double angle) {
            Vec3 center = new Vec3(centerX, centerY, centerZ);
            int ccw = 1;
            if (face < 0.0) {
                ccw = -1;
                face = -face;
            }
            Direction dir = Direction.m_122376_((int)((int)face));
            float radAngle = (float)(angle * Math.PI / 180.0);
            Vec3 axis = MathHelper.V3itoV3(dir.m_122436_());
            Vec3 rot = new Vec3(radius, 0.0, 0.0).m_82524_(radAngle);
            Vec3 newPos = MathHelper.changeBasisN(axis, rot).m_82549_(center);
            RotationParticle par = new RotationParticle(world, newPos.f_82479_, newPos.f_82480_, newPos.f_82481_, center, axis, ccw, radius, radAngle, this.sprite);
            par.m_107271_(1.0f);
            par.setQuadSize(0.15f + this.getRand(0.015f));
            par.addColor(30.0f + this.getRand(32.0f), 216.0f + this.getRand(32.0f), 86.0f + this.getRand(32.0f));
            par.renderType = ParticleRenderType.f_107430_;
            return par;
        }
    }

    public record Yellow(SpriteSet sprite) implements ParticleSMBase.BaseCreateParticle
    {
        public Particle createParticle(SimpleParticleType type, ClientLevel world, double centerX, double centerY, double centerZ, double face, double radius, double angle) {
            Vec3 center = new Vec3(centerX, centerY, centerZ);
            int ccw = 1;
            if (face < 0.0) {
                ccw = -1;
                face = -face;
            }
            Direction dir = Direction.m_122376_((int)((int)face));
            float radAngle = (float)(angle * Math.PI / 180.0);
            Vec3 axis = MathHelper.V3itoV3(dir.m_122436_());
            Vec3 rot = new Vec3(radius, 0.0, 0.0).m_82524_(radAngle);
            Vec3 newPos = MathHelper.changeBasisN(axis, rot).m_82549_(center);
            RotationParticle par = new RotationParticle(world, newPos.f_82479_, newPos.f_82480_, newPos.f_82481_, center, axis, ccw, radius, radAngle, this.sprite);
            par.addColor(255.0f - this.getRand(75.0f), 249.0f - this.getRand(50.0f), 91.0f + this.getRand(50.0f));
            return par;
        }
    }

    public record BloodCyclone(SpriteSet sprite) implements ParticleSMBase.BaseCreateParticle
    {
        public Particle createParticle(SimpleParticleType type, ClientLevel world, double centerX, double centerY, double centerZ, double face, double radius, double angle) {
            Vec3 center = new Vec3(centerX, centerY, centerZ);
            int ccw = 1;
            if (face < 0.0) {
                ccw = -1;
                face = -face;
            }
            Direction dir = Direction.m_122376_((int)((int)face));
            float radAngle = (float)(angle * Math.PI / 180.0);
            Vec3 axis = MathHelper.V3itoV3(dir.m_122436_());
            Vec3 rot = new Vec3(radius, 0.0, 0.0).m_82524_(radAngle);
            Vec3 newPos = MathHelper.changeBasisN(axis, rot).m_82549_(center);
            RotationParticle par = new RotationParticle(world, newPos.f_82479_, newPos.f_82480_, newPos.f_82481_, center, axis, ccw, radius, radAngle, this.sprite);
            par.addColor(195.0f + this.getRand(32.0f), 17.0f + this.getRand(32.0f), 71.0f + this.getRand(32.0f));
            par.f_107225_ = 25 + BloodCyclone.rand.nextInt(15);
            par.setQuadSize(0.1f + this.getRand(0.1f));
            par.f_107216_ = 2.0;
            par.isUp = true;
            return par;
        }
    }

    public record Cyclon3(SpriteSet sprite) implements ParticleSMBase.BaseCreateParticle
    {
        public Particle createParticle(SimpleParticleType type, ClientLevel world, double centerX, double centerY, double centerZ, double face, double radius, double angle) {
            Vec3 center = new Vec3(centerX, centerY, centerZ);
            int ccw = 1;
            if (face < 0.0) {
                ccw = -1;
                face = -face;
            }
            Direction dir = Direction.m_122376_((int)((int)face));
            float radAngle = (float)(angle * Math.PI / 180.0);
            Vec3 axis = MathHelper.V3itoV3(dir.m_122436_());
            Vec3 rot = new Vec3(radius, 0.0, 0.0).m_82524_(radAngle);
            Vec3 newPos = MathHelper.changeBasisN(axis, rot).m_82549_(center);
            RotationParticle par = new RotationParticle(world, newPos.f_82479_, newPos.f_82480_, newPos.f_82481_, center, axis, ccw, radius, radAngle, this.sprite);
            par.f_107225_ = 25 + Cyclon3.rand.nextInt(15);
            par.setQuadSize(0.1f + this.getRand(0.1f));
            par.f_107216_ = 2.0;
            par.isUp = true;
            par.rate = 0.15f;
            return par;
        }
    }

    public record Cyclon2(SpriteSet sprite) implements ParticleSMBase.BaseCreateParticle
    {
        public Particle createParticle(SimpleParticleType type, ClientLevel world, double centerX, double centerY, double centerZ, double face, double radius, double angle) {
            Vec3 center = new Vec3(centerX, centerY, centerZ);
            int ccw = 1;
            if (face < 0.0) {
                ccw = -1;
                face = -face;
            }
            Direction dir = Direction.m_122376_((int)((int)face));
            float radAngle = (float)(angle * Math.PI / 180.0);
            Vec3 axis = MathHelper.V3itoV3(dir.m_122436_());
            Vec3 rot = new Vec3(radius, 0.0, 0.0).m_82524_(radAngle);
            Vec3 newPos = MathHelper.changeBasisN(axis, rot).m_82549_(center);
            RotationParticle par = new RotationParticle(world, newPos.f_82479_, newPos.f_82480_, newPos.f_82481_, center, axis, ccw, radius, radAngle, this.sprite);
            par.f_107225_ = 25 + Cyclon2.rand.nextInt(15);
            par.setQuadSize(0.1f + this.getRand(0.1f));
            par.f_107216_ = 2.0;
            par.isUp = true;
            return par;
        }
    }

    public record Cyclone(SpriteSet sprite) implements ParticleSMBase.BaseCreateParticle
    {
        public Particle createParticle(SimpleParticleType type, ClientLevel world, double centerX, double centerY, double centerZ, double face, double radius, double angle) {
            Vec3 center = new Vec3(centerX, centerY, centerZ);
            int ccw = 1;
            if (face < 0.0) {
                ccw = -1;
                face = -face;
            }
            Direction dir = Direction.m_122376_((int)((int)face));
            float radAngle = (float)(angle * Math.PI / 180.0);
            Vec3 axis = MathHelper.V3itoV3(dir.m_122436_());
            Vec3 rot = new Vec3(radius, 0.0, 0.0).m_82524_(radAngle);
            Vec3 newPos = MathHelper.changeBasisN(axis, rot).m_82549_(center);
            RotationParticle par = new RotationParticle(world, newPos.f_82479_, newPos.f_82480_, newPos.f_82481_, center, axis, ccw, radius, radAngle, this.sprite);
            par.f_107225_ = 40 + Cyclone.rand.nextInt(31);
            par.setQuadSize(0.5f + this.getRand(0.5f));
            par.f_107216_ = 2.0;
            par.isUp = true;
            return par;
        }
    }

    public record Reflash(SpriteSet sprite) implements ParticleSMBase.BaseCreateParticle
    {
        public Particle createParticle(SimpleParticleType type, ClientLevel world, double centerX, double centerY, double centerZ, double face, double radius, double angle) {
            Vec3 center = new Vec3(centerX, centerY, centerZ);
            int ccw = 1;
            if (face < 0.0) {
                ccw = -1;
                face = -face;
            }
            Direction dir = Direction.m_122376_((int)((int)face));
            float radAngle = (float)(angle * Math.PI / 180.0);
            Vec3 axis = MathHelper.V3itoV3(dir.m_122436_());
            Vec3 rot = new Vec3(radius, 0.0, 0.0).m_82524_(radAngle);
            Vec3 newPos = MathHelper.changeBasisN(axis, rot).m_82549_(center);
            RotationParticle par = new RotationParticle(world, newPos.f_82479_, newPos.f_82480_, newPos.f_82481_, center, axis, ccw, radius, radAngle, this.sprite);
            par.m_107271_(1.0f);
            par.setQuadSize(0.25f + this.getRand(0.015f));
            par.addColor(20.0f + this.getRand(100.0f), 103.0f + this.getRand(100.0f), 180.0f + this.getRand(75.0f));
            par.renderType = ParticleRenderType.f_107430_;
            return par;
        }
    }

    public record Heal(SpriteSet sprite) implements ParticleSMBase.BaseCreateParticle
    {
        public Particle createParticle(SimpleParticleType type, ClientLevel world, double centerX, double centerY, double centerZ, double face, double radius, double angle) {
            Vec3 center = new Vec3(centerX, centerY, centerZ);
            int ccw = 1;
            if (face < 0.0) {
                ccw = -1;
                face = -face;
            }
            Direction dir = Direction.m_122376_((int)((int)face));
            float radAngle = (float)(angle * Math.PI / 180.0);
            Vec3 axis = MathHelper.V3itoV3(dir.m_122436_());
            Vec3 rot = new Vec3(radius, 0.0, 0.0).m_82524_(radAngle);
            Vec3 newPos = MathHelper.changeBasisN(axis, rot).m_82549_(center);
            RotationParticle par = new RotationParticle(world, newPos.f_82479_, newPos.f_82480_, newPos.f_82481_, center, axis, ccw, radius, radAngle, this.sprite);
            par.m_107271_(1.0f);
            par.setQuadSize(0.15f + this.getRand(0.075f));
            par.renderType = ParticleRenderType.f_107430_;
            return par;
        }
    }

    public record Blood(SpriteSet sprite) implements ParticleSMBase.BaseCreateParticle
    {
        public Particle createParticle(SimpleParticleType type, ClientLevel world, double centerX, double centerY, double centerZ, double face, double radius, double angle) {
            Vec3 center = new Vec3(centerX, centerY, centerZ);
            int ccw = 1;
            if (face < 0.0) {
                ccw = -1;
                face = -face;
            }
            Direction dir = Direction.m_122376_((int)((int)face));
            float radAngle = (float)(angle * Math.PI / 180.0);
            Vec3 axis = MathHelper.V3itoV3(dir.m_122436_());
            Vec3 rot = new Vec3(radius, 0.0, 0.0).m_82524_(radAngle);
            Vec3 newPos = MathHelper.changeBasisN(axis, rot).m_82549_(center);
            RotationParticle par = new RotationParticle(world, newPos.f_82479_, newPos.f_82480_, newPos.f_82481_, center, axis, ccw, radius, radAngle, this.sprite);
            par.addColor(195.0f + this.getRand(32.0f), 17.0f + this.getRand(32.0f), 71.0f + this.getRand(32.0f));
            par.setQuadSize(0.5f);
            return par;
        }
    }

    public record Electoric(SpriteSet sprite) implements ParticleSMBase.BaseCreateParticle
    {
        public Particle createParticle(SimpleParticleType type, ClientLevel world, double centerX, double centerY, double centerZ, double face, double radius, double angle) {
            Vec3 center = new Vec3(centerX, centerY, centerZ);
            int ccw = 1;
            if (face < 0.0) {
                ccw = -1;
                face = -face;
            }
            Direction dir = Direction.m_122376_((int)((int)face));
            float radAngle = (float)(angle * Math.PI / 180.0);
            Vec3 axis = MathHelper.V3itoV3(dir.m_122436_());
            Vec3 rot = new Vec3(radius, 0.0, 0.0).m_82524_(radAngle);
            Vec3 newPos = MathHelper.changeBasisN(axis, rot).m_82549_(center);
            RotationParticle par = new RotationParticle(world, newPos.f_82479_, newPos.f_82480_, newPos.f_82481_, center, axis, ccw, radius, radAngle, this.sprite);
            par.addColor(239.0f, 227.0f, 55.0f);
            par.setQuadSize(0.5f);
            return par;
        }
    }

    public record Frost(SpriteSet sprite) implements ParticleSMBase.BaseCreateParticle
    {
        public Particle createParticle(SimpleParticleType type, ClientLevel world, double centerX, double centerY, double centerZ, double face, double radius, double angle) {
            Vec3 center = new Vec3(centerX, centerY, centerZ);
            int ccw = 1;
            if (face < 0.0) {
                ccw = -1;
                face = -face;
            }
            Direction dir = Direction.m_122376_((int)((int)face));
            float radAngle = (float)(angle * Math.PI / 180.0);
            Vec3 axis = MathHelper.V3itoV3(dir.m_122436_());
            Vec3 rot = new Vec3(radius, 0.0, 0.0).m_82524_(radAngle);
            Vec3 newPos = MathHelper.changeBasisN(axis, rot).m_82549_(center);
            RotationParticle par = new RotationParticle(world, newPos.f_82479_, newPos.f_82480_, newPos.f_82481_, center, axis, ccw, radius, radAngle, this.sprite);
            par.m_107271_(1.0f);
            par.setQuadSize(0.3f);
            par.renderType = ParticleRenderType.f_107430_;
            return par;
        }
    }

    public record Rewrite(SpriteSet sprite) implements ParticleSMBase.BaseCreateParticle
    {
        public Particle createParticle(SimpleParticleType type, ClientLevel world, double centerX, double centerY, double centerZ, double face, double radius, double angle) {
            Vec3 center = new Vec3(centerX, centerY, centerZ);
            int ccw = 1;
            if (face < 0.0) {
                ccw = -1;
                face = -face;
            }
            Direction dir = Direction.m_122376_((int)((int)face));
            float radAngle = (float)(angle * Math.PI / 180.0);
            Vec3 axis = MathHelper.V3itoV3(dir.m_122436_());
            Vec3 rot = new Vec3(radius, 0.0, 0.0).m_82524_(radAngle);
            Vec3 newPos = MathHelper.changeBasisN(axis, rot).m_82549_(center);
            RotationParticle par = new RotationParticle(world, newPos.f_82479_, newPos.f_82480_, newPos.f_82481_, center, axis, ccw, radius, radAngle, this.sprite);
            par.m_107253_(0.44705883f, 1.0f, 0.5411765f);
            return par;
        }
    }

    public record Factory(SpriteSet sprite) implements ParticleSMBase.BaseCreateParticle
    {
        public Particle createParticle(SimpleParticleType type, ClientLevel world, double centerX, double centerY, double centerZ, double face, double radius, double angle) {
            Vec3 center = new Vec3(centerX, centerY, centerZ);
            int ccw = 1;
            if (face < 0.0) {
                ccw = -1;
                face = -face;
            }
            Direction dir = Direction.m_122376_((int)((int)face));
            float radAngle = (float)(angle * Math.PI / 180.0);
            Vec3 axis = MathHelper.V3itoV3(dir.m_122436_());
            Vec3 rot = new Vec3(radius, 0.0, 0.0).m_82524_(radAngle);
            Vec3 newPos = MathHelper.changeBasisN(axis, rot).m_82549_(center);
            RotationParticle par = new RotationParticle(world, newPos.f_82479_, newPos.f_82480_, newPos.f_82481_, center, axis, ccw, radius, radAngle, this.sprite);
            par.addColor(140.0f, 230.0f, 255.0f);
            return par;
        }
    }
}

