/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.plugin.terrablender;

import com.mojang.datafixers.util.Pair;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import sweetmagic.SweetMagicCore;
import sweetmagic.config.SMConfig;
import sweetmagic.init.BiomeInit;
import terrablender.api.Region;
import terrablender.api.RegionType;
import terrablender.api.Regions;

public class SMBiomeRegion
extends Region {
    private final int data;

    public SMBiomeRegion(int weight, int data) {
        super(SweetMagicCore.getSRC("overworld" + data), RegionType.OVERWORLD, weight);
        this.data = data;
    }

    public void addBiomes(Registry<Biome> registry, Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> mapper) {
        this.addModifiedVanillaOverworldBiomes(mapper, b -> b.replaceBiome(Biomes.f_48205_, this.getKey()));
    }

    public ResourceKey<Biome> getKey() {
        return switch (this.data) {
            case 1 -> BiomeInit.FRUIT_FOREST;
            case 3 -> BiomeInit.CHERRY_BLOSSOMS_FOREST;
            default -> BiomeInit.PRISM_FOREST;
        };
    }

    public static void register() {
        Regions.register((Region)new SMBiomeRegion((Integer)SMConfig.prismChance.get(), 0));
        Regions.register((Region)new SMBiomeRegion((Integer)SMConfig.fruitChance.get(), 1));
        Regions.register((Region)new SMBiomeRegion((Integer)SMConfig.cherreyChance.get(), 3));
    }
}

