/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.recipe.trade;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import sweetmagic.init.RecipeSerializerInit;
import sweetmagic.init.RecipeTypeInit;
import sweetmagic.recipe.base.AbstractRecipe;

public class TradeRecipe
extends AbstractRecipe {
    protected String tradeType;
    protected List<Ingredient> ingredList;
    protected List<Integer> countList;
    protected List<Integer> valueList;

    public TradeRecipe(ResourceLocation id, String tradeType, List<Ingredient> resultIngList, List<Integer> countList, List<Integer> valueList) {
        super(id, resultIngList, countList, true);
        this.setTradeType(tradeType);
        this.setCountList(countList);
        this.setValueList(valueList);
        this.setResultIngList((List<Ingredient>)ImmutableList.copyOf(resultIngList));
        if (resultIngList.isEmpty()) {
            throw new IllegalArgumentException("Recipe has no result: " + id.toString());
        }
    }

    @Override
    public RecipeSerializer<?> m_7707_() {
        return RecipeSerializerInit.TRADE;
    }

    @Override
    public RecipeType<?> m_6671_() {
        return RecipeTypeInit.TRADE;
    }

    @Override
    public ItemStack getResultItem() {
        return this.getResultIngList().get(0).m_43908_()[0].m_41777_();
    }

    @Override
    public List<Ingredient> getIngredList() {
        return this.ingredList;
    }

    @Override
    public void setingredList(List<Ingredient> ingreadList) {
        this.ingredList = ingreadList;
    }

    @Override
    public List<Integer> getCountList() {
        return this.countList;
    }

    @Override
    public void setCountList(List<Integer> countList) {
        this.countList = countList;
    }

    public List<Integer> getValueList() {
        return this.valueList;
    }

    public void setValueList(List<Integer> valueList) {
        this.valueList = valueList;
    }

    public String getTradeType() {
        return this.tradeType;
    }

    public void setTradeType(String tradeType) {
        this.tradeType = tradeType;
    }
}

