/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.recipe.woodcutter;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import sweetmagic.init.RecipeSerializerInit;
import sweetmagic.init.RecipeTypeInit;
import sweetmagic.recipe.base.AbstractRecipe;

public class WoodCutterRecipe
extends AbstractRecipe {
    protected List<Ingredient> ingredList;
    protected List<Integer> countList;
    protected int mf;
    protected List<Integer> minList;
    protected List<Integer> maxList;

    public WoodCutterRecipe(ResourceLocation id, List<ItemStack> resultList, List<Ingredient> ingredList, List<Integer> countList, List<Integer> minList, List<Integer> maxList, int mf) {
        super(id, resultList, ingredList, countList);
        this.setMF(mf);
        this.setMinList(minList);
        this.setMaxList(maxList);
    }

    public static Optional<WoodCutterRecipe> getRecipe(Level world, List<ItemStack> ingredList) {
        return AbstractRecipe.getRecipe(world, RecipeTypeInit.WOODCUTTER).filter(t -> t.matches(ingredList)).findFirst();
    }

    @Override
    public RecipeSerializer<?> m_7707_() {
        return RecipeSerializerInit.WOODCUTTER;
    }

    @Override
    public RecipeType<?> m_6671_() {
        return RecipeTypeInit.WOODCUTTER;
    }

    @Override
    public List<Ingredient> getIngredList() {
        return this.ingredList;
    }

    @Override
    public void setingredList(List<Ingredient> ingreadList) {
        this.ingredList = ingreadList;
    }

    @Override
    public List<Integer> getCountList() {
        return this.countList;
    }

    @Override
    public void setCountList(List<Integer> countList) {
        this.countList = countList;
    }

    public List<Integer> getMinList() {
        return this.minList;
    }

    public void setMinList(List<Integer> minList) {
        this.minList = minList;
    }

    public List<Integer> getMaxList() {
        return this.maxList;
    }

    public void setMaxList(List<Integer> maxList) {
        this.maxList = maxList;
    }

    public int getMF() {
        return this.mf;
    }

    public void setMF(int mf) {
        this.mf = mf;
    }

    public int getCount(Random rand, int array) {
        int min = this.getMinList().get(array);
        int max = this.getMaxList().get(array);
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = min; i < max; ++i) {
            list.add(i);
        }
        return (Integer)list.get(rand.nextInt(list.size()));
    }
}

