/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.util;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import sweetmagic.SweetMagicCore;

public class SMDamage
extends DamageSource {
    protected final List<EntityType<?>> entityList;
    public static final ResourceKey<DamageType> magicDamage = SMDamage.create("sm_magic");
    public static final ResourceKey<DamageType> flameDamage = SMDamage.create("sm_flame");
    public static final ResourceKey<DamageType> flostDamage = SMDamage.create("sm_flost");
    public static final ResourceKey<DamageType> exploDamage = SMDamage.create("sm_explo");
    public static final ResourceKey<DamageType> poisonDamage = SMDamage.create("sm_poison");
    public static final ResourceKey<DamageType> addDamage = SMDamage.create("sm_add");
    public static final ResourceKey<DamageType> debuffDamage = SMDamage.create("sm_debuff");

    public SMDamage(Holder<DamageType> type, EntityType<?> ... entityList) {
        super(type);
        this.entityList = Arrays.stream(entityList).toList();
    }

    public SMDamage(Holder<DamageType> type, Entity attacker, Entity indirectAttacker, EntityType<?> ... entityList) {
        super(type, indirectAttacker, attacker);
        this.entityList = Arrays.stream(entityList).toList();
    }

    public static DamageSource getSource(Level world, ResourceKey<DamageType> type, @Nullable Entity attacker, EntityType<?> ... entityType) {
        return SMDamage.getSource(world, type, attacker, attacker, entityType);
    }

    public static DamageSource getSource(Level world, ResourceKey<DamageType> type, @Nullable Entity attacker, @Nullable Entity indirectAttacker, EntityType<?> ... entityType) {
        return new DamageSource((Holder)world.m_9598_().m_175515_(Registries.f_268580_).m_246971_(type), attacker, indirectAttacker);
    }

    public Component m_6157_(LivingEntity living) {
        LivingEntity entity = living.m_21232_();
        String s = "death.attack." + this.m_269415_().f_268677_();
        String s1 = s + ".player";
        if (entity != null) {
            for (EntityType<?> eType : this.entityList) {
                if (entity.m_6095_() != eType) continue;
                return Component.m_237110_((String)s, (Object[])new Object[]{living.m_5446_()});
            }
        }
        return entity != null ? Component.m_237110_((String)s1, (Object[])new Object[]{living.m_5446_(), entity.m_5446_()}) : Component.m_237110_((String)s, (Object[])new Object[]{living.m_5446_()});
    }

    public static DamageSource getMagicDamage(Entity magic, Entity thower) {
        return SMDamage.getSource(thower.m_9236_(), magicDamage, magic, thower, thower.m_6095_());
    }

    public static DamageSource getMagicDamage(Entity thower) {
        return SMDamage.getSource(thower.m_9236_(), magicDamage, thower, thower.m_6095_());
    }

    public static DamageSource getAddDamage(Entity thower) {
        return SMDamage.getSource(thower.m_9236_(), addDamage, thower, thower.m_6095_());
    }

    public static DamageSource getAddDamage(Entity thower, Entity magic) {
        return SMDamage.getSource(thower.m_9236_(), addDamage, magic, thower, thower.m_6095_());
    }

    public static DamageSource getPlayerDamage(Entity thower) {
        return SMDamage.getSource(thower.m_9236_(), (ResourceKey<DamageType>)DamageTypes.f_268464_, thower, thower.m_6095_());
    }

    public static DamageSource getDebuffDamage(Level world) {
        return new DamageSource((Holder)world.m_9598_().m_175515_(Registries.f_268580_).m_246971_(debuffDamage));
    }

    public static DamageSource getDamage(ResourceKey<DamageType> type, Entity thower) {
        return SMDamage.getSource(thower.m_9236_(), type, thower, thower.m_6095_());
    }

    public static DamageSource getDamage(ResourceKey<DamageType> type, Level world) {
        return SMDamage.getSource(world, type, null, new EntityType[0]);
    }

    public static ResourceKey<DamageType> create(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)SweetMagicCore.getSRC(name));
    }
}

