/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.util;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.fml.loading.FMLPaths;

public class SchematicExport {
    public static final Path SCHEMATICS = FMLPaths.GAMEDIR.get().resolve("schematics");

    public static boolean saveSchematic(Path dir, String fileName, boolean overwrite, Level level, BlockPos first, BlockPos second) {
        BoundingBox bb = BoundingBox.m_162375_((Vec3i)first, (Vec3i)second);
        BlockPos origin = new BlockPos(bb.m_162395_(), bb.m_162396_(), bb.m_162398_());
        BlockPos bounds = new BlockPos(bb.m_71056_(), bb.m_71057_(), bb.m_71058_());
        StructureTemplate structure = new StructureTemplate();
        structure.m_163802_(level, origin, (Vec3i)bounds, true, Blocks.f_50454_);
        CompoundTag data = structure.m_74618_(new CompoundTag());
        if (!((String)fileName).endsWith(".nbt")) {
            fileName = (String)fileName + ".nbt";
        }
        Path file = dir.resolve((String)fileName).toAbsolutePath();
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
            try (OutputStream out = Files.newOutputStream(file, StandardOpenOption.CREATE);){
                NbtIo.m_128947_((CompoundTag)data, (OutputStream)out);
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }
}

