/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.worldgen.structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import sweetmagic.init.StructureInit;

public class SMStructure
extends Structure {
    public static final Codec<SMStructure> CODEC = RecordCodecBuilder.mapCodec(par1 -> par1.group((App)SMStructure.m_226567_((RecordCodecBuilder.Instance)par1), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(par2 -> par2.startPool), (App)ResourceLocation.f_135803_.optionalFieldOf("start_jigsaw_name").forGetter(par3 -> par3.jigsawName), (App)Codec.intRange((int)0, (int)512).fieldOf("size").forGetter(par4 -> par4.maxDepth), (App)HeightProvider.f_161970_.fieldOf("start_height").forGetter(par5 -> par5.startHeight), (App)Heightmap.Types.f_64274_.optionalFieldOf("project_start_to_heightmap").forGetter(par6 -> par6.projectStartToHeightmap), (App)Codec.intRange((int)1, (int)4096).fieldOf("max_distance_from_center").forGetter(par7 -> par7.maxDistanceFromCenter)).apply((Applicative)par1, SMStructure::new)).flatXmap(SMStructure.setRange(), SMStructure.setRange()).codec();
    private final Holder<StructureTemplatePool> startPool;
    private final Optional<ResourceLocation> jigsawName;
    private final int maxDepth;
    private final HeightProvider startHeight;
    private final Optional<Heightmap.Types> projectStartToHeightmap;
    private final int maxDistanceFromCenter;

    private static Function<SMStructure, DataResult<SMStructure>> setRange() {
        return par1 -> {
            switch (par1.m_226620_()) {
                case NONE: {
                    boolean b0 = false;
                    break;
                }
                case BURY: 
                case BEARD_THIN: 
                case BEARD_BOX: {
                    int b0 = 256;
                    break;
                }
                default: {
                    throw new IncompatibleClassChangeError();
                }
            }
            return DataResult.success((Object)par1);
        };
    }

    public SMStructure(Structure.StructureSettings set, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> jigsawName, int maxDepth, HeightProvider startHeight, Optional<Heightmap.Types> heightmap, int maxDistance) {
        super(set);
        this.startPool = startPool;
        this.jigsawName = Optional.empty();
        this.maxDepth = maxDepth;
        this.startHeight = startHeight;
        this.projectStartToHeightmap = heightmap;
        this.maxDistanceFromCenter = maxDistance;
    }

    public SMStructure(Structure.StructureSettings set, Holder<StructureTemplatePool> startPool, int maxDepth, HeightProvider startHeight, Heightmap.Types heightmap) {
        this(set, startPool, Optional.empty(), maxDepth, startHeight, Optional.of(heightmap), 1024);
    }

    public SMStructure(Structure.StructureSettings set, Holder<StructureTemplatePool> startPool, int maxDepth, HeightProvider startHeight) {
        this(set, startPool, Optional.empty(), maxDepth, startHeight, Optional.empty(), 1024);
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext gen) {
        ChunkPos chunkPos = gen.f_226628_();
        int i = this.startHeight.m_213859_((RandomSource)gen.f_226626_(), new WorldGenerationContext(gen.f_226622_(), gen.f_226629_()));
        BlockPos pos = new BlockPos(chunkPos.m_45604_(), i, chunkPos.m_45605_());
        return JigsawPlacement.m_227238_((Structure.GenerationContext)gen, this.startPool, this.jigsawName, (int)this.maxDepth, (BlockPos)pos, (boolean)true, this.projectStartToHeightmap, (int)this.maxDistanceFromCenter);
    }

    public StructureType<?> m_213658_() {
        return (StructureType)StructureInit.SM_JIGSAW_STRUCTURE.get();
    }
}

