/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.worldgen.tree.featuer;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.rootplacers.RootPlacer;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.shapes.BitSetDiscreteVoxelShape;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;
import sweetmagic.init.BlockInit;
import sweetmagic.util.WorldHelper;

public class CherryFeatuer
extends Feature<TreeConfiguration> {
    private final int data;

    public CherryFeatuer(int data) {
        super(TreeConfiguration.f_68184_);
        this.data = data;
    }

    private static boolean isVine(LevelSimulatedReader world, BlockPos pos) {
        return world.m_7433_(pos, s -> s.m_60713_(Blocks.f_50191_));
    }

    public static boolean isBlockWater(LevelSimulatedReader world, BlockPos pos) {
        return world.m_7433_(pos, s -> s.m_60713_(Blocks.f_49990_));
    }

    public static boolean isAirOrLeaves(LevelSimulatedReader world, BlockPos pos) {
        return world.m_7433_(pos, s -> s.m_204336_(BlockTags.f_13035_));
    }

    private static boolean isReplaceablePlant(LevelSimulatedReader world, BlockPos pos) {
        return world.m_7433_(pos, s -> s.m_247087_());
    }

    private static void setBlockKnownShape(LevelWriter world, BlockPos pos, BlockState state) {
        state = state.m_61138_((Property)LeavesBlock.f_54419_) ? (BlockState)state.m_61124_((Property)LeavesBlock.f_54419_, (Comparable)Boolean.valueOf(false)) : state;
        state = state.m_61138_((Property)LeavesBlock.f_54418_) ? (BlockState)state.m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)) : state;
        world.m_7731_(pos, state, 19);
    }

    public static boolean validTreePos(LevelSimulatedReader world, BlockPos pos) {
        return CherryFeatuer.isAirOrLeaves(world, pos) || CherryFeatuer.isReplaceablePlant(world, pos) || CherryFeatuer.isBlockWater(world, pos);
    }

    private boolean doPlace(WorldGenLevel world, RandomSource rand, BlockPos pos, BiConsumer<BlockPos, BlockState> bi1, BiConsumer<BlockPos, BlockState> bi2, FoliagePlacer.FoliageSetter bi3, TreeConfiguration con) {
        int i = con.f_68190_.m_226153_(rand);
        int j = con.f_68189_.m_214116_(rand, i, con);
        int k = i - j;
        int l = con.f_68189_.m_214117_(rand, k);
        BlockPos bpos = con.f_225455_.map(state -> state.m_225891_(pos, rand)).orElse(pos);
        int i1 = Math.min(pos.m_123342_(), bpos.m_123342_());
        int j1 = Math.max(pos.m_123342_(), bpos.m_123342_()) + i + 1;
        if (i1 >= world.m_141937_() + 1 && j1 <= world.m_151558_()) {
            OptionalInt opti = con.f_68191_.m_68295_();
            int k1 = this.getMaxFreeTreeHeight((LevelSimulatedReader)world, i, bpos, con);
            if (k1 >= i || !opti.isEmpty() && k1 >= opti.getAsInt()) {
                if (con.f_225455_.isPresent() && !((RootPlacer)con.f_225455_.get()).m_213684_((LevelSimulatedReader)world, bi1, rand, pos, bpos, con)) {
                    return false;
                }
                List list = con.f_68190_.m_213934_((LevelSimulatedReader)world, bi2, rand, k1, bpos, con);
                list.forEach(s -> con.f_68189_.m_271927_((LevelSimulatedReader)world, bi3, rand, con, k1, s, j, l));
                return true;
            }
            return false;
        }
        return false;
    }

    private int getMaxFreeTreeHeight(LevelSimulatedReader world, int height, BlockPos pos, TreeConfiguration con) {
        BlockPos.MutableBlockPos bpos = new BlockPos.MutableBlockPos();
        for (int i = 0; i <= height + 1; ++i) {
            int j = con.f_68191_.m_6133_(height, i);
            for (int k = -j; k <= j; ++k) {
                for (int l = -j; l <= j; ++l) {
                    bpos.m_122154_((Vec3i)pos, k, i, l);
                    if (con.f_68190_.m_226184_(world, (BlockPos)bpos) && (con.f_68193_ || !CherryFeatuer.isVine(world, (BlockPos)bpos))) continue;
                    return i - 2;
                }
            }
        }
        return height;
    }

    protected void m_5974_(LevelWriter world, BlockPos pos, BlockState state) {
        CherryFeatuer.setBlockKnownShape(world, pos, state);
    }

    public boolean m_142674_(FeaturePlaceContext<TreeConfiguration> fpc) {
        BlockPos pos;
        final WorldGenLevel world = fpc.m_159774_();
        if (!this.checkBlock(world.m_8055_((pos = fpc.m_159777_()).m_7495_()).m_60734_())) {
            return false;
        }
        RandomSource rand = fpc.m_225041_();
        TreeConfiguration con = (TreeConfiguration)fpc.m_159778_();
        HashSet set = Sets.newHashSet();
        HashSet set1 = Sets.newHashSet();
        final HashSet set2 = Sets.newHashSet();
        HashSet set3 = Sets.newHashSet();
        BiConsumer<BlockPos, BlockState> bi1 = (s1, s2) -> {
            set.add(s1.m_7949_());
            world.m_7731_(s1, s2, 19);
        };
        BiConsumer<BlockPos, BlockState> bi2 = (s1, s2) -> {
            set1.add(s1.m_7949_());
            world.m_7731_(s1, s2, 19);
        };
        FoliagePlacer.FoliageSetter bi3 = new FoliagePlacer.FoliageSetter(){

            public void m_271838_(BlockPos pos, BlockState state) {
                set2.add(pos.m_7949_());
                world.m_7731_(pos, state, 19);
            }

            public boolean m_271808_(BlockPos pos) {
                return set2.contains(pos);
            }
        };
        BiConsumer<BlockPos, BlockState> bi4 = (s1, s2) -> {
            set3.add(s1.m_7949_());
            world.m_7731_(s1, s2, 19);
        };
        boolean flag = this.doPlace(world, rand, pos, bi1, bi2, bi3, con);
        if (!(!flag || set1.isEmpty() && set2.isEmpty())) {
            if (!con.f_68187_.isEmpty()) {
                TreeDecorator.Context deco = new TreeDecorator.Context((LevelSimulatedReader)world, bi4, rand, (Set)set1, (Set)set2, (Set)set);
                con.f_68187_.forEach(s -> s.m_214187_(deco));
            }
            if (this.data >= 1) {
                BlockState cherry_blossoms = this.data == 1 ? BlockInit.cherry_blossoms_leaves_carpet.m_49966_() : BlockInit.maple_leaves_carpet.m_49966_();
                for (int x = -4; x <= 4; ++x) {
                    for (int z = -4; z <= 4; ++z) {
                        float chance;
                        float f = chance = Math.abs(x) <= 2 && Math.abs(z) <= 2 ? 0.725f : 0.275f;
                        if (x == 0 && z == 0 || rand.m_188501_() >= chance) continue;
                        this.setSMBlock(world, WorldHelper.offset(pos, x, 0.0, z), cherry_blossoms);
                    }
                }
            }
            return BoundingBox.m_162378_((Iterable)Iterables.concat((Iterable)set, (Iterable)set1, (Iterable)set2, (Iterable)set3)).map(s -> {
                DiscreteVoxelShape face = CherryFeatuer.updateLeaves((LevelAccessor)world, s, set1, set3, set);
                StructureTemplate.m_74510_((LevelAccessor)world, (int)3, (DiscreteVoxelShape)face, (int)s.m_162395_(), (int)s.m_162396_(), (int)s.m_162398_());
                return true;
            }).orElse(false);
        }
        return false;
    }

    private static DiscreteVoxelShape updateLeaves(LevelAccessor world, BoundingBox aabb, Set<BlockPos> posSet1, Set<BlockPos> posSet2, Set<BlockPos> posSet3) {
        ArrayList list = Lists.newArrayList();
        BitSetDiscreteVoxelShape face = new BitSetDiscreteVoxelShape(aabb.m_71056_(), aabb.m_71057_(), aabb.m_71058_());
        for (int j = 0; j < 6; ++j) {
            list.add(Sets.newHashSet());
        }
        BlockPos.MutableBlockPos mutPos = new BlockPos.MutableBlockPos();
        for (BlockPos pos : Lists.newArrayList((Iterable)Sets.union(posSet2, posSet3))) {
            if (!aabb.m_71051_((Vec3i)pos)) continue;
            face.m_142703_(pos.m_123341_() - aabb.m_162395_(), pos.m_123342_() - aabb.m_162396_(), pos.m_123343_() - aabb.m_162398_());
        }
        for (BlockPos pos1 : Lists.newArrayList(posSet1)) {
            if (aabb.m_71051_((Vec3i)pos1)) {
                face.m_142703_(pos1.m_123341_() - aabb.m_162395_(), pos1.m_123342_() - aabb.m_162396_(), pos1.m_123343_() - aabb.m_162398_());
            }
            for (Direction fa : Direction.values()) {
                BlockState state;
                mutPos.m_122159_((Vec3i)pos1, fa);
                if (posSet1.contains(mutPos) || !(state = world.m_8055_((BlockPos)mutPos)).m_61138_((Property)BlockStateProperties.f_61414_)) continue;
                ((Set)list.get(0)).add(mutPos.m_7949_());
                CherryFeatuer.setBlockKnownShape((LevelWriter)world, (BlockPos)mutPos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61414_, (Comparable)Integer.valueOf(1)));
                if (!aabb.m_71051_((Vec3i)mutPos)) continue;
                face.m_142703_(mutPos.m_123341_() - aabb.m_162395_(), mutPos.m_123342_() - aabb.m_162396_(), mutPos.m_123343_() - aabb.m_162398_());
            }
        }
        for (int l = 1; l < 6; ++l) {
            Set set = (Set)list.get(l - 1);
            Set set1 = (Set)list.get(l);
            for (BlockPos pos2 : set) {
                if (aabb.m_71051_((Vec3i)pos2)) {
                    face.m_142703_(pos2.m_123341_() - aabb.m_162395_(), pos2.m_123342_() - aabb.m_162396_(), pos2.m_123343_() - aabb.m_162398_());
                }
                for (Direction face1 : Direction.values()) {
                    int k;
                    BlockState state1;
                    mutPos.m_122159_((Vec3i)pos2, face1);
                    if (set.contains(mutPos) || set1.contains(mutPos) || !(state1 = world.m_8055_((BlockPos)mutPos)).m_61138_((Property)BlockStateProperties.f_61414_) || (k = ((Integer)state1.m_61143_((Property)BlockStateProperties.f_61414_)).intValue()) <= l + 1) continue;
                    BlockState state2 = (BlockState)state1.m_61124_((Property)BlockStateProperties.f_61414_, (Comparable)Integer.valueOf(l + 1));
                    CherryFeatuer.setBlockKnownShape((LevelWriter)world, (BlockPos)mutPos, state2);
                    if (aabb.m_71051_((Vec3i)mutPos)) {
                        face.m_142703_(mutPos.m_123341_() - aabb.m_162395_(), mutPos.m_123342_() - aabb.m_162396_(), mutPos.m_123343_() - aabb.m_162398_());
                    }
                    set1.add(mutPos.m_7949_());
                }
            }
        }
        return face;
    }

    public void setSMBlock(WorldGenLevel world, BlockPos pos, BlockState state) {
        if (world.m_46859_(pos) && this.checkBlock(world.m_8055_(pos.m_7495_()).m_60734_())) {
            this.m_5974_((LevelWriter)world, pos, state);
        } else {
            BlockPos targetPos;
            int y;
            for (y = 1; y < 4; ++y) {
                targetPos = pos.m_6625_(y);
                if (!world.m_46859_(targetPos) || !this.checkBlock(world.m_8055_(targetPos.m_7495_()).m_60734_())) continue;
                this.m_5974_((LevelWriter)world, targetPos, state);
                return;
            }
            for (y = 1; y < 3; ++y) {
                targetPos = pos.m_6630_(y);
                if (!world.m_46859_(targetPos) || !this.checkBlock(world.m_8055_(targetPos.m_7495_()).m_60734_())) continue;
                this.m_5974_((LevelWriter)world, targetPos, state);
                return;
            }
        }
    }

    public boolean checkBlock(Block block) {
        return block == Blocks.f_50493_ || block == Blocks.f_50440_;
    }
}

